/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

package com.tridium.testng;

import static org.testng.Assert.*;

import java.util.Locale;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.test.BTestNg;
import javax.baja.ui.BWidgetApplication;

import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

import com.tridium.sys.Nre;
import com.tridium.ui.NullUiEnv;
import com.tridium.ui.UiEnv;

/**
 * Base class for tests that could include localization changes.
 * Note that any changes during a test to the Locale.setDefault or Sys.setLanguage() will be reverted as part of the standard cleanup.
 *
 * @author JJ Frankovich
 * @since Niagara 4.14
 */
@NiagaraType
public abstract class BBaseLocaleTest
  extends BTestNg
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $com.tridium.testng.BBaseLocaleTest(2979906276)1.0$ @*/
/* Generated Wed Aug 23 08:22:17 EDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBaseLocaleTest.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @BeforeMethod(alwaysRun = true)
  public void storeLocaleBeforeMethod()
  {
    oldDefaultLocaleForBeforeMethod = Locale.getDefault();
    oldSystemLanguageForBeforeMethod = Sys.getLanguage();
  }

  @AfterMethod(alwaysRun = true)
  public void restoreLocaleAfterMethod()
  {
    setDefaultLocale(oldDefaultLocaleForBeforeMethod);
    assertEquals(oldSystemLanguageForBeforeMethod, Sys.getLanguage(), "Language did not return to normal:" + oldSystemLanguageForBeforeMethod + " != " + Sys.getLanguage());
  }

  @BeforeClass(alwaysRun = true)
  public void storeLocaleBeforeClass()
  {
    oldDefaultLocaleForBeforeClass = Locale.getDefault();
    oldSystemLanguageForBeforeClass = Sys.getLanguage();
  }

  @AfterClass(alwaysRun = true)
  public void restoreLocaleAfterClass()
  {
    setDefaultLocale(oldDefaultLocaleForBeforeClass);
    assertEquals(oldSystemLanguageForBeforeClass, Sys.getLanguage(), "Language did not return to normal: " + oldSystemLanguageForBeforeClass + " != " + Sys.getLanguage());
  }

  /**
   * This method is recommended over Locale.setDefault() to ensure that if the locale is ever changed, the Sys.getLanguage() is changed to match.
   */
  public static void setDefaultLocale(Locale locale)
  {
    Nre.setDefaultLocale(locale);
  }


  private String oldSystemLanguageForBeforeMethod;
  private Locale oldDefaultLocaleForBeforeMethod;
  private String oldSystemLanguageForBeforeClass;
  private Locale oldDefaultLocaleForBeforeClass;
}
