/*
 * Copyright 2007, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.schedule;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIEnum;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BEnumScheduleSelector is a component that allows a user to
 * select the schedule that is controlling a particular component
 * from a list of preconfigured schedules.
 *
 * @author    John Huffman
 * @creation  20 June 2007
 * @version   $Revision: 1$ $Date: 6/28/07 3:38:37 PM EDT$
 * @since     Baja 1.0
 */
@NiagaraType
/*
 These facets are applied against the out property.
 */
@NiagaraProperty(
  name = "facets",
  type = "BFacets",
  defaultValue = "BFacets.makeEnum()"
)
/*
 An input to be linked to the selected schedule's output
 Setting the hidden flag causes a "ERROR: LinkStubGlyph.noTargetSlot: ..." message to display when
 we create the BLink
 */
@NiagaraProperty(
  name = "in",
  type = "BStatusEnum",
  defaultValue = "new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus)",
  flags = Flags.OPERATOR | Flags.TRANSIENT
)
/*
 An output that propagates the linked schedule's output
 */
@NiagaraProperty(
  name = "out",
  type = "BStatusEnum",
  defaultValue = "new BStatusEnum(BDynamicEnum.DEFAULT)",
  flags = Flags.OPERATOR | Flags.READONLY | Flags.TRANSIENT
)
/*
 nextTime to be linked to the selected schedule's nextTime property
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "nextTime",
  type = "BAbsTime",
  defaultValue = "BAbsTime.NULL",
  flags = Flags.OPERATOR | Flags.TRANSIENT
)
/*
 nextValue to be linked to the selected schedule's nextValue property
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "nextValue",
  type = "BStatusEnum",
  defaultValue = "new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus)",
  flags = Flags.OPERATOR | Flags.TRANSIENT
)
public class BEnumScheduleSelector
  extends BAbstractScheduleSelector
  implements BIStatus, BIEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.schedule.BEnumScheduleSelector(1061593837)1.0$ @*/
/* Generated Mon Jul 17 13:13:23 CDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "facets"

  /**
   * Slot for the {@code facets} property.
   * These facets are applied against the out property.
   * @see #getFacets
   * @see #setFacets
   */
  @Generated
  public static final Property facets = newProperty(0, BFacets.makeEnum(), null);

  /**
   * Get the {@code facets} property.
   * These facets are applied against the out property.
   * @see #facets
   */
  @Generated
  public BFacets getFacets() { return (BFacets)get(facets); }

  /**
   * Set the {@code facets} property.
   * These facets are applied against the out property.
   * @see #facets
   */
  @Generated
  public void setFacets(BFacets v) { set(facets, v, null); }

  //endregion Property "facets"

  //region Property "in"

  /**
   * Slot for the {@code in} property.
   * An input to be linked to the selected schedule's output
   * Setting the hidden flag causes a "ERROR: LinkStubGlyph.noTargetSlot: ..." message to display when
   * we create the BLink
   * @see #getIn
   * @see #setIn
   */
  @Generated
  public static final Property in = newProperty(Flags.OPERATOR | Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus), null);

  /**
   * Get the {@code in} property.
   * An input to be linked to the selected schedule's output
   * Setting the hidden flag causes a "ERROR: LinkStubGlyph.noTargetSlot: ..." message to display when
   * we create the BLink
   * @see #in
   */
  @Generated
  public BStatusEnum getIn() { return (BStatusEnum)get(in); }

  /**
   * Set the {@code in} property.
   * An input to be linked to the selected schedule's output
   * Setting the hidden flag causes a "ERROR: LinkStubGlyph.noTargetSlot: ..." message to display when
   * we create the BLink
   * @see #in
   */
  @Generated
  public void setIn(BStatusEnum v) { set(in, v, null); }

  //endregion Property "in"

  //region Property "out"

  /**
   * Slot for the {@code out} property.
   * An output that propagates the linked schedule's output
   * @see #getOut
   * @see #setOut
   */
  @Generated
  public static final Property out = newProperty(Flags.OPERATOR | Flags.READONLY | Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT), null);

  /**
   * Get the {@code out} property.
   * An output that propagates the linked schedule's output
   * @see #out
   */
  @Generated
  public BStatusEnum getOut() { return (BStatusEnum)get(out); }

  /**
   * Set the {@code out} property.
   * An output that propagates the linked schedule's output
   * @see #out
   */
  @Generated
  public void setOut(BStatusEnum v) { set(out, v, null); }

  //endregion Property "out"

  //region Property "nextTime"

  /**
   * Slot for the {@code nextTime} property.
   * nextTime to be linked to the selected schedule's nextTime property
   * @since Niagara 4.14
   * @see #getNextTime
   * @see #setNextTime
   */
  @Generated
  public static final Property nextTime = newProperty(Flags.OPERATOR | Flags.TRANSIENT, BAbsTime.NULL, null);

  /**
   * Get the {@code nextTime} property.
   * nextTime to be linked to the selected schedule's nextTime property
   * @since Niagara 4.14
   * @see #nextTime
   */
  @Generated
  public BAbsTime getNextTime() { return (BAbsTime)get(nextTime); }

  /**
   * Set the {@code nextTime} property.
   * nextTime to be linked to the selected schedule's nextTime property
   * @since Niagara 4.14
   * @see #nextTime
   */
  @Generated
  public void setNextTime(BAbsTime v) { set(nextTime, v, null); }

  //endregion Property "nextTime"

  //region Property "nextValue"

  /**
   * Slot for the {@code nextValue} property.
   * nextValue to be linked to the selected schedule's nextValue property
   * @since Niagara 4.14
   * @see #getNextValue
   * @see #setNextValue
   */
  @Generated
  public static final Property nextValue = newProperty(Flags.OPERATOR | Flags.TRANSIENT, new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus), null);

  /**
   * Get the {@code nextValue} property.
   * nextValue to be linked to the selected schedule's nextValue property
   * @since Niagara 4.14
   * @see #nextValue
   */
  @Generated
  public BStatusEnum getNextValue() { return (BStatusEnum)get(nextValue); }

  /**
   * Set the {@code nextValue} property.
   * nextValue to be linked to the selected schedule's nextValue property
   * @since Niagara 4.14
   * @see #nextValue
   */
  @Generated
  public void setNextValue(BStatusEnum v) { set(nextValue, v, null); }

  //endregion Property "nextValue"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BEnumScheduleSelector.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BEnumScheduleSelector()
  {
  }

  /**
   * handle any properties that have changed
   */
  @Override
  public void changed(Property p, Context cx)
  {
    if ( ( cx == noWriteContext ) || ( cx == Context.decoding ) || ( !isRunning() ) )
      return;

    super.changed( p, cx );

    if ( p.equals( in ) )
    {
      // update the 'out' property based on the value of the 'in' property
      updateOut();
    }
  }

  /**
   * Apply the "facets" property to the "out" property.
   */
  @Override
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.equals(in) || slot.equals(out) || slot.equals(nextValue))
    {
      return getFacets();
    }
    return super.getSlotFacets(slot);
  }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  @Override
  public BStatus getStatus() { return getOut().getStatus(); }

////////////////////////////////////////////////////////////////
// BIEnum interface
////////////////////////////////////////////////////////////////

  /**
   * Return the vaule as a enum.
   */
  @Override
  public final BEnum getEnum() { return getOut().getEnum(); }

  @Override
  public final BFacets getEnumFacets() { return getFacets(); }
}
