/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.nrio.components;

import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;

/**
 * BNrioLearnDeviceEntry - The learn devices job places instances of this component
 * under the learned devices folder on the network.
 *
 * @author    Andy Saunders on Nov 17, 2005
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
@NiagaraType
/*
 This is the unit number of the discovered access device
 */
@NiagaraProperty(
  name = "address",
  type = "int",
  defaultValue = "0"
)
/*
 This is the unit number of the discovered access device
 */
@NiagaraProperty(
  name = "uid",
  type = "BBlob",
  defaultValue = "BBlob.DEFAULT"
)
/*
 This is the type of this device
 */
@NiagaraProperty(
  name = "deviceType",
  type = "BNrioDeviceTypeEnum",
  defaultValue = "BNrioDeviceTypeEnum.none"
)
@NiagaraProperty(
  name = "version",
  type = "String",
  defaultValue = ""
)
@NiagaraProperty(
  name = "usedBy",
  type = "String",
  defaultValue = ""
)
/*
 This is the address of the secondary device if a IO34 module
 */
@NiagaraProperty(
  name = "secAddr",
  type = "String",
  defaultValue = ""
)
public class BNrioLearnDeviceEntry
  extends BComponent
{

//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $com.tridium.nrio.components.BNrioLearnDeviceEntry(4133632428)1.0$ @*/
/* Generated Thu Jun 02 14:30:04 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "address"

  /**
   * Slot for the {@code address} property.
   * This is the unit number of the discovered access device
   * @see #getAddress
   * @see #setAddress
   */
  @Generated
  public static final Property address = newProperty(0, 0, null);

  /**
   * Get the {@code address} property.
   * This is the unit number of the discovered access device
   * @see #address
   */
  @Generated
  public int getAddress() { return getInt(address); }

  /**
   * Set the {@code address} property.
   * This is the unit number of the discovered access device
   * @see #address
   */
  @Generated
  public void setAddress(int v) { setInt(address, v, null); }

  //endregion Property "address"

  //region Property "uid"

  /**
   * Slot for the {@code uid} property.
   * This is the unit number of the discovered access device
   * @see #getUid
   * @see #setUid
   */
  @Generated
  public static final Property uid = newProperty(0, BBlob.DEFAULT, null);

  /**
   * Get the {@code uid} property.
   * This is the unit number of the discovered access device
   * @see #uid
   */
  @Generated
  public BBlob getUid() { return (BBlob)get(uid); }

  /**
   * Set the {@code uid} property.
   * This is the unit number of the discovered access device
   * @see #uid
   */
  @Generated
  public void setUid(BBlob v) { set(uid, v, null); }

  //endregion Property "uid"

  //region Property "deviceType"

  /**
   * Slot for the {@code deviceType} property.
   * This is the type of this device
   * @see #getDeviceType
   * @see #setDeviceType
   */
  @Generated
  public static final Property deviceType = newProperty(0, BNrioDeviceTypeEnum.none, null);

  /**
   * Get the {@code deviceType} property.
   * This is the type of this device
   * @see #deviceType
   */
  @Generated
  public BNrioDeviceTypeEnum getDeviceType() { return (BNrioDeviceTypeEnum)get(deviceType); }

  /**
   * Set the {@code deviceType} property.
   * This is the type of this device
   * @see #deviceType
   */
  @Generated
  public void setDeviceType(BNrioDeviceTypeEnum v) { set(deviceType, v, null); }

  //endregion Property "deviceType"

  //region Property "version"

  /**
   * Slot for the {@code version} property.
   * @see #getVersion
   * @see #setVersion
   */
  @Generated
  public static final Property version = newProperty(0, "", null);

  /**
   * Get the {@code version} property.
   * @see #version
   */
  @Generated
  public String getVersion() { return getString(version); }

  /**
   * Set the {@code version} property.
   * @see #version
   */
  @Generated
  public void setVersion(String v) { setString(version, v, null); }

  //endregion Property "version"

  //region Property "usedBy"

  /**
   * Slot for the {@code usedBy} property.
   * @see #getUsedBy
   * @see #setUsedBy
   */
  @Generated
  public static final Property usedBy = newProperty(0, "", null);

  /**
   * Get the {@code usedBy} property.
   * @see #usedBy
   */
  @Generated
  public String getUsedBy() { return getString(usedBy); }

  /**
   * Set the {@code usedBy} property.
   * @see #usedBy
   */
  @Generated
  public void setUsedBy(String v) { setString(usedBy, v, null); }

  //endregion Property "usedBy"

  //region Property "secAddr"

  /**
   * Slot for the {@code secAddr} property.
   * This is the address of the secondary device if a IO34 module
   * @see #getSecAddr
   * @see #setSecAddr
   */
  @Generated
  public static final Property secAddr = newProperty(0, "", null);

  /**
   * Get the {@code secAddr} property.
   * This is the address of the secondary device if a IO34 module
   * @see #secAddr
   */
  @Generated
  public String getSecAddr() { return getString(secAddr); }

  /**
   * Set the {@code secAddr} property.
   * This is the address of the secondary device if a IO34 module
   * @see #secAddr
   */
  @Generated
  public void setSecAddr(String v) { setString(secAddr, v, null); }

  //endregion Property "secAddr"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BNrioLearnDeviceEntry.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BNrioLearnDeviceEntry(int address, BNrioDeviceTypeEnum type, byte[] uid, String version, String usedBy, int secAddr)
  {
    setAddress(address);
    setDeviceType(type);
    setUid(BBlob.make(uid));
    setVersion(version);
    setUsedBy(usedBy);
    if(secAddr > 0)
    {
      setSecAddr(Integer.toString(secAddr));
    }
  }

  public BNrioLearnDeviceEntry(int address, BNrioDeviceTypeEnum type, byte[] uid, String version, String usedBy)
  {
    setAddress(address);
    setDeviceType(type);
    setUid(BBlob.make(uid));
    setVersion(version);
    setUsedBy(usedBy);
  }

  public BNrioLearnDeviceEntry(int address, BNrioDeviceTypeEnum type, byte[] uid)
  {
    setAddress(address);
    setDeviceType(type);
    setUid(BBlob.make(uid));
  }
  public BNrioLearnDeviceEntry(){}

  public String getDefaultAddAddress()
  {
    switch (getDeviceType().getOrdinal())
    {
      case BNrioDeviceTypeEnum.IO_16:
        return getDeviceType().getTag() + "_" + getAddress();
      case BNrioDeviceTypeEnum.IO_34:
        return getDeviceType().getTag() + "_" + getAddress() + "_" + getSecAddr();
      default:
        return getDeviceType().getTag() + "_" + getAddress();
    }
  }

  public boolean isMatchable(BComponent device)
  {
    if(!(device instanceof BNrioDevice) )
    {
      return false;
    }
    BNrioDevice dbDevice = (BNrioDevice)device;
    if( !(dbDevice.getDeviceType().isMatchable(getDeviceType())) )
    {
      return false;
    }
    //System.out.println("********** Learn device entry.isMatchable(): " + device.getName() + " isDown() = " + dbDevice.isDown());
    return dbDevice.isDown() ||
           dbDevice.getAddress() == 0;
  }

  public int getSecAddrInt()
  {
    String secAddr = getSecAddr();
    int addr = -1;
    try{addr = Integer.parseInt(secAddr);} catch(Exception ignore) {}
    return addr;
  }

  public boolean isWinkActive()
  {
    return winkActive;
  }
  
  public void doWinkDevice(BNrioNetwork network, Context cx)
  {
    this.network = network;
    if(!winkActive)
    {
      Thread winkThread = new RunWink(cx);
      winkValue = 1;
      winkActive = true;
      network.invoke(BNrioNetwork.enableWinking, this, cx);
      winkThread.start();
      this.set(BNrioLearnDeviceEntry.usedBy, BString.make(lex.get("winking")), cx);
    }
    else
    {
      winkActive = false;
      network.invoke(BNrioNetwork.disableWinking, this, cx);
      this.set(BNrioLearnDeviceEntry.usedBy, BString.DEFAULT, cx);
    }
  }

  /**
   * Exposes the doWinkDevice process to clients via a RPC call
   * @since Niagara 4.14
   * @param networkOrd A String value that can be resolved to the network.
   * @param cx The context of the current session
   * @throws PermissionException a permission error that is thrown if the current context does not
   *  have permission to invoke
   */
  @NiagaraRpc(
    permissions = "W",
    transports = {
      @Transport(type = TransportType.box)
    }
  )
  public void doWinkDevice(String networkOrd, Context cx)
  {
    OrdTarget networkOrdTarget = BOrd.make(networkOrd).resolve(this, cx);

    doWinkDevice(networkOrdTarget, cx);
  }

  public void doWinkDevice(OrdTarget networkOrdTarget, Context cx) {
    if (!networkOrdTarget.canInvoke()) {
      throw new PermissionException("can not invoke wink");
    }

    doWinkDevice((BNrioNetwork) networkOrdTarget.get(), cx);
  }

  public void stopWink(Context cx)
  {
    if(winkActive)
    {
      network.invoke(BNrioNetwork.disableWinking, this, cx);
    }
    winkActive = false;
    if(getUsedBy().equals(lex.get("winking")))
    {
      this.set(BNrioLearnDeviceEntry.usedBy, BString.DEFAULT, cx);
    }
  }

  private class RunWink extends Thread
  {
    private RunWink(Context cx)
    {
      this.cx = cx;
    }
    @Override
    public void run()
    {
      int count = 0;
      while(winkActive)
      {
        if(winkValue == 0)
        {
          winkValue = 1;
        } else
        {
          winkValue = 0;
        }

        network.invoke(BNrioNetwork.winkDevice, BInteger.make( (getAddress() << 8) | winkValue ), cx);
        try{ Thread.sleep(WINK_CYCLE); }
        catch(Exception ignore) {}
        winkActive = (++count <= WINK_COUNT);
      }
      BNrioLearnDeviceEntry.this.set(BNrioLearnDeviceEntry.usedBy, BString.DEFAULT, cx);
      network.invoke(BNrioNetwork.disableWinking, BNrioLearnDeviceEntry.this, cx);
    }
    private final Context cx;
  }

  public  static Lexicon lex = Lexicon.make(BNrioLearnDeviceEntry.class);

  private static final int WINK_COUNT = 20;   // number of wink state changes (10 sec)
  private static final long WINK_CYCLE = 500; // wink state change time in ms

  private BNrioNetwork network;
  private static boolean winkActive = false;
  private int winkValue = 0;
 

}
