/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */

package com.tridium.ndriver.datatypes;

import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ndriver.util.SfUtil;

/**
 * This extends the javax.baja.security.BUsernameAndPassword to add auto manager
 * include facets.
 *
 * @author Robert Adams
 * @creation 5 Jun 12
 * @since Niagara 3.7
 */
@NiagaraType
@NiagaraProperty(
  name = "username",
  type = "BString",
  defaultValue = "BString.DEFAULT",
  facets = @Facet("SfUtil.incl(SfUtil.MGR_EDIT)"),
  override = true
)
@NiagaraProperty(
  name = "password",
  type = "BPassword",
  defaultValue = "BPassword.DEFAULT",
  facets = @Facet("SfUtil.incl(SfUtil.MGR_EDIT)"),
  override = true
)
public class BNUsernameAndPassword
  extends BUsernameAndPassword
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $com.tridium.ndriver.datatypes.BNUsernameAndPassword(4067912589)1.0$ @*/
/* Generated Thu Jun 02 14:30:03 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "username"

  /**
   * Slot for the {@code username} property.
   * @see #getUsername
   * @see #setUsername
   */
  @Generated
  public static final Property username = newProperty(0, BString.DEFAULT, SfUtil.incl(SfUtil.MGR_EDIT));

  //endregion Property "username"

  //region Property "password"

  /**
   * Slot for the {@code password} property.
   * @see #getPassword
   * @see #setPassword
   */
  @Generated
  public static final Property password = newProperty(0, BPassword.DEFAULT, SfUtil.incl(SfUtil.MGR_EDIT));

  //endregion Property "password"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BNUsernameAndPassword.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


  @Override
  public String toString(Context context)
  {
    return "[ " + getUsername() + " / ... ]";
  }

}
