/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonSnvtType class provides an enumeration for
 * all standard SNVT types
 *
 * @author Robert Adams on 14 Jan 01
 * @since Niagara 3.0
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("SnvtXxx"),
    @Range("SnvtAmp"),
    @Range("SnvtAmpMil"),
    @Range("SnvtAngle"),
    @Range("SnvtAngleVel"),
    @Range("SnvtBtuKilo"),
    @Range("SnvtBtuMega"),
    @Range("SnvtCharAscii"),
    @Range("SnvtCount"),
    @Range("SnvtCountInc"),
    @Range("SnvtDateCal"),
    @Range("SnvtDateDay"),
    @Range("SnvtDateTime"),
    @Range("SnvtElecKwh"),
    @Range("SnvtElecWhr"),
    @Range("SnvtFlow"),
    @Range("SnvtFlowMil"),
    @Range("SnvtLength"),
    @Range("SnvtLengthKilo"),
    @Range("SnvtLengthMicr"),
    @Range("SnvtLengthMil"),
    @Range("SnvtLevCont"),
    @Range("SnvtLevDisc"),
    @Range("SnvtMass"),
    @Range("SnvtMassKilo"),
    @Range("SnvtMassMega"),
    @Range("SnvtMassMil"),
    @Range("SnvtPower"),
    @Range("SnvtPowerKilo"),
    @Range("SnvtPpm"),
    @Range("SnvtPress"),
    @Range("SnvtRes"),
    @Range("SnvtResKilo"),
    @Range("SnvtSoundDb"),
    @Range("SnvtSpeed"),
    @Range("SnvtSpeedMil"),
    @Range("SnvtStrAsc"),
    @Range("SnvtStrInt"),
    @Range("SnvtTelcom"),
    @Range("SnvtTemp"),
    @Range("SnvtTimePassed"),
    @Range("SnvtVol"),
    @Range("SnvtVolKilo"),
    @Range("SnvtVolMil"),
    @Range("SnvtVolt"),
    @Range("SnvtVoltDbmv"),
    @Range("SnvtVoltKilo"),
    @Range("SnvtVoltMil"),
    @Range("SnvtAmpF"),
    @Range("SnvtAngleF"),
    @Range("SnvtAngleVelF"),
    @Range("SnvtCountF"),
    @Range("SnvtCountIncF"),
    @Range("SnvtFlowF"),
    @Range("SnvtLengthF"),
    @Range("SnvtLevContF"),
    @Range("SnvtMassF"),
    @Range("SnvtPowerF"),
    @Range("SnvtPpmF"),
    @Range("SnvtPressF"),
    @Range("SnvtResF"),
    @Range("SnvtSoundDbF"),
    @Range("SnvtSpeedF"),
    @Range("SnvtTempF"),
    @Range("SnvtTimeF"),
    @Range("SnvtVolF"),
    @Range("SnvtVoltF"),
    @Range("SnvtBtuF"),
    @Range("SnvtElecWhrF"),
    @Range("SnvtConfigSrc"),
    @Range("SnvtColor"),
    @Range("SnvtGrammage"),
    @Range("SnvtGrammageF"),
    @Range("SnvtFileReq"),
    @Range("SnvtFileStatus"),
    @Range("SnvtFreqF"),
    @Range("SnvtFreqHz"),
    @Range("SnvtFreqKilohz"),
    @Range("SnvtFreqMilhz"),
    @Range("SnvtLux"),
    @Range("SnvtIso7811"),
    @Range("SnvtLevPercent"),
    @Range("SnvtMultiplier"),
    @Range("SnvtState"),
    @Range("SnvtTimeStamp"),
    @Range("SnvtZerospan"),
    @Range("SnvtMagcard"),
    @Range("SnvtElapsedTm"),
    @Range("SnvtAlarm"),
    @Range("SnvtCurrency"),
    @Range("SnvtFilePos"),
    @Range("SnvtMuldiv"),
    @Range("SnvtObjRequest"),
    @Range("SnvtObjStatus"),
    @Range("SnvtPreset"),
    @Range("SnvtSwitch"),
    @Range("SnvtTransTable"),
    @Range("SnvtOverride"),
    @Range("SnvtPwrFact"),
    @Range("SnvtPwrFactF"),
    @Range("SnvtDensity"),
    @Range("SnvtDensityF"),
    @Range("SnvtRpm"),
    @Range("SnvtHvacEmerg"),
    @Range("SnvtAngleDeg"),
    @Range("SnvtTempP"),
    @Range("SnvtTempSetpt"),
    @Range("SnvtTimeSec"),
    @Range("SnvtHvacMode"),
    @Range("SnvtOccupancy"),
    @Range("SnvtArea"),
    @Range("SnvtHvacOverid"),
    @Range("SnvtHvacStatus"),
    @Range("SnvtPressP"),
    @Range("SnvtAddress"),
    @Range("SnvtScene"),
    @Range("SnvtSceneCfg"),
    @Range("SnvtSetting"),
    @Range("SnvtEvapState"),
    @Range("SnvtThermMode"),
    @Range("SnvtDefrMode"),
    @Range("SnvtDefrTerm"),
    @Range("SnvtDefrState"),
    @Range("SnvtTimeMin"),
    @Range("SnvtTimeHour"),
    @Range("SnvtPh"),
    @Range("SnvtPhF"),
    @Range("SnvtChlrStatus"),
    @Range("SnvtTodEvent"),
    @Range("SnvtSmoObscur"),
    @Range("SnvtFireTest"),
    @Range("SnvtTempRor"),
    @Range("SnvtFireInit"),
    @Range("SnvtFireIndcte"),
    @Range("SnvtTimeZone"),
    @Range("SnvtEarthPos"),
    @Range("SnvtRegVal"),
    @Range("SnvtRegValTs"),
    @Range("SnvtVoltAc"),
    @Range("SnvtAmpAc"),
    @Range(value = "SnvtTurbidity", ordinal = 143),
    @Range(value = "SnvtTurbidityF", ordinal = 144),
    @Range(value = "SnvtHvacType", ordinal = 145),
    @Range(value = "SnvtElecKwhL", ordinal = 146),
    @Range(value = "SnvtTempDiffP", ordinal = 147),
    @Range(value = "SnvtCtrlReq", ordinal = 148),
    @Range(value = "SnvtCtrlResp", ordinal = 149),
    @Range(value = "SnvtPtz", ordinal = 150),
    @Range(value = "SnvtPrivacyzone", ordinal = 151),
    @Range(value = "SnvtPosCtrl", ordinal = 152),
    @Range(value = "SnvtEnthalpy", ordinal = 153),
    @Range(value = "SnvtGfciStatus", ordinal = 154),
    @Range(value = "SnvtMotorState", ordinal = 155),
    @Range(value = "SnvtPumpsetMn", ordinal = 156),
    @Range(value = "SnvtExControl", ordinal = 157),
    @Range(value = "SnvtPumpsetSn", ordinal = 158),
    @Range(value = "SnvtPumpSensor", ordinal = 159),
    @Range(value = "SnvtAbsHumid", ordinal = 160),
    @Range(value = "SnvtFlowP", ordinal = 161),
    @Range(value = "SnvtDevCMode", ordinal = 162),
    @Range(value = "SnvtValveMode", ordinal = 163),
    @Range(value = "SnvtAlarm2", ordinal = 164),
    @Range(value = "SnvtState64", ordinal = 165),
    @Range(value = "SnvtNvType", ordinal = 166),
    @Range(value = "SnvtEntOpmode", ordinal = 168),
    @Range(value = "SnvtEntState", ordinal = 169),
    @Range(value = "SnvtEntStatus", ordinal = 170),
    @Range(value = "SnvtFlowDir", ordinal = 171),
    @Range(value = "SnvtHvacSatsts", ordinal = 172),
    @Range(value = "SnvtDevStatus", ordinal = 173),
    @Range(value = "SnvtDevFault", ordinal = 174),
    @Range(value = "SnvtDevMaint", ordinal = 175),
    @Range(value = "SnvtDateEvent", ordinal = 176),
    @Range(value = "SnvtSchedVal", ordinal = 177),
    @Range(value = "SnvtSecState", ordinal = 178),
    @Range(value = "SnvtSecStatus", ordinal = 179),
    @Range(value = "SnvtSblndState", ordinal = 180),
    @Range(value = "SnvtRacCtrl", ordinal = 181),
    @Range(value = "SnvtRacReq", ordinal = 182),
    @Range(value = "SnvtCount32", ordinal = 183),
    @Range(value = "SnvtClothesWC", ordinal = 184),
    @Range(value = "SnvtClothesWM", ordinal = 185),
    @Range(value = "SnvtClothesWS", ordinal = 186),
    @Range(value = "SnvtClothesWA", ordinal = 187),
    @Range(value = "SnvtMultiplierS", ordinal = 188),
    @Range(value = "SnvtSwitch2", ordinal = 189),
    @Range(value = "SnvtColor2", ordinal = 190),
    @Range(value = "SnvtLogStatus", ordinal = 191),
    @Range(value = "SnvtTimeStampP", ordinal = 192),
    @Range(value = "SnvtLogFxRequest", ordinal = 193),
    @Range(value = "SnvtLogFxStatus", ordinal = 194),
    @Range(value = "SnvtLogRequest", ordinal = 195),
    @Range(value = "SnvtEnthalpyD", ordinal = 196),
    @Range(value = "SnvtAmpAcMil", ordinal = 197),
    @Range(value = "SnvtTimeHourP", ordinal = 198),
    @Range(value = "SnvtLampStatus", ordinal = 199),
    @Range(value = "SnvtEnvironment", ordinal = 200),
    @Range(value = "SnvtGeoLoc", ordinal = 201),
    @Range(value = "SnvtProgramStatus", ordinal = 202),
    @Range(value = "SnvtLoadOffsets", ordinal = 203),
    @Range(value = "SnvtWm2P", ordinal = 204),
    @Range(value = "SnvtSafe1", ordinal = 205),
    @Range(value = "SnvtSafe2", ordinal = 206),
    @Range(value = "SnvtSafe4", ordinal = 207),
    @Range(value = "SnvtSafe8", ordinal = 208),
    @Range(value = "SnvtTimeVal2", ordinal = 209),
    @Range(value = "SnvtTimeOffset", ordinal = 210),
    @Range(value = "SnvtSchedExc", ordinal = 211),
    @Range(value = "SnvtSchedStatus", ordinal = 212),
    @Range(value = "SnvtMassFlow", ordinal = 213),
    @Range(value = "SnvtMassFlowF", ordinal = 214)
  }
)
public final class BLonSnvtType
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.lonworks.enums.BLonSnvtType(2751293399)1.0$ @*/
/* Generated Tue Jun 06 14:04:02 EDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  /** Ordinal value for SnvtXxx. */
  @Generated
  public static final int SNVT_XXX = 0;
  /** Ordinal value for SnvtAmp. */
  @Generated
  public static final int SNVT_AMP = 1;
  /** Ordinal value for SnvtAmpMil. */
  @Generated
  public static final int SNVT_AMP_MIL = 2;
  /** Ordinal value for SnvtAngle. */
  @Generated
  public static final int SNVT_ANGLE = 3;
  /** Ordinal value for SnvtAngleVel. */
  @Generated
  public static final int SNVT_ANGLE_VEL = 4;
  /** Ordinal value for SnvtBtuKilo. */
  @Generated
  public static final int SNVT_BTU_KILO = 5;
  /** Ordinal value for SnvtBtuMega. */
  @Generated
  public static final int SNVT_BTU_MEGA = 6;
  /** Ordinal value for SnvtCharAscii. */
  @Generated
  public static final int SNVT_CHAR_ASCII = 7;
  /** Ordinal value for SnvtCount. */
  @Generated
  public static final int SNVT_COUNT = 8;
  /** Ordinal value for SnvtCountInc. */
  @Generated
  public static final int SNVT_COUNT_INC = 9;
  /** Ordinal value for SnvtDateCal. */
  @Generated
  public static final int SNVT_DATE_CAL = 10;
  /** Ordinal value for SnvtDateDay. */
  @Generated
  public static final int SNVT_DATE_DAY = 11;
  /** Ordinal value for SnvtDateTime. */
  @Generated
  public static final int SNVT_DATE_TIME = 12;
  /** Ordinal value for SnvtElecKwh. */
  @Generated
  public static final int SNVT_ELEC_KWH = 13;
  /** Ordinal value for SnvtElecWhr. */
  @Generated
  public static final int SNVT_ELEC_WHR = 14;
  /** Ordinal value for SnvtFlow. */
  @Generated
  public static final int SNVT_FLOW = 15;
  /** Ordinal value for SnvtFlowMil. */
  @Generated
  public static final int SNVT_FLOW_MIL = 16;
  /** Ordinal value for SnvtLength. */
  @Generated
  public static final int SNVT_LENGTH = 17;
  /** Ordinal value for SnvtLengthKilo. */
  @Generated
  public static final int SNVT_LENGTH_KILO = 18;
  /** Ordinal value for SnvtLengthMicr. */
  @Generated
  public static final int SNVT_LENGTH_MICR = 19;
  /** Ordinal value for SnvtLengthMil. */
  @Generated
  public static final int SNVT_LENGTH_MIL = 20;
  /** Ordinal value for SnvtLevCont. */
  @Generated
  public static final int SNVT_LEV_CONT = 21;
  /** Ordinal value for SnvtLevDisc. */
  @Generated
  public static final int SNVT_LEV_DISC = 22;
  /** Ordinal value for SnvtMass. */
  @Generated
  public static final int SNVT_MASS = 23;
  /** Ordinal value for SnvtMassKilo. */
  @Generated
  public static final int SNVT_MASS_KILO = 24;
  /** Ordinal value for SnvtMassMega. */
  @Generated
  public static final int SNVT_MASS_MEGA = 25;
  /** Ordinal value for SnvtMassMil. */
  @Generated
  public static final int SNVT_MASS_MIL = 26;
  /** Ordinal value for SnvtPower. */
  @Generated
  public static final int SNVT_POWER = 27;
  /** Ordinal value for SnvtPowerKilo. */
  @Generated
  public static final int SNVT_POWER_KILO = 28;
  /** Ordinal value for SnvtPpm. */
  @Generated
  public static final int SNVT_PPM = 29;
  /** Ordinal value for SnvtPress. */
  @Generated
  public static final int SNVT_PRESS = 30;
  /** Ordinal value for SnvtRes. */
  @Generated
  public static final int SNVT_RES = 31;
  /** Ordinal value for SnvtResKilo. */
  @Generated
  public static final int SNVT_RES_KILO = 32;
  /** Ordinal value for SnvtSoundDb. */
  @Generated
  public static final int SNVT_SOUND_DB = 33;
  /** Ordinal value for SnvtSpeed. */
  @Generated
  public static final int SNVT_SPEED = 34;
  /** Ordinal value for SnvtSpeedMil. */
  @Generated
  public static final int SNVT_SPEED_MIL = 35;
  /** Ordinal value for SnvtStrAsc. */
  @Generated
  public static final int SNVT_STR_ASC = 36;
  /** Ordinal value for SnvtStrInt. */
  @Generated
  public static final int SNVT_STR_INT = 37;
  /** Ordinal value for SnvtTelcom. */
  @Generated
  public static final int SNVT_TELCOM = 38;
  /** Ordinal value for SnvtTemp. */
  @Generated
  public static final int SNVT_TEMP = 39;
  /** Ordinal value for SnvtTimePassed. */
  @Generated
  public static final int SNVT_TIME_PASSED = 40;
  /** Ordinal value for SnvtVol. */
  @Generated
  public static final int SNVT_VOL = 41;
  /** Ordinal value for SnvtVolKilo. */
  @Generated
  public static final int SNVT_VOL_KILO = 42;
  /** Ordinal value for SnvtVolMil. */
  @Generated
  public static final int SNVT_VOL_MIL = 43;
  /** Ordinal value for SnvtVolt. */
  @Generated
  public static final int SNVT_VOLT = 44;
  /** Ordinal value for SnvtVoltDbmv. */
  @Generated
  public static final int SNVT_VOLT_DBMV = 45;
  /** Ordinal value for SnvtVoltKilo. */
  @Generated
  public static final int SNVT_VOLT_KILO = 46;
  /** Ordinal value for SnvtVoltMil. */
  @Generated
  public static final int SNVT_VOLT_MIL = 47;
  /** Ordinal value for SnvtAmpF. */
  @Generated
  public static final int SNVT_AMP_F = 48;
  /** Ordinal value for SnvtAngleF. */
  @Generated
  public static final int SNVT_ANGLE_F = 49;
  /** Ordinal value for SnvtAngleVelF. */
  @Generated
  public static final int SNVT_ANGLE_VEL_F = 50;
  /** Ordinal value for SnvtCountF. */
  @Generated
  public static final int SNVT_COUNT_F = 51;
  /** Ordinal value for SnvtCountIncF. */
  @Generated
  public static final int SNVT_COUNT_INC_F = 52;
  /** Ordinal value for SnvtFlowF. */
  @Generated
  public static final int SNVT_FLOW_F = 53;
  /** Ordinal value for SnvtLengthF. */
  @Generated
  public static final int SNVT_LENGTH_F = 54;
  /** Ordinal value for SnvtLevContF. */
  @Generated
  public static final int SNVT_LEV_CONT_F = 55;
  /** Ordinal value for SnvtMassF. */
  @Generated
  public static final int SNVT_MASS_F = 56;
  /** Ordinal value for SnvtPowerF. */
  @Generated
  public static final int SNVT_POWER_F = 57;
  /** Ordinal value for SnvtPpmF. */
  @Generated
  public static final int SNVT_PPM_F = 58;
  /** Ordinal value for SnvtPressF. */
  @Generated
  public static final int SNVT_PRESS_F = 59;
  /** Ordinal value for SnvtResF. */
  @Generated
  public static final int SNVT_RES_F = 60;
  /** Ordinal value for SnvtSoundDbF. */
  @Generated
  public static final int SNVT_SOUND_DB_F = 61;
  /** Ordinal value for SnvtSpeedF. */
  @Generated
  public static final int SNVT_SPEED_F = 62;
  /** Ordinal value for SnvtTempF. */
  @Generated
  public static final int SNVT_TEMP_F = 63;
  /** Ordinal value for SnvtTimeF. */
  @Generated
  public static final int SNVT_TIME_F = 64;
  /** Ordinal value for SnvtVolF. */
  @Generated
  public static final int SNVT_VOL_F = 65;
  /** Ordinal value for SnvtVoltF. */
  @Generated
  public static final int SNVT_VOLT_F = 66;
  /** Ordinal value for SnvtBtuF. */
  @Generated
  public static final int SNVT_BTU_F = 67;
  /** Ordinal value for SnvtElecWhrF. */
  @Generated
  public static final int SNVT_ELEC_WHR_F = 68;
  /** Ordinal value for SnvtConfigSrc. */
  @Generated
  public static final int SNVT_CONFIG_SRC = 69;
  /** Ordinal value for SnvtColor. */
  @Generated
  public static final int SNVT_COLOR = 70;
  /** Ordinal value for SnvtGrammage. */
  @Generated
  public static final int SNVT_GRAMMAGE = 71;
  /** Ordinal value for SnvtGrammageF. */
  @Generated
  public static final int SNVT_GRAMMAGE_F = 72;
  /** Ordinal value for SnvtFileReq. */
  @Generated
  public static final int SNVT_FILE_REQ = 73;
  /** Ordinal value for SnvtFileStatus. */
  @Generated
  public static final int SNVT_FILE_STATUS = 74;
  /** Ordinal value for SnvtFreqF. */
  @Generated
  public static final int SNVT_FREQ_F = 75;
  /** Ordinal value for SnvtFreqHz. */
  @Generated
  public static final int SNVT_FREQ_HZ = 76;
  /** Ordinal value for SnvtFreqKilohz. */
  @Generated
  public static final int SNVT_FREQ_KILOHZ = 77;
  /** Ordinal value for SnvtFreqMilhz. */
  @Generated
  public static final int SNVT_FREQ_MILHZ = 78;
  /** Ordinal value for SnvtLux. */
  @Generated
  public static final int SNVT_LUX = 79;
  /** Ordinal value for SnvtIso7811. */
  @Generated
  public static final int SNVT_ISO_7811 = 80;
  /** Ordinal value for SnvtLevPercent. */
  @Generated
  public static final int SNVT_LEV_PERCENT = 81;
  /** Ordinal value for SnvtMultiplier. */
  @Generated
  public static final int SNVT_MULTIPLIER = 82;
  /** Ordinal value for SnvtState. */
  @Generated
  public static final int SNVT_STATE = 83;
  /** Ordinal value for SnvtTimeStamp. */
  @Generated
  public static final int SNVT_TIME_STAMP = 84;
  /** Ordinal value for SnvtZerospan. */
  @Generated
  public static final int SNVT_ZEROSPAN = 85;
  /** Ordinal value for SnvtMagcard. */
  @Generated
  public static final int SNVT_MAGCARD = 86;
  /** Ordinal value for SnvtElapsedTm. */
  @Generated
  public static final int SNVT_ELAPSED_TM = 87;
  /** Ordinal value for SnvtAlarm. */
  @Generated
  public static final int SNVT_ALARM = 88;
  /** Ordinal value for SnvtCurrency. */
  @Generated
  public static final int SNVT_CURRENCY = 89;
  /** Ordinal value for SnvtFilePos. */
  @Generated
  public static final int SNVT_FILE_POS = 90;
  /** Ordinal value for SnvtMuldiv. */
  @Generated
  public static final int SNVT_MULDIV = 91;
  /** Ordinal value for SnvtObjRequest. */
  @Generated
  public static final int SNVT_OBJ_REQUEST = 92;
  /** Ordinal value for SnvtObjStatus. */
  @Generated
  public static final int SNVT_OBJ_STATUS = 93;
  /** Ordinal value for SnvtPreset. */
  @Generated
  public static final int SNVT_PRESET = 94;
  /** Ordinal value for SnvtSwitch. */
  @Generated
  public static final int SNVT_SWITCH = 95;
  /** Ordinal value for SnvtTransTable. */
  @Generated
  public static final int SNVT_TRANS_TABLE = 96;
  /** Ordinal value for SnvtOverride. */
  @Generated
  public static final int SNVT_OVERRIDE = 97;
  /** Ordinal value for SnvtPwrFact. */
  @Generated
  public static final int SNVT_PWR_FACT = 98;
  /** Ordinal value for SnvtPwrFactF. */
  @Generated
  public static final int SNVT_PWR_FACT_F = 99;
  /** Ordinal value for SnvtDensity. */
  @Generated
  public static final int SNVT_DENSITY = 100;
  /** Ordinal value for SnvtDensityF. */
  @Generated
  public static final int SNVT_DENSITY_F = 101;
  /** Ordinal value for SnvtRpm. */
  @Generated
  public static final int SNVT_RPM = 102;
  /** Ordinal value for SnvtHvacEmerg. */
  @Generated
  public static final int SNVT_HVAC_EMERG = 103;
  /** Ordinal value for SnvtAngleDeg. */
  @Generated
  public static final int SNVT_ANGLE_DEG = 104;
  /** Ordinal value for SnvtTempP. */
  @Generated
  public static final int SNVT_TEMP_P = 105;
  /** Ordinal value for SnvtTempSetpt. */
  @Generated
  public static final int SNVT_TEMP_SETPT = 106;
  /** Ordinal value for SnvtTimeSec. */
  @Generated
  public static final int SNVT_TIME_SEC = 107;
  /** Ordinal value for SnvtHvacMode. */
  @Generated
  public static final int SNVT_HVAC_MODE = 108;
  /** Ordinal value for SnvtOccupancy. */
  @Generated
  public static final int SNVT_OCCUPANCY = 109;
  /** Ordinal value for SnvtArea. */
  @Generated
  public static final int SNVT_AREA = 110;
  /** Ordinal value for SnvtHvacOverid. */
  @Generated
  public static final int SNVT_HVAC_OVERID = 111;
  /** Ordinal value for SnvtHvacStatus. */
  @Generated
  public static final int SNVT_HVAC_STATUS = 112;
  /** Ordinal value for SnvtPressP. */
  @Generated
  public static final int SNVT_PRESS_P = 113;
  /** Ordinal value for SnvtAddress. */
  @Generated
  public static final int SNVT_ADDRESS = 114;
  /** Ordinal value for SnvtScene. */
  @Generated
  public static final int SNVT_SCENE = 115;
  /** Ordinal value for SnvtSceneCfg. */
  @Generated
  public static final int SNVT_SCENE_CFG = 116;
  /** Ordinal value for SnvtSetting. */
  @Generated
  public static final int SNVT_SETTING = 117;
  /** Ordinal value for SnvtEvapState. */
  @Generated
  public static final int SNVT_EVAP_STATE = 118;
  /** Ordinal value for SnvtThermMode. */
  @Generated
  public static final int SNVT_THERM_MODE = 119;
  /** Ordinal value for SnvtDefrMode. */
  @Generated
  public static final int SNVT_DEFR_MODE = 120;
  /** Ordinal value for SnvtDefrTerm. */
  @Generated
  public static final int SNVT_DEFR_TERM = 121;
  /** Ordinal value for SnvtDefrState. */
  @Generated
  public static final int SNVT_DEFR_STATE = 122;
  /** Ordinal value for SnvtTimeMin. */
  @Generated
  public static final int SNVT_TIME_MIN = 123;
  /** Ordinal value for SnvtTimeHour. */
  @Generated
  public static final int SNVT_TIME_HOUR = 124;
  /** Ordinal value for SnvtPh. */
  @Generated
  public static final int SNVT_PH = 125;
  /** Ordinal value for SnvtPhF. */
  @Generated
  public static final int SNVT_PH_F = 126;
  /** Ordinal value for SnvtChlrStatus. */
  @Generated
  public static final int SNVT_CHLR_STATUS = 127;
  /** Ordinal value for SnvtTodEvent. */
  @Generated
  public static final int SNVT_TOD_EVENT = 128;
  /** Ordinal value for SnvtSmoObscur. */
  @Generated
  public static final int SNVT_SMO_OBSCUR = 129;
  /** Ordinal value for SnvtFireTest. */
  @Generated
  public static final int SNVT_FIRE_TEST = 130;
  /** Ordinal value for SnvtTempRor. */
  @Generated
  public static final int SNVT_TEMP_ROR = 131;
  /** Ordinal value for SnvtFireInit. */
  @Generated
  public static final int SNVT_FIRE_INIT = 132;
  /** Ordinal value for SnvtFireIndcte. */
  @Generated
  public static final int SNVT_FIRE_INDCTE = 133;
  /** Ordinal value for SnvtTimeZone. */
  @Generated
  public static final int SNVT_TIME_ZONE = 134;
  /** Ordinal value for SnvtEarthPos. */
  @Generated
  public static final int SNVT_EARTH_POS = 135;
  /** Ordinal value for SnvtRegVal. */
  @Generated
  public static final int SNVT_REG_VAL = 136;
  /** Ordinal value for SnvtRegValTs. */
  @Generated
  public static final int SNVT_REG_VAL_TS = 137;
  /** Ordinal value for SnvtVoltAc. */
  @Generated
  public static final int SNVT_VOLT_AC = 138;
  /** Ordinal value for SnvtAmpAc. */
  @Generated
  public static final int SNVT_AMP_AC = 139;
  /** Ordinal value for SnvtTurbidity. */
  @Generated
  public static final int SNVT_TURBIDITY = 143;
  /** Ordinal value for SnvtTurbidityF. */
  @Generated
  public static final int SNVT_TURBIDITY_F = 144;
  /** Ordinal value for SnvtHvacType. */
  @Generated
  public static final int SNVT_HVAC_TYPE = 145;
  /** Ordinal value for SnvtElecKwhL. */
  @Generated
  public static final int SNVT_ELEC_KWH_L = 146;
  /** Ordinal value for SnvtTempDiffP. */
  @Generated
  public static final int SNVT_TEMP_DIFF_P = 147;
  /** Ordinal value for SnvtCtrlReq. */
  @Generated
  public static final int SNVT_CTRL_REQ = 148;
  /** Ordinal value for SnvtCtrlResp. */
  @Generated
  public static final int SNVT_CTRL_RESP = 149;
  /** Ordinal value for SnvtPtz. */
  @Generated
  public static final int SNVT_PTZ = 150;
  /** Ordinal value for SnvtPrivacyzone. */
  @Generated
  public static final int SNVT_PRIVACYZONE = 151;
  /** Ordinal value for SnvtPosCtrl. */
  @Generated
  public static final int SNVT_POS_CTRL = 152;
  /** Ordinal value for SnvtEnthalpy. */
  @Generated
  public static final int SNVT_ENTHALPY = 153;
  /** Ordinal value for SnvtGfciStatus. */
  @Generated
  public static final int SNVT_GFCI_STATUS = 154;
  /** Ordinal value for SnvtMotorState. */
  @Generated
  public static final int SNVT_MOTOR_STATE = 155;
  /** Ordinal value for SnvtPumpsetMn. */
  @Generated
  public static final int SNVT_PUMPSET_MN = 156;
  /** Ordinal value for SnvtExControl. */
  @Generated
  public static final int SNVT_EX_CONTROL = 157;
  /** Ordinal value for SnvtPumpsetSn. */
  @Generated
  public static final int SNVT_PUMPSET_SN = 158;
  /** Ordinal value for SnvtPumpSensor. */
  @Generated
  public static final int SNVT_PUMP_SENSOR = 159;
  /** Ordinal value for SnvtAbsHumid. */
  @Generated
  public static final int SNVT_ABS_HUMID = 160;
  /** Ordinal value for SnvtFlowP. */
  @Generated
  public static final int SNVT_FLOW_P = 161;
  /** Ordinal value for SnvtDevCMode. */
  @Generated
  public static final int SNVT_DEV_CMODE = 162;
  /** Ordinal value for SnvtValveMode. */
  @Generated
  public static final int SNVT_VALVE_MODE = 163;
  /** Ordinal value for SnvtAlarm2. */
  @Generated
  public static final int SNVT_ALARM_2 = 164;
  /** Ordinal value for SnvtState64. */
  @Generated
  public static final int SNVT_STATE_64 = 165;
  /** Ordinal value for SnvtNvType. */
  @Generated
  public static final int SNVT_NV_TYPE = 166;
  /** Ordinal value for SnvtEntOpmode. */
  @Generated
  public static final int SNVT_ENT_OPMODE = 168;
  /** Ordinal value for SnvtEntState. */
  @Generated
  public static final int SNVT_ENT_STATE = 169;
  /** Ordinal value for SnvtEntStatus. */
  @Generated
  public static final int SNVT_ENT_STATUS = 170;
  /** Ordinal value for SnvtFlowDir. */
  @Generated
  public static final int SNVT_FLOW_DIR = 171;
  /** Ordinal value for SnvtHvacSatsts. */
  @Generated
  public static final int SNVT_HVAC_SATSTS = 172;
  /** Ordinal value for SnvtDevStatus. */
  @Generated
  public static final int SNVT_DEV_STATUS = 173;
  /** Ordinal value for SnvtDevFault. */
  @Generated
  public static final int SNVT_DEV_FAULT = 174;
  /** Ordinal value for SnvtDevMaint. */
  @Generated
  public static final int SNVT_DEV_MAINT = 175;
  /** Ordinal value for SnvtDateEvent. */
  @Generated
  public static final int SNVT_DATE_EVENT = 176;
  /** Ordinal value for SnvtSchedVal. */
  @Generated
  public static final int SNVT_SCHED_VAL = 177;
  /** Ordinal value for SnvtSecState. */
  @Generated
  public static final int SNVT_SEC_STATE = 178;
  /** Ordinal value for SnvtSecStatus. */
  @Generated
  public static final int SNVT_SEC_STATUS = 179;
  /** Ordinal value for SnvtSblndState. */
  @Generated
  public static final int SNVT_SBLND_STATE = 180;
  /** Ordinal value for SnvtRacCtrl. */
  @Generated
  public static final int SNVT_RAC_CTRL = 181;
  /** Ordinal value for SnvtRacReq. */
  @Generated
  public static final int SNVT_RAC_REQ = 182;
  /** Ordinal value for SnvtCount32. */
  @Generated
  public static final int SNVT_COUNT_32 = 183;
  /** Ordinal value for SnvtClothesWC. */
  @Generated
  public static final int SNVT_CLOTHES_WC = 184;
  /** Ordinal value for SnvtClothesWM. */
  @Generated
  public static final int SNVT_CLOTHES_WM = 185;
  /** Ordinal value for SnvtClothesWS. */
  @Generated
  public static final int SNVT_CLOTHES_WS = 186;
  /** Ordinal value for SnvtClothesWA. */
  @Generated
  public static final int SNVT_CLOTHES_WA = 187;
  /** Ordinal value for SnvtMultiplierS. */
  @Generated
  public static final int SNVT_MULTIPLIER_S = 188;
  /** Ordinal value for SnvtSwitch2. */
  @Generated
  public static final int SNVT_SWITCH_2 = 189;
  /** Ordinal value for SnvtColor2. */
  @Generated
  public static final int SNVT_COLOR_2 = 190;
  /** Ordinal value for SnvtLogStatus. */
  @Generated
  public static final int SNVT_LOG_STATUS = 191;
  /** Ordinal value for SnvtTimeStampP. */
  @Generated
  public static final int SNVT_TIME_STAMP_P = 192;
  /** Ordinal value for SnvtLogFxRequest. */
  @Generated
  public static final int SNVT_LOG_FX_REQUEST = 193;
  /** Ordinal value for SnvtLogFxStatus. */
  @Generated
  public static final int SNVT_LOG_FX_STATUS = 194;
  /** Ordinal value for SnvtLogRequest. */
  @Generated
  public static final int SNVT_LOG_REQUEST = 195;
  /** Ordinal value for SnvtEnthalpyD. */
  @Generated
  public static final int SNVT_ENTHALPY_D = 196;
  /** Ordinal value for SnvtAmpAcMil. */
  @Generated
  public static final int SNVT_AMP_AC_MIL = 197;
  /** Ordinal value for SnvtTimeHourP. */
  @Generated
  public static final int SNVT_TIME_HOUR_P = 198;
  /** Ordinal value for SnvtLampStatus. */
  @Generated
  public static final int SNVT_LAMP_STATUS = 199;
  /** Ordinal value for SnvtEnvironment. */
  @Generated
  public static final int SNVT_ENVIRONMENT = 200;
  /** Ordinal value for SnvtGeoLoc. */
  @Generated
  public static final int SNVT_GEO_LOC = 201;
  /** Ordinal value for SnvtProgramStatus. */
  @Generated
  public static final int SNVT_PROGRAM_STATUS = 202;
  /** Ordinal value for SnvtLoadOffsets. */
  @Generated
  public static final int SNVT_LOAD_OFFSETS = 203;
  /** Ordinal value for SnvtWm2P. */
  @Generated
  public static final int SNVT_WM_2P = 204;
  /** Ordinal value for SnvtSafe1. */
  @Generated
  public static final int SNVT_SAFE_1 = 205;
  /** Ordinal value for SnvtSafe2. */
  @Generated
  public static final int SNVT_SAFE_2 = 206;
  /** Ordinal value for SnvtSafe4. */
  @Generated
  public static final int SNVT_SAFE_4 = 207;
  /** Ordinal value for SnvtSafe8. */
  @Generated
  public static final int SNVT_SAFE_8 = 208;
  /** Ordinal value for SnvtTimeVal2. */
  @Generated
  public static final int SNVT_TIME_VAL_2 = 209;
  /** Ordinal value for SnvtTimeOffset. */
  @Generated
  public static final int SNVT_TIME_OFFSET = 210;
  /** Ordinal value for SnvtSchedExc. */
  @Generated
  public static final int SNVT_SCHED_EXC = 211;
  /** Ordinal value for SnvtSchedStatus. */
  @Generated
  public static final int SNVT_SCHED_STATUS = 212;
  /** Ordinal value for SnvtMassFlow. */
  @Generated
  public static final int SNVT_MASS_FLOW = 213;
  /** Ordinal value for SnvtMassFlowF. */
  @Generated
  public static final int SNVT_MASS_FLOW_F = 214;

  /** BLonSnvtType constant for SnvtXxx. */
  @Generated
  public static final BLonSnvtType SnvtXxx = new BLonSnvtType(SNVT_XXX);
  /** BLonSnvtType constant for SnvtAmp. */
  @Generated
  public static final BLonSnvtType SnvtAmp = new BLonSnvtType(SNVT_AMP);
  /** BLonSnvtType constant for SnvtAmpMil. */
  @Generated
  public static final BLonSnvtType SnvtAmpMil = new BLonSnvtType(SNVT_AMP_MIL);
  /** BLonSnvtType constant for SnvtAngle. */
  @Generated
  public static final BLonSnvtType SnvtAngle = new BLonSnvtType(SNVT_ANGLE);
  /** BLonSnvtType constant for SnvtAngleVel. */
  @Generated
  public static final BLonSnvtType SnvtAngleVel = new BLonSnvtType(SNVT_ANGLE_VEL);
  /** BLonSnvtType constant for SnvtBtuKilo. */
  @Generated
  public static final BLonSnvtType SnvtBtuKilo = new BLonSnvtType(SNVT_BTU_KILO);
  /** BLonSnvtType constant for SnvtBtuMega. */
  @Generated
  public static final BLonSnvtType SnvtBtuMega = new BLonSnvtType(SNVT_BTU_MEGA);
  /** BLonSnvtType constant for SnvtCharAscii. */
  @Generated
  public static final BLonSnvtType SnvtCharAscii = new BLonSnvtType(SNVT_CHAR_ASCII);
  /** BLonSnvtType constant for SnvtCount. */
  @Generated
  public static final BLonSnvtType SnvtCount = new BLonSnvtType(SNVT_COUNT);
  /** BLonSnvtType constant for SnvtCountInc. */
  @Generated
  public static final BLonSnvtType SnvtCountInc = new BLonSnvtType(SNVT_COUNT_INC);
  /** BLonSnvtType constant for SnvtDateCal. */
  @Generated
  public static final BLonSnvtType SnvtDateCal = new BLonSnvtType(SNVT_DATE_CAL);
  /** BLonSnvtType constant for SnvtDateDay. */
  @Generated
  public static final BLonSnvtType SnvtDateDay = new BLonSnvtType(SNVT_DATE_DAY);
  /** BLonSnvtType constant for SnvtDateTime. */
  @Generated
  public static final BLonSnvtType SnvtDateTime = new BLonSnvtType(SNVT_DATE_TIME);
  /** BLonSnvtType constant for SnvtElecKwh. */
  @Generated
  public static final BLonSnvtType SnvtElecKwh = new BLonSnvtType(SNVT_ELEC_KWH);
  /** BLonSnvtType constant for SnvtElecWhr. */
  @Generated
  public static final BLonSnvtType SnvtElecWhr = new BLonSnvtType(SNVT_ELEC_WHR);
  /** BLonSnvtType constant for SnvtFlow. */
  @Generated
  public static final BLonSnvtType SnvtFlow = new BLonSnvtType(SNVT_FLOW);
  /** BLonSnvtType constant for SnvtFlowMil. */
  @Generated
  public static final BLonSnvtType SnvtFlowMil = new BLonSnvtType(SNVT_FLOW_MIL);
  /** BLonSnvtType constant for SnvtLength. */
  @Generated
  public static final BLonSnvtType SnvtLength = new BLonSnvtType(SNVT_LENGTH);
  /** BLonSnvtType constant for SnvtLengthKilo. */
  @Generated
  public static final BLonSnvtType SnvtLengthKilo = new BLonSnvtType(SNVT_LENGTH_KILO);
  /** BLonSnvtType constant for SnvtLengthMicr. */
  @Generated
  public static final BLonSnvtType SnvtLengthMicr = new BLonSnvtType(SNVT_LENGTH_MICR);
  /** BLonSnvtType constant for SnvtLengthMil. */
  @Generated
  public static final BLonSnvtType SnvtLengthMil = new BLonSnvtType(SNVT_LENGTH_MIL);
  /** BLonSnvtType constant for SnvtLevCont. */
  @Generated
  public static final BLonSnvtType SnvtLevCont = new BLonSnvtType(SNVT_LEV_CONT);
  /** BLonSnvtType constant for SnvtLevDisc. */
  @Generated
  public static final BLonSnvtType SnvtLevDisc = new BLonSnvtType(SNVT_LEV_DISC);
  /** BLonSnvtType constant for SnvtMass. */
  @Generated
  public static final BLonSnvtType SnvtMass = new BLonSnvtType(SNVT_MASS);
  /** BLonSnvtType constant for SnvtMassKilo. */
  @Generated
  public static final BLonSnvtType SnvtMassKilo = new BLonSnvtType(SNVT_MASS_KILO);
  /** BLonSnvtType constant for SnvtMassMega. */
  @Generated
  public static final BLonSnvtType SnvtMassMega = new BLonSnvtType(SNVT_MASS_MEGA);
  /** BLonSnvtType constant for SnvtMassMil. */
  @Generated
  public static final BLonSnvtType SnvtMassMil = new BLonSnvtType(SNVT_MASS_MIL);
  /** BLonSnvtType constant for SnvtPower. */
  @Generated
  public static final BLonSnvtType SnvtPower = new BLonSnvtType(SNVT_POWER);
  /** BLonSnvtType constant for SnvtPowerKilo. */
  @Generated
  public static final BLonSnvtType SnvtPowerKilo = new BLonSnvtType(SNVT_POWER_KILO);
  /** BLonSnvtType constant for SnvtPpm. */
  @Generated
  public static final BLonSnvtType SnvtPpm = new BLonSnvtType(SNVT_PPM);
  /** BLonSnvtType constant for SnvtPress. */
  @Generated
  public static final BLonSnvtType SnvtPress = new BLonSnvtType(SNVT_PRESS);
  /** BLonSnvtType constant for SnvtRes. */
  @Generated
  public static final BLonSnvtType SnvtRes = new BLonSnvtType(SNVT_RES);
  /** BLonSnvtType constant for SnvtResKilo. */
  @Generated
  public static final BLonSnvtType SnvtResKilo = new BLonSnvtType(SNVT_RES_KILO);
  /** BLonSnvtType constant for SnvtSoundDb. */
  @Generated
  public static final BLonSnvtType SnvtSoundDb = new BLonSnvtType(SNVT_SOUND_DB);
  /** BLonSnvtType constant for SnvtSpeed. */
  @Generated
  public static final BLonSnvtType SnvtSpeed = new BLonSnvtType(SNVT_SPEED);
  /** BLonSnvtType constant for SnvtSpeedMil. */
  @Generated
  public static final BLonSnvtType SnvtSpeedMil = new BLonSnvtType(SNVT_SPEED_MIL);
  /** BLonSnvtType constant for SnvtStrAsc. */
  @Generated
  public static final BLonSnvtType SnvtStrAsc = new BLonSnvtType(SNVT_STR_ASC);
  /** BLonSnvtType constant for SnvtStrInt. */
  @Generated
  public static final BLonSnvtType SnvtStrInt = new BLonSnvtType(SNVT_STR_INT);
  /** BLonSnvtType constant for SnvtTelcom. */
  @Generated
  public static final BLonSnvtType SnvtTelcom = new BLonSnvtType(SNVT_TELCOM);
  /** BLonSnvtType constant for SnvtTemp. */
  @Generated
  public static final BLonSnvtType SnvtTemp = new BLonSnvtType(SNVT_TEMP);
  /** BLonSnvtType constant for SnvtTimePassed. */
  @Generated
  public static final BLonSnvtType SnvtTimePassed = new BLonSnvtType(SNVT_TIME_PASSED);
  /** BLonSnvtType constant for SnvtVol. */
  @Generated
  public static final BLonSnvtType SnvtVol = new BLonSnvtType(SNVT_VOL);
  /** BLonSnvtType constant for SnvtVolKilo. */
  @Generated
  public static final BLonSnvtType SnvtVolKilo = new BLonSnvtType(SNVT_VOL_KILO);
  /** BLonSnvtType constant for SnvtVolMil. */
  @Generated
  public static final BLonSnvtType SnvtVolMil = new BLonSnvtType(SNVT_VOL_MIL);
  /** BLonSnvtType constant for SnvtVolt. */
  @Generated
  public static final BLonSnvtType SnvtVolt = new BLonSnvtType(SNVT_VOLT);
  /** BLonSnvtType constant for SnvtVoltDbmv. */
  @Generated
  public static final BLonSnvtType SnvtVoltDbmv = new BLonSnvtType(SNVT_VOLT_DBMV);
  /** BLonSnvtType constant for SnvtVoltKilo. */
  @Generated
  public static final BLonSnvtType SnvtVoltKilo = new BLonSnvtType(SNVT_VOLT_KILO);
  /** BLonSnvtType constant for SnvtVoltMil. */
  @Generated
  public static final BLonSnvtType SnvtVoltMil = new BLonSnvtType(SNVT_VOLT_MIL);
  /** BLonSnvtType constant for SnvtAmpF. */
  @Generated
  public static final BLonSnvtType SnvtAmpF = new BLonSnvtType(SNVT_AMP_F);
  /** BLonSnvtType constant for SnvtAngleF. */
  @Generated
  public static final BLonSnvtType SnvtAngleF = new BLonSnvtType(SNVT_ANGLE_F);
  /** BLonSnvtType constant for SnvtAngleVelF. */
  @Generated
  public static final BLonSnvtType SnvtAngleVelF = new BLonSnvtType(SNVT_ANGLE_VEL_F);
  /** BLonSnvtType constant for SnvtCountF. */
  @Generated
  public static final BLonSnvtType SnvtCountF = new BLonSnvtType(SNVT_COUNT_F);
  /** BLonSnvtType constant for SnvtCountIncF. */
  @Generated
  public static final BLonSnvtType SnvtCountIncF = new BLonSnvtType(SNVT_COUNT_INC_F);
  /** BLonSnvtType constant for SnvtFlowF. */
  @Generated
  public static final BLonSnvtType SnvtFlowF = new BLonSnvtType(SNVT_FLOW_F);
  /** BLonSnvtType constant for SnvtLengthF. */
  @Generated
  public static final BLonSnvtType SnvtLengthF = new BLonSnvtType(SNVT_LENGTH_F);
  /** BLonSnvtType constant for SnvtLevContF. */
  @Generated
  public static final BLonSnvtType SnvtLevContF = new BLonSnvtType(SNVT_LEV_CONT_F);
  /** BLonSnvtType constant for SnvtMassF. */
  @Generated
  public static final BLonSnvtType SnvtMassF = new BLonSnvtType(SNVT_MASS_F);
  /** BLonSnvtType constant for SnvtPowerF. */
  @Generated
  public static final BLonSnvtType SnvtPowerF = new BLonSnvtType(SNVT_POWER_F);
  /** BLonSnvtType constant for SnvtPpmF. */
  @Generated
  public static final BLonSnvtType SnvtPpmF = new BLonSnvtType(SNVT_PPM_F);
  /** BLonSnvtType constant for SnvtPressF. */
  @Generated
  public static final BLonSnvtType SnvtPressF = new BLonSnvtType(SNVT_PRESS_F);
  /** BLonSnvtType constant for SnvtResF. */
  @Generated
  public static final BLonSnvtType SnvtResF = new BLonSnvtType(SNVT_RES_F);
  /** BLonSnvtType constant for SnvtSoundDbF. */
  @Generated
  public static final BLonSnvtType SnvtSoundDbF = new BLonSnvtType(SNVT_SOUND_DB_F);
  /** BLonSnvtType constant for SnvtSpeedF. */
  @Generated
  public static final BLonSnvtType SnvtSpeedF = new BLonSnvtType(SNVT_SPEED_F);
  /** BLonSnvtType constant for SnvtTempF. */
  @Generated
  public static final BLonSnvtType SnvtTempF = new BLonSnvtType(SNVT_TEMP_F);
  /** BLonSnvtType constant for SnvtTimeF. */
  @Generated
  public static final BLonSnvtType SnvtTimeF = new BLonSnvtType(SNVT_TIME_F);
  /** BLonSnvtType constant for SnvtVolF. */
  @Generated
  public static final BLonSnvtType SnvtVolF = new BLonSnvtType(SNVT_VOL_F);
  /** BLonSnvtType constant for SnvtVoltF. */
  @Generated
  public static final BLonSnvtType SnvtVoltF = new BLonSnvtType(SNVT_VOLT_F);
  /** BLonSnvtType constant for SnvtBtuF. */
  @Generated
  public static final BLonSnvtType SnvtBtuF = new BLonSnvtType(SNVT_BTU_F);
  /** BLonSnvtType constant for SnvtElecWhrF. */
  @Generated
  public static final BLonSnvtType SnvtElecWhrF = new BLonSnvtType(SNVT_ELEC_WHR_F);
  /** BLonSnvtType constant for SnvtConfigSrc. */
  @Generated
  public static final BLonSnvtType SnvtConfigSrc = new BLonSnvtType(SNVT_CONFIG_SRC);
  /** BLonSnvtType constant for SnvtColor. */
  @Generated
  public static final BLonSnvtType SnvtColor = new BLonSnvtType(SNVT_COLOR);
  /** BLonSnvtType constant for SnvtGrammage. */
  @Generated
  public static final BLonSnvtType SnvtGrammage = new BLonSnvtType(SNVT_GRAMMAGE);
  /** BLonSnvtType constant for SnvtGrammageF. */
  @Generated
  public static final BLonSnvtType SnvtGrammageF = new BLonSnvtType(SNVT_GRAMMAGE_F);
  /** BLonSnvtType constant for SnvtFileReq. */
  @Generated
  public static final BLonSnvtType SnvtFileReq = new BLonSnvtType(SNVT_FILE_REQ);
  /** BLonSnvtType constant for SnvtFileStatus. */
  @Generated
  public static final BLonSnvtType SnvtFileStatus = new BLonSnvtType(SNVT_FILE_STATUS);
  /** BLonSnvtType constant for SnvtFreqF. */
  @Generated
  public static final BLonSnvtType SnvtFreqF = new BLonSnvtType(SNVT_FREQ_F);
  /** BLonSnvtType constant for SnvtFreqHz. */
  @Generated
  public static final BLonSnvtType SnvtFreqHz = new BLonSnvtType(SNVT_FREQ_HZ);
  /** BLonSnvtType constant for SnvtFreqKilohz. */
  @Generated
  public static final BLonSnvtType SnvtFreqKilohz = new BLonSnvtType(SNVT_FREQ_KILOHZ);
  /** BLonSnvtType constant for SnvtFreqMilhz. */
  @Generated
  public static final BLonSnvtType SnvtFreqMilhz = new BLonSnvtType(SNVT_FREQ_MILHZ);
  /** BLonSnvtType constant for SnvtLux. */
  @Generated
  public static final BLonSnvtType SnvtLux = new BLonSnvtType(SNVT_LUX);
  /** BLonSnvtType constant for SnvtIso7811. */
  @Generated
  public static final BLonSnvtType SnvtIso7811 = new BLonSnvtType(SNVT_ISO_7811);
  /** BLonSnvtType constant for SnvtLevPercent. */
  @Generated
  public static final BLonSnvtType SnvtLevPercent = new BLonSnvtType(SNVT_LEV_PERCENT);
  /** BLonSnvtType constant for SnvtMultiplier. */
  @Generated
  public static final BLonSnvtType SnvtMultiplier = new BLonSnvtType(SNVT_MULTIPLIER);
  /** BLonSnvtType constant for SnvtState. */
  @Generated
  public static final BLonSnvtType SnvtState = new BLonSnvtType(SNVT_STATE);
  /** BLonSnvtType constant for SnvtTimeStamp. */
  @Generated
  public static final BLonSnvtType SnvtTimeStamp = new BLonSnvtType(SNVT_TIME_STAMP);
  /** BLonSnvtType constant for SnvtZerospan. */
  @Generated
  public static final BLonSnvtType SnvtZerospan = new BLonSnvtType(SNVT_ZEROSPAN);
  /** BLonSnvtType constant for SnvtMagcard. */
  @Generated
  public static final BLonSnvtType SnvtMagcard = new BLonSnvtType(SNVT_MAGCARD);
  /** BLonSnvtType constant for SnvtElapsedTm. */
  @Generated
  public static final BLonSnvtType SnvtElapsedTm = new BLonSnvtType(SNVT_ELAPSED_TM);
  /** BLonSnvtType constant for SnvtAlarm. */
  @Generated
  public static final BLonSnvtType SnvtAlarm = new BLonSnvtType(SNVT_ALARM);
  /** BLonSnvtType constant for SnvtCurrency. */
  @Generated
  public static final BLonSnvtType SnvtCurrency = new BLonSnvtType(SNVT_CURRENCY);
  /** BLonSnvtType constant for SnvtFilePos. */
  @Generated
  public static final BLonSnvtType SnvtFilePos = new BLonSnvtType(SNVT_FILE_POS);
  /** BLonSnvtType constant for SnvtMuldiv. */
  @Generated
  public static final BLonSnvtType SnvtMuldiv = new BLonSnvtType(SNVT_MULDIV);
  /** BLonSnvtType constant for SnvtObjRequest. */
  @Generated
  public static final BLonSnvtType SnvtObjRequest = new BLonSnvtType(SNVT_OBJ_REQUEST);
  /** BLonSnvtType constant for SnvtObjStatus. */
  @Generated
  public static final BLonSnvtType SnvtObjStatus = new BLonSnvtType(SNVT_OBJ_STATUS);
  /** BLonSnvtType constant for SnvtPreset. */
  @Generated
  public static final BLonSnvtType SnvtPreset = new BLonSnvtType(SNVT_PRESET);
  /** BLonSnvtType constant for SnvtSwitch. */
  @Generated
  public static final BLonSnvtType SnvtSwitch = new BLonSnvtType(SNVT_SWITCH);
  /** BLonSnvtType constant for SnvtTransTable. */
  @Generated
  public static final BLonSnvtType SnvtTransTable = new BLonSnvtType(SNVT_TRANS_TABLE);
  /** BLonSnvtType constant for SnvtOverride. */
  @Generated
  public static final BLonSnvtType SnvtOverride = new BLonSnvtType(SNVT_OVERRIDE);
  /** BLonSnvtType constant for SnvtPwrFact. */
  @Generated
  public static final BLonSnvtType SnvtPwrFact = new BLonSnvtType(SNVT_PWR_FACT);
  /** BLonSnvtType constant for SnvtPwrFactF. */
  @Generated
  public static final BLonSnvtType SnvtPwrFactF = new BLonSnvtType(SNVT_PWR_FACT_F);
  /** BLonSnvtType constant for SnvtDensity. */
  @Generated
  public static final BLonSnvtType SnvtDensity = new BLonSnvtType(SNVT_DENSITY);
  /** BLonSnvtType constant for SnvtDensityF. */
  @Generated
  public static final BLonSnvtType SnvtDensityF = new BLonSnvtType(SNVT_DENSITY_F);
  /** BLonSnvtType constant for SnvtRpm. */
  @Generated
  public static final BLonSnvtType SnvtRpm = new BLonSnvtType(SNVT_RPM);
  /** BLonSnvtType constant for SnvtHvacEmerg. */
  @Generated
  public static final BLonSnvtType SnvtHvacEmerg = new BLonSnvtType(SNVT_HVAC_EMERG);
  /** BLonSnvtType constant for SnvtAngleDeg. */
  @Generated
  public static final BLonSnvtType SnvtAngleDeg = new BLonSnvtType(SNVT_ANGLE_DEG);
  /** BLonSnvtType constant for SnvtTempP. */
  @Generated
  public static final BLonSnvtType SnvtTempP = new BLonSnvtType(SNVT_TEMP_P);
  /** BLonSnvtType constant for SnvtTempSetpt. */
  @Generated
  public static final BLonSnvtType SnvtTempSetpt = new BLonSnvtType(SNVT_TEMP_SETPT);
  /** BLonSnvtType constant for SnvtTimeSec. */
  @Generated
  public static final BLonSnvtType SnvtTimeSec = new BLonSnvtType(SNVT_TIME_SEC);
  /** BLonSnvtType constant for SnvtHvacMode. */
  @Generated
  public static final BLonSnvtType SnvtHvacMode = new BLonSnvtType(SNVT_HVAC_MODE);
  /** BLonSnvtType constant for SnvtOccupancy. */
  @Generated
  public static final BLonSnvtType SnvtOccupancy = new BLonSnvtType(SNVT_OCCUPANCY);
  /** BLonSnvtType constant for SnvtArea. */
  @Generated
  public static final BLonSnvtType SnvtArea = new BLonSnvtType(SNVT_AREA);
  /** BLonSnvtType constant for SnvtHvacOverid. */
  @Generated
  public static final BLonSnvtType SnvtHvacOverid = new BLonSnvtType(SNVT_HVAC_OVERID);
  /** BLonSnvtType constant for SnvtHvacStatus. */
  @Generated
  public static final BLonSnvtType SnvtHvacStatus = new BLonSnvtType(SNVT_HVAC_STATUS);
  /** BLonSnvtType constant for SnvtPressP. */
  @Generated
  public static final BLonSnvtType SnvtPressP = new BLonSnvtType(SNVT_PRESS_P);
  /** BLonSnvtType constant for SnvtAddress. */
  @Generated
  public static final BLonSnvtType SnvtAddress = new BLonSnvtType(SNVT_ADDRESS);
  /** BLonSnvtType constant for SnvtScene. */
  @Generated
  public static final BLonSnvtType SnvtScene = new BLonSnvtType(SNVT_SCENE);
  /** BLonSnvtType constant for SnvtSceneCfg. */
  @Generated
  public static final BLonSnvtType SnvtSceneCfg = new BLonSnvtType(SNVT_SCENE_CFG);
  /** BLonSnvtType constant for SnvtSetting. */
  @Generated
  public static final BLonSnvtType SnvtSetting = new BLonSnvtType(SNVT_SETTING);
  /** BLonSnvtType constant for SnvtEvapState. */
  @Generated
  public static final BLonSnvtType SnvtEvapState = new BLonSnvtType(SNVT_EVAP_STATE);
  /** BLonSnvtType constant for SnvtThermMode. */
  @Generated
  public static final BLonSnvtType SnvtThermMode = new BLonSnvtType(SNVT_THERM_MODE);
  /** BLonSnvtType constant for SnvtDefrMode. */
  @Generated
  public static final BLonSnvtType SnvtDefrMode = new BLonSnvtType(SNVT_DEFR_MODE);
  /** BLonSnvtType constant for SnvtDefrTerm. */
  @Generated
  public static final BLonSnvtType SnvtDefrTerm = new BLonSnvtType(SNVT_DEFR_TERM);
  /** BLonSnvtType constant for SnvtDefrState. */
  @Generated
  public static final BLonSnvtType SnvtDefrState = new BLonSnvtType(SNVT_DEFR_STATE);
  /** BLonSnvtType constant for SnvtTimeMin. */
  @Generated
  public static final BLonSnvtType SnvtTimeMin = new BLonSnvtType(SNVT_TIME_MIN);
  /** BLonSnvtType constant for SnvtTimeHour. */
  @Generated
  public static final BLonSnvtType SnvtTimeHour = new BLonSnvtType(SNVT_TIME_HOUR);
  /** BLonSnvtType constant for SnvtPh. */
  @Generated
  public static final BLonSnvtType SnvtPh = new BLonSnvtType(SNVT_PH);
  /** BLonSnvtType constant for SnvtPhF. */
  @Generated
  public static final BLonSnvtType SnvtPhF = new BLonSnvtType(SNVT_PH_F);
  /** BLonSnvtType constant for SnvtChlrStatus. */
  @Generated
  public static final BLonSnvtType SnvtChlrStatus = new BLonSnvtType(SNVT_CHLR_STATUS);
  /** BLonSnvtType constant for SnvtTodEvent. */
  @Generated
  public static final BLonSnvtType SnvtTodEvent = new BLonSnvtType(SNVT_TOD_EVENT);
  /** BLonSnvtType constant for SnvtSmoObscur. */
  @Generated
  public static final BLonSnvtType SnvtSmoObscur = new BLonSnvtType(SNVT_SMO_OBSCUR);
  /** BLonSnvtType constant for SnvtFireTest. */
  @Generated
  public static final BLonSnvtType SnvtFireTest = new BLonSnvtType(SNVT_FIRE_TEST);
  /** BLonSnvtType constant for SnvtTempRor. */
  @Generated
  public static final BLonSnvtType SnvtTempRor = new BLonSnvtType(SNVT_TEMP_ROR);
  /** BLonSnvtType constant for SnvtFireInit. */
  @Generated
  public static final BLonSnvtType SnvtFireInit = new BLonSnvtType(SNVT_FIRE_INIT);
  /** BLonSnvtType constant for SnvtFireIndcte. */
  @Generated
  public static final BLonSnvtType SnvtFireIndcte = new BLonSnvtType(SNVT_FIRE_INDCTE);
  /** BLonSnvtType constant for SnvtTimeZone. */
  @Generated
  public static final BLonSnvtType SnvtTimeZone = new BLonSnvtType(SNVT_TIME_ZONE);
  /** BLonSnvtType constant for SnvtEarthPos. */
  @Generated
  public static final BLonSnvtType SnvtEarthPos = new BLonSnvtType(SNVT_EARTH_POS);
  /** BLonSnvtType constant for SnvtRegVal. */
  @Generated
  public static final BLonSnvtType SnvtRegVal = new BLonSnvtType(SNVT_REG_VAL);
  /** BLonSnvtType constant for SnvtRegValTs. */
  @Generated
  public static final BLonSnvtType SnvtRegValTs = new BLonSnvtType(SNVT_REG_VAL_TS);
  /** BLonSnvtType constant for SnvtVoltAc. */
  @Generated
  public static final BLonSnvtType SnvtVoltAc = new BLonSnvtType(SNVT_VOLT_AC);
  /** BLonSnvtType constant for SnvtAmpAc. */
  @Generated
  public static final BLonSnvtType SnvtAmpAc = new BLonSnvtType(SNVT_AMP_AC);
  /** BLonSnvtType constant for SnvtTurbidity. */
  @Generated
  public static final BLonSnvtType SnvtTurbidity = new BLonSnvtType(SNVT_TURBIDITY);
  /** BLonSnvtType constant for SnvtTurbidityF. */
  @Generated
  public static final BLonSnvtType SnvtTurbidityF = new BLonSnvtType(SNVT_TURBIDITY_F);
  /** BLonSnvtType constant for SnvtHvacType. */
  @Generated
  public static final BLonSnvtType SnvtHvacType = new BLonSnvtType(SNVT_HVAC_TYPE);
  /** BLonSnvtType constant for SnvtElecKwhL. */
  @Generated
  public static final BLonSnvtType SnvtElecKwhL = new BLonSnvtType(SNVT_ELEC_KWH_L);
  /** BLonSnvtType constant for SnvtTempDiffP. */
  @Generated
  public static final BLonSnvtType SnvtTempDiffP = new BLonSnvtType(SNVT_TEMP_DIFF_P);
  /** BLonSnvtType constant for SnvtCtrlReq. */
  @Generated
  public static final BLonSnvtType SnvtCtrlReq = new BLonSnvtType(SNVT_CTRL_REQ);
  /** BLonSnvtType constant for SnvtCtrlResp. */
  @Generated
  public static final BLonSnvtType SnvtCtrlResp = new BLonSnvtType(SNVT_CTRL_RESP);
  /** BLonSnvtType constant for SnvtPtz. */
  @Generated
  public static final BLonSnvtType SnvtPtz = new BLonSnvtType(SNVT_PTZ);
  /** BLonSnvtType constant for SnvtPrivacyzone. */
  @Generated
  public static final BLonSnvtType SnvtPrivacyzone = new BLonSnvtType(SNVT_PRIVACYZONE);
  /** BLonSnvtType constant for SnvtPosCtrl. */
  @Generated
  public static final BLonSnvtType SnvtPosCtrl = new BLonSnvtType(SNVT_POS_CTRL);
  /** BLonSnvtType constant for SnvtEnthalpy. */
  @Generated
  public static final BLonSnvtType SnvtEnthalpy = new BLonSnvtType(SNVT_ENTHALPY);
  /** BLonSnvtType constant for SnvtGfciStatus. */
  @Generated
  public static final BLonSnvtType SnvtGfciStatus = new BLonSnvtType(SNVT_GFCI_STATUS);
  /** BLonSnvtType constant for SnvtMotorState. */
  @Generated
  public static final BLonSnvtType SnvtMotorState = new BLonSnvtType(SNVT_MOTOR_STATE);
  /** BLonSnvtType constant for SnvtPumpsetMn. */
  @Generated
  public static final BLonSnvtType SnvtPumpsetMn = new BLonSnvtType(SNVT_PUMPSET_MN);
  /** BLonSnvtType constant for SnvtExControl. */
  @Generated
  public static final BLonSnvtType SnvtExControl = new BLonSnvtType(SNVT_EX_CONTROL);
  /** BLonSnvtType constant for SnvtPumpsetSn. */
  @Generated
  public static final BLonSnvtType SnvtPumpsetSn = new BLonSnvtType(SNVT_PUMPSET_SN);
  /** BLonSnvtType constant for SnvtPumpSensor. */
  @Generated
  public static final BLonSnvtType SnvtPumpSensor = new BLonSnvtType(SNVT_PUMP_SENSOR);
  /** BLonSnvtType constant for SnvtAbsHumid. */
  @Generated
  public static final BLonSnvtType SnvtAbsHumid = new BLonSnvtType(SNVT_ABS_HUMID);
  /** BLonSnvtType constant for SnvtFlowP. */
  @Generated
  public static final BLonSnvtType SnvtFlowP = new BLonSnvtType(SNVT_FLOW_P);
  /** BLonSnvtType constant for SnvtDevCMode. */
  @Generated
  public static final BLonSnvtType SnvtDevCMode = new BLonSnvtType(SNVT_DEV_CMODE);
  /** BLonSnvtType constant for SnvtValveMode. */
  @Generated
  public static final BLonSnvtType SnvtValveMode = new BLonSnvtType(SNVT_VALVE_MODE);
  /** BLonSnvtType constant for SnvtAlarm2. */
  @Generated
  public static final BLonSnvtType SnvtAlarm2 = new BLonSnvtType(SNVT_ALARM_2);
  /** BLonSnvtType constant for SnvtState64. */
  @Generated
  public static final BLonSnvtType SnvtState64 = new BLonSnvtType(SNVT_STATE_64);
  /** BLonSnvtType constant for SnvtNvType. */
  @Generated
  public static final BLonSnvtType SnvtNvType = new BLonSnvtType(SNVT_NV_TYPE);
  /** BLonSnvtType constant for SnvtEntOpmode. */
  @Generated
  public static final BLonSnvtType SnvtEntOpmode = new BLonSnvtType(SNVT_ENT_OPMODE);
  /** BLonSnvtType constant for SnvtEntState. */
  @Generated
  public static final BLonSnvtType SnvtEntState = new BLonSnvtType(SNVT_ENT_STATE);
  /** BLonSnvtType constant for SnvtEntStatus. */
  @Generated
  public static final BLonSnvtType SnvtEntStatus = new BLonSnvtType(SNVT_ENT_STATUS);
  /** BLonSnvtType constant for SnvtFlowDir. */
  @Generated
  public static final BLonSnvtType SnvtFlowDir = new BLonSnvtType(SNVT_FLOW_DIR);
  /** BLonSnvtType constant for SnvtHvacSatsts. */
  @Generated
  public static final BLonSnvtType SnvtHvacSatsts = new BLonSnvtType(SNVT_HVAC_SATSTS);
  /** BLonSnvtType constant for SnvtDevStatus. */
  @Generated
  public static final BLonSnvtType SnvtDevStatus = new BLonSnvtType(SNVT_DEV_STATUS);
  /** BLonSnvtType constant for SnvtDevFault. */
  @Generated
  public static final BLonSnvtType SnvtDevFault = new BLonSnvtType(SNVT_DEV_FAULT);
  /** BLonSnvtType constant for SnvtDevMaint. */
  @Generated
  public static final BLonSnvtType SnvtDevMaint = new BLonSnvtType(SNVT_DEV_MAINT);
  /** BLonSnvtType constant for SnvtDateEvent. */
  @Generated
  public static final BLonSnvtType SnvtDateEvent = new BLonSnvtType(SNVT_DATE_EVENT);
  /** BLonSnvtType constant for SnvtSchedVal. */
  @Generated
  public static final BLonSnvtType SnvtSchedVal = new BLonSnvtType(SNVT_SCHED_VAL);
  /** BLonSnvtType constant for SnvtSecState. */
  @Generated
  public static final BLonSnvtType SnvtSecState = new BLonSnvtType(SNVT_SEC_STATE);
  /** BLonSnvtType constant for SnvtSecStatus. */
  @Generated
  public static final BLonSnvtType SnvtSecStatus = new BLonSnvtType(SNVT_SEC_STATUS);
  /** BLonSnvtType constant for SnvtSblndState. */
  @Generated
  public static final BLonSnvtType SnvtSblndState = new BLonSnvtType(SNVT_SBLND_STATE);
  /** BLonSnvtType constant for SnvtRacCtrl. */
  @Generated
  public static final BLonSnvtType SnvtRacCtrl = new BLonSnvtType(SNVT_RAC_CTRL);
  /** BLonSnvtType constant for SnvtRacReq. */
  @Generated
  public static final BLonSnvtType SnvtRacReq = new BLonSnvtType(SNVT_RAC_REQ);
  /** BLonSnvtType constant for SnvtCount32. */
  @Generated
  public static final BLonSnvtType SnvtCount32 = new BLonSnvtType(SNVT_COUNT_32);
  /** BLonSnvtType constant for SnvtClothesWC. */
  @Generated
  public static final BLonSnvtType SnvtClothesWC = new BLonSnvtType(SNVT_CLOTHES_WC);
  /** BLonSnvtType constant for SnvtClothesWM. */
  @Generated
  public static final BLonSnvtType SnvtClothesWM = new BLonSnvtType(SNVT_CLOTHES_WM);
  /** BLonSnvtType constant for SnvtClothesWS. */
  @Generated
  public static final BLonSnvtType SnvtClothesWS = new BLonSnvtType(SNVT_CLOTHES_WS);
  /** BLonSnvtType constant for SnvtClothesWA. */
  @Generated
  public static final BLonSnvtType SnvtClothesWA = new BLonSnvtType(SNVT_CLOTHES_WA);
  /** BLonSnvtType constant for SnvtMultiplierS. */
  @Generated
  public static final BLonSnvtType SnvtMultiplierS = new BLonSnvtType(SNVT_MULTIPLIER_S);
  /** BLonSnvtType constant for SnvtSwitch2. */
  @Generated
  public static final BLonSnvtType SnvtSwitch2 = new BLonSnvtType(SNVT_SWITCH_2);
  /** BLonSnvtType constant for SnvtColor2. */
  @Generated
  public static final BLonSnvtType SnvtColor2 = new BLonSnvtType(SNVT_COLOR_2);
  /** BLonSnvtType constant for SnvtLogStatus. */
  @Generated
  public static final BLonSnvtType SnvtLogStatus = new BLonSnvtType(SNVT_LOG_STATUS);
  /** BLonSnvtType constant for SnvtTimeStampP. */
  @Generated
  public static final BLonSnvtType SnvtTimeStampP = new BLonSnvtType(SNVT_TIME_STAMP_P);
  /** BLonSnvtType constant for SnvtLogFxRequest. */
  @Generated
  public static final BLonSnvtType SnvtLogFxRequest = new BLonSnvtType(SNVT_LOG_FX_REQUEST);
  /** BLonSnvtType constant for SnvtLogFxStatus. */
  @Generated
  public static final BLonSnvtType SnvtLogFxStatus = new BLonSnvtType(SNVT_LOG_FX_STATUS);
  /** BLonSnvtType constant for SnvtLogRequest. */
  @Generated
  public static final BLonSnvtType SnvtLogRequest = new BLonSnvtType(SNVT_LOG_REQUEST);
  /** BLonSnvtType constant for SnvtEnthalpyD. */
  @Generated
  public static final BLonSnvtType SnvtEnthalpyD = new BLonSnvtType(SNVT_ENTHALPY_D);
  /** BLonSnvtType constant for SnvtAmpAcMil. */
  @Generated
  public static final BLonSnvtType SnvtAmpAcMil = new BLonSnvtType(SNVT_AMP_AC_MIL);
  /** BLonSnvtType constant for SnvtTimeHourP. */
  @Generated
  public static final BLonSnvtType SnvtTimeHourP = new BLonSnvtType(SNVT_TIME_HOUR_P);
  /** BLonSnvtType constant for SnvtLampStatus. */
  @Generated
  public static final BLonSnvtType SnvtLampStatus = new BLonSnvtType(SNVT_LAMP_STATUS);
  /** BLonSnvtType constant for SnvtEnvironment. */
  @Generated
  public static final BLonSnvtType SnvtEnvironment = new BLonSnvtType(SNVT_ENVIRONMENT);
  /** BLonSnvtType constant for SnvtGeoLoc. */
  @Generated
  public static final BLonSnvtType SnvtGeoLoc = new BLonSnvtType(SNVT_GEO_LOC);
  /** BLonSnvtType constant for SnvtProgramStatus. */
  @Generated
  public static final BLonSnvtType SnvtProgramStatus = new BLonSnvtType(SNVT_PROGRAM_STATUS);
  /** BLonSnvtType constant for SnvtLoadOffsets. */
  @Generated
  public static final BLonSnvtType SnvtLoadOffsets = new BLonSnvtType(SNVT_LOAD_OFFSETS);
  /** BLonSnvtType constant for SnvtWm2P. */
  @Generated
  public static final BLonSnvtType SnvtWm2P = new BLonSnvtType(SNVT_WM_2P);
  /** BLonSnvtType constant for SnvtSafe1. */
  @Generated
  public static final BLonSnvtType SnvtSafe1 = new BLonSnvtType(SNVT_SAFE_1);
  /** BLonSnvtType constant for SnvtSafe2. */
  @Generated
  public static final BLonSnvtType SnvtSafe2 = new BLonSnvtType(SNVT_SAFE_2);
  /** BLonSnvtType constant for SnvtSafe4. */
  @Generated
  public static final BLonSnvtType SnvtSafe4 = new BLonSnvtType(SNVT_SAFE_4);
  /** BLonSnvtType constant for SnvtSafe8. */
  @Generated
  public static final BLonSnvtType SnvtSafe8 = new BLonSnvtType(SNVT_SAFE_8);
  /** BLonSnvtType constant for SnvtTimeVal2. */
  @Generated
  public static final BLonSnvtType SnvtTimeVal2 = new BLonSnvtType(SNVT_TIME_VAL_2);
  /** BLonSnvtType constant for SnvtTimeOffset. */
  @Generated
  public static final BLonSnvtType SnvtTimeOffset = new BLonSnvtType(SNVT_TIME_OFFSET);
  /** BLonSnvtType constant for SnvtSchedExc. */
  @Generated
  public static final BLonSnvtType SnvtSchedExc = new BLonSnvtType(SNVT_SCHED_EXC);
  /** BLonSnvtType constant for SnvtSchedStatus. */
  @Generated
  public static final BLonSnvtType SnvtSchedStatus = new BLonSnvtType(SNVT_SCHED_STATUS);
  /** BLonSnvtType constant for SnvtMassFlow. */
  @Generated
  public static final BLonSnvtType SnvtMassFlow = new BLonSnvtType(SNVT_MASS_FLOW);
  /** BLonSnvtType constant for SnvtMassFlowF. */
  @Generated
  public static final BLonSnvtType SnvtMassFlowF = new BLonSnvtType(SNVT_MASS_FLOW_F);

  /** Factory method with ordinal. */
  @Generated
  public static BLonSnvtType make(int ordinal)
  {
    return (BLonSnvtType)SnvtXxx.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BLonSnvtType make(String tag)
  {
    return (BLonSnvtType)SnvtXxx.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BLonSnvtType(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BLonSnvtType DEFAULT = SnvtXxx;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BLonSnvtType.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public static final int LAST_SNVT_ID = 214;

  //DEVELOPER SLOT NOTE: Update Annotation version of Slot-o-matic uses a slightly different name derivation
  //                     function such that SnvtCount32 becomes SNVT_COUNT_32, not SNVT_COUNT32. Provide backwards
  //                     compatible ordinal values that allow old code to continue to function without having
  //                     to update to new variable names.

  /** Backwards compatible ordinal value for SnvtCount32. */
  public static final int SNVT_COUNT32 = SNVT_COUNT_32;
  /** Backwards compatible ordinal value for SnvtWm2P. */
  public static final int SNVT_WM_2_P = SNVT_WM_2P;

  //  // Create a list of snvt types for this class file
//  // to run >>nre lonworks:javax.baja.lonworks.enums.BLonSnvtType
//  public static void main(String[] args)
//  {
//      XLonInterfaceFile std = XUtil.getStandard();
//      Vector types = std.types;
//      String[] a = new String[255];
//int[] la = new int [255];
//      int maxNv = 0;
//      int maxLen = 0;
//      for(int i=0 ; i<types.size() ; i++)
//      {
//        XTypeDef t = ((XTypeDef)types.elementAt(i));
//        if(!t.isCpType())
//        {
//          int ndx = t.getTypeIndex();
//          if(ndx < 0) continue;
//          a[ndx] = t.getName();
//          if(ndx>maxNv) maxNv = ndx;
//          int len = NameUtil.toConstantName(a[ndx]).length();
//          if( len > maxLen) maxLen = len;
//try { la[ndx] = t.getLonData(std).getByteLength(); } catch(Exception e) {}
//        }
//      }
//
//      String pad = "                                          ";
//      System.out.println("  public static final int SNVT_XXX          = 0  ;");
//      for(int i=1; i<=maxNv ; i++)
//      {
//        if(a[i]==null) continue;
//        String conName = NameUtil.toConstantName(a[i]);
//        int padLen = maxLen - conName.length();
//        System.out.println("  public static final int SNVT_" +
//               conName + pad.substring(0,padLen) + " = " + i + "  ;");
//      }
//
//      System.out.println("\n\n");
//      System.out.println("  public static final int LAST_SNVT_ID  = " + maxNv + " ;\n");
//      System.out.println("  public static final BLonSnvtType SnvtXxx         = new BLonSnvtType(SNVT_XXX         );\n");
//
//      for(int i=1; i<=maxNv ; i++)
//      {
//        if(a[i]==null) continue;
//        String conName = NameUtil.toConstantName(a[i]);
//        int padLen = maxLen - a[i].length();
//        System.out.println("  public static final BLonSnvtType Snvt"
//                     + NameUtil.toJavaName(a[i],true) + pad.substring(0,padLen) +
//                      " = new BLonSnvtType(SNVT_" + conName + pad.substring(0,maxLen-conName.length()) +
//  ");  " + la[i]);
//      }
//
//  }
}
