/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.enums;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.*;

/**
 * BDisableAction is a BEnum containing values for the action that
 * should be taken when the loop is disabled. 
 * and reverse action PID loop logic
 *
 * @author    Dan Giorgis
 * @creation   9 Nov 00
 * @version   $Revision: 7$ $Date: 03-Jun-04 1:11:20 PM$
 * @since     Baja 1.0
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("maxValue"),
    @Range("minValue"),
    @Range("hold"),
    @Range("zero")
  }
)
public final class BDisableAction
  extends BFrozenEnum
{

//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $com.tridium.kitControl.enums.BDisableAction(1175135246)1.0$ @*/
/* Generated Thu Jun 02 14:30:03 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  /** Ordinal value for maxValue. */
  @Generated
  public static final int MAX_VALUE = 0;
  /** Ordinal value for minValue. */
  @Generated
  public static final int MIN_VALUE = 1;
  /** Ordinal value for hold. */
  @Generated
  public static final int HOLD = 2;
  /** Ordinal value for zero. */
  @Generated
  public static final int ZERO = 3;

  /** BDisableAction constant for maxValue. */
  @Generated
  public static final BDisableAction maxValue = new BDisableAction(MAX_VALUE);
  /** BDisableAction constant for minValue. */
  @Generated
  public static final BDisableAction minValue = new BDisableAction(MIN_VALUE);
  /** BDisableAction constant for hold. */
  @Generated
  public static final BDisableAction hold = new BDisableAction(HOLD);
  /** BDisableAction constant for zero. */
  @Generated
  public static final BDisableAction zero = new BDisableAction(ZERO);

  /** Factory method with ordinal. */
  @Generated
  public static BDisableAction make(int ordinal)
  {
    return (BDisableAction)maxValue.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BDisableAction make(String tag)
  {
    return (BDisableAction)maxValue.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BDisableAction(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BDisableAction DEFAULT = maxValue;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BDisableAction.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


}
