/*
 * Copyright 2025 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl;

import java.util.Map;

import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.offnormal.BFloatingLimitAlgorithm;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * This subclass of BFloatingLimitAlgorithm uses the grandparent BLoopPoint's setpoint property
 * instead of the algorithm's property. It also uses the BLoopPoint's controlledVariable property in
 * checkAlarms instead of the supplied out value.
 * 
 * @author Eric Anderson on 02 Aug 2025
 * @since Niagara 4.14u3, 4.15u2
 */
@NiagaraType
@NiagaraProperty(
  name = "setpoint",
  type = "BStatusNumeric",
  defaultValue = "new BStatusNumeric()",
  flags = Flags.HIDDEN,
  override = true
)
public class BLoopFloatingLimitAlgorithm
  extends BFloatingLimitAlgorithm
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $com.tridium.kitControl.BLoopFloatingLimitAlgorithm(3049943980)1.0$ @*/
/* Generated Sat Aug 02 17:15:26 CDT 2025 by Slot-o-Matic (c) Tridium, Inc. 2012-2025 */

  //region Property "setpoint"

  /**
   * Slot for the {@code setpoint} property.
   * @see #getSetpoint
   * @see #setSetpoint
   */
  @Generated
  public static final Property setpoint = newProperty(Flags.HIDDEN, new BStatusNumeric(), null);

  //endregion Property "setpoint"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BLoopFloatingLimitAlgorithm.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public boolean isGrandparentLegal(BComponent grandparent)
  {
    return grandparent instanceof BLoopPoint;
  }

  @Override
  public void started()
  {
    BAlarmSourceExt alarmExt = (BAlarmSourceExt)getParent();
    loopPoint = (BLoopPoint)alarmExt.getParent();

    super.started();
  }

  @Override
  protected BStatusNumeric getAlgorithmSetpoint()
  {
    return loopPoint.getSetpoint();
  }

  @Override
  public BAlarmState checkAlarms(BStatusValue out, long toAlarmTimeDelay, long toNormalTimeDelay)
  {
    // Since we are not subscribed to the loopPoint, we won't be notified of setpoint changes so
    // check that it's valid here.
    updateLastValidSetpoint();

    // Substitute the loopPoint's control value for its out value.
    return super.checkAlarms(loopPoint.getControlledVariable(), toAlarmTimeDelay, toNormalTimeDelay);
  }

  @Override
  @SuppressWarnings({ "rawtypes", "unchecked" })
  public void writeAlarmData(BStatusValue out, Map map)
  {
    super.writeAlarmData(out, map);
    map.put(BAlarmRecord.CONTROLLED_VALUE, BString.make(loopPoint.getControlledVariable().valueToString(loopPoint.getInputFacets())));
  }

  private BLoopPoint loopPoint;
}
