/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.enums;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.*;

/**
 * BAlign defines an enumeration for justification: 
 * top, left, bottom, right, or center.
 *
 * @author    Brian Frank
 * @creation  1 Dec 00
 * @version   $Revision: 4$ $Date: 3/23/05 11:29:07 AM EST$
 * @since     Baja 1.0
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("top"),
    @Range("left"),
    @Range("bottom"),
    @Range("right"),
    @Range("center")
  }
)
public final class BAlign
  extends BFrozenEnum
{

//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.ui.enums.BAlign(2654366229)1.0$ @*/
/* Generated Thu Jun 02 14:30:01 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  /** Ordinal value for top. */
  @Generated
  public static final int TOP = 0;
  /** Ordinal value for left. */
  @Generated
  public static final int LEFT = 1;
  /** Ordinal value for bottom. */
  @Generated
  public static final int BOTTOM = 2;
  /** Ordinal value for right. */
  @Generated
  public static final int RIGHT = 3;
  /** Ordinal value for center. */
  @Generated
  public static final int CENTER = 4;

  /** BAlign constant for top. */
  @Generated
  public static final BAlign top = new BAlign(TOP);
  /** BAlign constant for left. */
  @Generated
  public static final BAlign left = new BAlign(LEFT);
  /** BAlign constant for bottom. */
  @Generated
  public static final BAlign bottom = new BAlign(BOTTOM);
  /** BAlign constant for right. */
  @Generated
  public static final BAlign right = new BAlign(RIGHT);
  /** BAlign constant for center. */
  @Generated
  public static final BAlign center = new BAlign(CENTER);

  /** Factory method with ordinal. */
  @Generated
  public static BAlign make(int ordinal)
  {
    return (BAlign)top.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BAlign make(String tag)
  {
    return (BAlign)top.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BAlign(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BAlign DEFAULT = top;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BAlign.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
}
