/*
 * Copyright (c) 2018. Tridium, Inc. All Rights Reserved.
 */

package javax.baja.security.crypto;

import java.util.logging.Logger;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.nre.security.TlsCipherSuiteGroup;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(
  range = {
    @Range(value = "recommended", ordinal = 0),
    @Range(value = "supported", ordinal = 10)
  }
)
public final class BTlsCipherSuiteGroup
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.security.crypto.BTlsCipherSuiteGroup(1200264127)1.0$ @*/
/* Generated Thu Jun 02 14:30:01 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  /** Ordinal value for recommended. */
  @Generated
  public static final int RECOMMENDED = 0;
  /** Ordinal value for supported. */
  @Generated
  public static final int SUPPORTED = 10;

  /** BTlsCipherSuiteGroup constant for recommended. */
  @Generated
  public static final BTlsCipherSuiteGroup recommended = new BTlsCipherSuiteGroup(RECOMMENDED);
  /** BTlsCipherSuiteGroup constant for supported. */
  @Generated
  public static final BTlsCipherSuiteGroup supported = new BTlsCipherSuiteGroup(SUPPORTED);

  /** Factory method with ordinal. */
  @Generated
  public static BTlsCipherSuiteGroup make(int ordinal)
  {
    return (BTlsCipherSuiteGroup)recommended.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BTlsCipherSuiteGroup make(String tag)
  {
    return (BTlsCipherSuiteGroup)recommended.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BTlsCipherSuiteGroup(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BTlsCipherSuiteGroup DEFAULT = recommended;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BTlsCipherSuiteGroup.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public TlsCipherSuiteGroup getCipherSuiteGroup()
  {
    try
    {
      return TlsCipherSuiteGroup.getEnum(getTag());
    }
    catch(Exception e)
    {
      Logger.getLogger("baja").warning("error generating TlsCipherSuiteGroup from tag '" + getTag() + "', defaulting to recommended");
      return TlsCipherSuiteGroup.recommended;
    }
  }
}
