/**
 * Copyright 2011 - Tridium Inc, All Rights Reserved.
 */

package javax.baja.security.crypto;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BSslTlsEnum is a list of the supported ssl protocols
 * 
 * @author    $Author$
 * @creation  29 June 2011
 * @version   $Revision$ $Date$
 * @since     Niagara 3.7
 */

@NiagaraType
@NiagaraEnum(
  range = {
    @Range(value = "tlsv1", ordinal = 1),
    @Range(value = "tlsv1_1", ordinal = 2),
    @Range(value = "tlsv1_2", ordinal = 4),
    @Range(value = "tlsv1_3", ordinal = 8)
  },
  defaultValue = "tlsv1"
)
public final class BSslTlsEnum
    extends BFrozenEnum
{

//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.security.crypto.BSslTlsEnum(187256031)1.0$ @*/
/* Generated Thu Jun 02 14:30:01 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  /** Ordinal value for tlsv1. */
  @Generated
  public static final int TLSV_1 = 1;
  /** Ordinal value for tlsv1_1. */
  @Generated
  public static final int TLSV_1_1 = 2;
  /** Ordinal value for tlsv1_2. */
  @Generated
  public static final int TLSV_1_2 = 4;
  /** Ordinal value for tlsv1_3. */
  @Generated
  public static final int TLSV_1_3 = 8;

  /** BSslTlsEnum constant for tlsv1. */
  @Generated
  public static final BSslTlsEnum tlsv1 = new BSslTlsEnum(TLSV_1);
  /** BSslTlsEnum constant for tlsv1_1. */
  @Generated
  public static final BSslTlsEnum tlsv1_1 = new BSslTlsEnum(TLSV_1_1);
  /** BSslTlsEnum constant for tlsv1_2. */
  @Generated
  public static final BSslTlsEnum tlsv1_2 = new BSslTlsEnum(TLSV_1_2);
  /** BSslTlsEnum constant for tlsv1_3. */
  @Generated
  public static final BSslTlsEnum tlsv1_3 = new BSslTlsEnum(TLSV_1_3);

  /** Factory method with ordinal. */
  @Generated
  public static BSslTlsEnum make(int ordinal)
  {
    return (BSslTlsEnum)tlsv1.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BSslTlsEnum make(String tag)
  {
    return (BSslTlsEnum)tlsv1.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BSslTlsEnum(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BSslTlsEnum DEFAULT = tlsv1;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BSslTlsEnum.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
