/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import javax.baja.sys.LocalizableRuntimeException;

/**
 * Exception that indicates that password encoding requires a
 * key, but none is available
 *
 * @author Matt Boon
 * @creation February 13, 2015
 * @since Niagara 4.0
 */
public class MissingEncodingKeyException
  extends LocalizableRuntimeException
{
  public MissingEncodingKeyException()
  {
    super("baja", "missingEncodingKey");
  }
}
