/**
 * Copyright 2014 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * A simple credential containing only a username.
 *
 * @author Melanie Coggan
 * @creation 2014-03-07
 * @since Niagara 4.0
 */
@NiagaraType
/*
 The username field.
 */
@NiagaraProperty(
  name = "username",
  type = "BString",
  defaultValue = ""
)
public class BUsernameCredential
  extends BStruct
  implements BIUserCredentials
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.security.BUsernameCredential(3828798011)1.0$ @*/
/* Generated Thu Jun 02 14:30:01 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "username"

  /**
   * Slot for the {@code username} property.
   * The username field.
   * @see #getUsername
   * @see #setUsername
   */
  @Generated
  public static final Property username = newProperty(0, "", null);

  /**
   * Get the {@code username} property.
   * The username field.
   * @see #username
   */
  @Generated
  public String getUsername() { return getString(username); }

  /**
   * Set the {@code username} property.
   * The username field.
   * @see #username
   */
  @Generated
  public void setUsername(String v) { setString(username, v, null); }

  //endregion Property "username"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BUsernameCredential.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////
  public BUsernameCredential()
  {}

  public BUsernameCredential(String username)
  {
    setUsername(username);
  }

////////////////////////////////////////////////////////////////
// BICredentials
////////////////////////////////////////////////////////////////
  @Override
  public byte[] encodeCredentials(Context context) throws IOException
  {
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    DataOutputStream out = new DataOutputStream(bout);
    BString.make(getUsername()).encode(out);
    out.flush();
    return bout.toByteArray();
  }

  @Override
  public BICredentials decodeCredentials(byte[] encoding, Context context) throws IOException
  {
    ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
    DataInputStream in = new DataInputStream(bin);
    BUsernameCredential x = (BUsernameCredential)newCopy();
    x.set(username, (BValue)BString.DEFAULT.decode(in));
    return x;
  }

  /**
   * Two BUsernameCredential objects are equivalent if they have the same class, and username.
   */
  @Override
  public synchronized boolean equivalent(Object obj)
  {
    return obj != null &&
      obj.getClass() == getClass() &&
      SecurityUtil.equals(((BUsernameCredential)obj).getUsername(), getUsername());
  }
}
