/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BIUserCredentials is a type of {@link BICredentials} object that enforces
 * the association of a Username with the credentials.
 *
 * @author 		J. Spangler
 * @creation 	Jul 21, 2010
 * @version		1
 * @since			Niagara 3.6
 */
@NiagaraType
public interface BIUserCredentials
    extends BICredentials
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.security.BIUserCredentials(2979906276)1.0$ @*/
/* Generated Wed Dec 29 19:27:38 CST 2021 by Slot-o-Matic (c) Tridium, Inc. 2012-2021 */

  //region Type

  @Generated
  Type TYPE = Sys.loadType(BIUserCredentials.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
  /** 
   * Return the user name associated with the credentials. It is assumed
   * that all credentials are associated with some user.
   * 
   * @return String
   * @since Niagara 3.6
   */
  public String getUsername();

  /**
   * Returns a boolean indicating whether the credential represents a new
   * user with no stored credentials.
   *
   * @return
   */
  public default boolean isNewUser()  { return false; }
  
}
