/*
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.security;

import java.util.Map;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BICredentials that specifies a map of extra attributes to be included in the
 * username message.
 *
 * @author Patrick Sager on 8/23/2019
 * @since Niagara 4.9
 */
@NiagaraType
public interface BIExtraAttributesCredentials
  extends BICredentials
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.security.BIExtraAttributesCredentials(2979906276)1.0$ @*/
/* Generated Wed Dec 29 19:27:38 CST 2021 by Slot-o-Matic (c) Tridium, Inc. 2012-2021 */

  //region Type

  @Generated
  Type TYPE = Sys.loadType(BIExtraAttributesCredentials.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Get a Map of extra attributes. Supported value types are Boolean, Integer, Double,
   * String, Long, and byte[]
   *
   * @return a map of extra attributes
   */
  public Map<String, Object> getExtraAttributes();
}
