/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(
  agent = @AgentOn(
    types = "baja:ClientCredentials"
  )
)
@NiagaraProperty(
  name = "username",
  type = "String",
  defaultValue = "BString.DEFAULT"
)
@NiagaraProperty(
  name = "sessionId",
  type = "String",
  defaultValue = "BString.DEFAULT"
)
public class BHttpFoxCredentials
    extends BStruct
    implements BIUserCredentials, BIAgent
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.security.BHttpFoxCredentials(67314821)1.0$ @*/
/* Generated Thu Jun 02 14:30:01 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "username"

  /**
   * Slot for the {@code username} property.
   * @see #getUsername
   * @see #setUsername
   */
  @Generated
  public static final Property username = newProperty(0, BString.DEFAULT, null);

  /**
   * Get the {@code username} property.
   * @see #username
   */
  @Generated
  public String getUsername() { return getString(username); }

  /**
   * Set the {@code username} property.
   * @see #username
   */
  @Generated
  public void setUsername(String v) { setString(username, v, null); }

  //endregion Property "username"

  //region Property "sessionId"

  /**
   * Slot for the {@code sessionId} property.
   * @see #getSessionId
   * @see #setSessionId
   */
  @Generated
  public static final Property sessionId = newProperty(0, BString.DEFAULT, null);

  /**
   * Get the {@code sessionId} property.
   * @see #sessionId
   */
  @Generated
  public String getSessionId() { return getString(sessionId); }

  /**
   * Set the {@code sessionId} property.
   * @see #sessionId
   */
  @Generated
  public void setSessionId(String v) { setString(sessionId, v, null); }

  //endregion Property "sessionId"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BHttpFoxCredentials.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Default constructor
   */
  public BHttpFoxCredentials()
  {}
  
  /**
   * @param username - String user being authenticated.
   * @param sessionId - String Id of previously authenticated session.
   */
  public BHttpFoxCredentials(String username, String sessionId)
  {
    setUsername(username);
    setSessionId(sessionId);
  }

  public BICredentials decodeCredentials(byte[] encoding, Context context) throws IOException
  {
    ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
    DataInputStream in = new DataInputStream(bin);
    BHttpFoxCredentials x = (BHttpFoxCredentials)newCopy();
    x.set(username, (BValue)BString.DEFAULT.decode(in));
    x.set(sessionId, (BValue)BString.DEFAULT.decode(in));
    return x;
  }

  @Override
  public byte[] encodeCredentials(Context context) throws IOException
  {
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    DataOutputStream out = new DataOutputStream(bout);
    BString.make(getUsername()).encode(out);
    BString.make(getSessionId()).encode(out);
    out.flush();
    return bout.toByteArray();
  }

  /**
   * Two BUsernameAndPassword objects are equivalent if they have the same class, username
   * and password.
   */
  @Override
  public boolean equivalent(Object obj)
  {
    return obj != null &&
      obj.getClass() == getClass() &&
      SecurityUtil.equals(((BHttpFoxCredentials)obj).getUsername(), getUsername()) &&
      SecurityUtil.equals(((BHttpFoxCredentials)obj).getSessionId(), getSessionId());
  }
}
