/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.virtual;

import java.util.HashMap;
import java.util.logging.Logger;

import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetPropertyReference;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetAnalogWritableDescriptor;
import javax.baja.bacnet.export.BBacnetBinaryWritableDescriptor;
import javax.baja.bacnet.export.BBacnetMultiStateWritableDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.job.BacnetDiscoveryUtil;

@NiagaraType
public class BLocalBacnetVirtualObject
  extends BBacnetVirtualObject
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.virtual.BLocalBacnetVirtualObject(2979906276)1.0$ @*/
/* Generated Thu Dec 16 19:44:32 CST 2021 by Slot-o-Matic (c) Tridium, Inc. 2012-2021 */

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BLocalBacnetVirtualObject.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BLocalBacnetVirtualObject()
  {
  }

  public BLocalBacnetVirtualObject(BLocalBacnetVirtualGateway lgw, String virtualPathName)
  {
    super(virtualPathName);
    export = lgw.localDevice().lookupBacnetObject(getObjectId());
  }

  public BLocalBacnetVirtualObject(BIBacnetExportObject o)
  {
    super();
    export = o;
    if (o != null)
      setObjectId(o.getObjectId());
  }

  @Override
  public boolean isChildLegal(BComponent child)
  {
    return child instanceof BLocalBacnetVirtualProperty;
  }

  @Override
  public BBacnetDevice device()
  {
    throw new UnsupportedOperationException("Not supported for LocalBacnetVirtualObject");
  }

  @Override
  protected void discoverFacets()
  {
    // Discover the facets to be used for this point.
    HashMap<String, BIDataValue> map = new HashMap<>();
    if (getObjectId().isValid())
    {
      int[] facetProps = BacnetDiscoveryUtil.getFacetProps(getObjectId().getObjectType());
      if (facetProps != null)
      {
        for (int i = 0; i < facetProps.length; i++)
        {
          try
          {
            PropertyValue pv = export.readProperty(new BBacnetPropertyReference(facetProps[i]));

            if (!pv.isError())
              BacnetDiscoveryUtil.addFacet(facetProps[i], pv.getPropertyValue(), map, null);
          }
          catch (BacnetException e)
          {
            loggerBacnetClient.info("BacnetException reading property " + BBacnetPropertyIdentifier.tag(facetProps[i]) + " in " + objectId + ": " + e);
          }
          catch (Exception e)
          {
            loggerBacnetClient.info("Exception reading property " + BBacnetPropertyIdentifier.tag(facetProps[i]) + " in " + objectId + ": " + e);
          }
        } // for
      } // facetProps
    } // objectId
    setFacets(BFacets.make(map));

    // Check if this is a prioritized point.
    switch (getObjectId().getObjectType())
    {
      case BBacnetObjectType.ANALOG_OUTPUT:
      case BBacnetObjectType.BINARY_OUTPUT:
      case BBacnetObjectType.MULTI_STATE_OUTPUT:
      case BBacnetObjectType.CHARACTER_STRING_VALUE:
        setPrioritizedPoint(true);
        break;

      case BBacnetObjectType.ANALOG_VALUE:
      case BBacnetObjectType.LARGE_ANALOG_VALUE:
      case BBacnetObjectType.INTEGER_VALUE:
      case BBacnetObjectType.POSITIVE_INTEGER_VALUE:
        setPrioritizedPoint(export instanceof BBacnetAnalogWritableDescriptor);
        break;

      case BBacnetObjectType.BINARY_VALUE:
        setPrioritizedPoint(export instanceof BBacnetBinaryWritableDescriptor);
        break;

      case BBacnetObjectType.MULTI_STATE_VALUE:
        setPrioritizedPoint(export instanceof BBacnetMultiStateWritableDescriptor);
        break;

      default:
        setPrioritizedPoint(false);
    }
  }

  BIBacnetExportObject getExport()
  {
    return export;
  }

  private BIBacnetExportObject export;

  private static final Logger loggerBacnetClient = Logger.getLogger("bacnet.client");
}
