/*
 * Copyright 2022 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.io;

/**
 * A DuplicateEntryException is thrown whenever a duplicate entry error is detected in encoding or
 * decoding an Asn production. For example, when the Weekly_Schedule property is written
 * with a value containing a duplicate time within any single day (135-2020 12.24.7) or when the
 * Exception_Schedule property is written with a BACnetSpecialEvent containing a duplicate time in
 * any particular SEQUENCE OF TimeValue (135-2020 12.24.8).
 *
 * @author Eric Anderson on 23 Nov 2022
 * @since Niagara 4.14
 */

public class DuplicateEntryException
  extends AsnException
{
  /**
   * Constructor with specified detailed message.
   *
   * @param detailMessage the error message.
   */
  public DuplicateEntryException(String detailMessage)
  {
    super(detailMessage);
  }
}
