/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.io;

import javax.baja.bacnet.BacnetException;

/**
 * An AsnException is thrown whenever a error is
 * detected in encoding or decoding an Asn production.
 *
 * @author Craig Gemmill
 * @version $Revision: 2$ $Date: 12/19/01 4:35:43 PM$
 * @creation 28 Jul 00
 * @since Niagara 3 Bacnet 1.0
 */

public class AsnException
  extends BacnetException
{
  /**
   * Constructor with specified detailed message.
   *
   * @param detailMessage the error message.
   */
  public AsnException(String detailMessage)
  {
    super(detailMessage);
  }

  public String toString()
  {
    return lex.getText("AsnException.asn") + ":" + getMessage();
  }
}
