/*
 * Copyright 2022 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetAccumulatorStatus represents the status of BACnetAccumulatorRecord.
 *
 * @author Bishal Debbarma
 * @since Niagara 4.14
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range(value = "normal", ordinal = 0),
    @Range(value = "starting", ordinal = 1),
    @Range(value = "recovered", ordinal = 2),
    @Range(value = "abnormal", ordinal = 3),
    @Range(value = "failed", ordinal = 4)
  }
)
public final class BBacnetAccumulatorStatus
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.enums.BBacnetAccumulatorStatus(796979589)1.0$ @*/
/* Generated Tue Jul 25 19:51:40 CDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  /** Ordinal value for normal. */
  @Generated
  public static final int NORMAL = 0;
  /** Ordinal value for starting. */
  @Generated
  public static final int STARTING = 1;
  /** Ordinal value for recovered. */
  @Generated
  public static final int RECOVERED = 2;
  /** Ordinal value for abnormal. */
  @Generated
  public static final int ABNORMAL = 3;
  /** Ordinal value for failed. */
  @Generated
  public static final int FAILED = 4;

  /** BBacnetAccumulatorStatus constant for normal. */
  @Generated
  public static final BBacnetAccumulatorStatus normal = new BBacnetAccumulatorStatus(NORMAL);
  /** BBacnetAccumulatorStatus constant for starting. */
  @Generated
  public static final BBacnetAccumulatorStatus starting = new BBacnetAccumulatorStatus(STARTING);
  /** BBacnetAccumulatorStatus constant for recovered. */
  @Generated
  public static final BBacnetAccumulatorStatus recovered = new BBacnetAccumulatorStatus(RECOVERED);
  /** BBacnetAccumulatorStatus constant for abnormal. */
  @Generated
  public static final BBacnetAccumulatorStatus abnormal = new BBacnetAccumulatorStatus(ABNORMAL);
  /** BBacnetAccumulatorStatus constant for failed. */
  @Generated
  public static final BBacnetAccumulatorStatus failed = new BBacnetAccumulatorStatus(FAILED);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetAccumulatorStatus make(int ordinal)
  {
    return (BBacnetAccumulatorStatus)normal.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetAccumulatorStatus make(String tag)
  {
    return (BBacnetAccumulatorStatus)normal.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetAccumulatorStatus(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetAccumulatorStatus DEFAULT = normal;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetAccumulatorStatus.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
