/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import java.util.ArrayList;
import java.util.List;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnConst;

/**
 * BReadAccessSpecification represents the ReadAccessSpecification sequence.
 * This is used in the Group object.  It is not the class used for handling
 * ReadAccessSpecifications in the usage of ReadPropertyMultiple during
 * polling.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 26 Jul 2005
 * @since Niagara 3.1
 */
@NiagaraType
@NiagaraProperty(
  name = "objectIdentifier",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.DEFAULT"
)
/*
 @since Niagara 4.14u3, 4.15u2
 */
@NiagaraAction(
  name = "addPropertyReference",
  parameterType = "BBacnetPropertyReference",
  defaultValue = "new BBacnetPropertyReference()"
)
public class BReadAccessSpecification
  extends BComponent
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BReadAccessSpecification(2139738022)1.0$ @*/
/* Generated Fri Jun 13 15:39:10 CDT 2025 by Slot-o-Matic (c) Tridium, Inc. 2012-2025 */

  //region Property "objectIdentifier"

  /**
   * Slot for the {@code objectIdentifier} property.
   * @see #getObjectIdentifier
   * @see #setObjectIdentifier
   */
  @Generated
  public static final Property objectIdentifier = newProperty(0, BBacnetObjectIdentifier.DEFAULT, null);

  /**
   * Get the {@code objectIdentifier} property.
   * @see #objectIdentifier
   */
  @Generated
  public BBacnetObjectIdentifier getObjectIdentifier() { return (BBacnetObjectIdentifier)get(objectIdentifier); }

  /**
   * Set the {@code objectIdentifier} property.
   * @see #objectIdentifier
   */
  @Generated
  public void setObjectIdentifier(BBacnetObjectIdentifier v) { set(objectIdentifier, v, null); }

  //endregion Property "objectIdentifier"

  //region Action "addPropertyReference"

  /**
   * Slot for the {@code addPropertyReference} action.
   * @since Niagara 4.14u3, 4.15u2
   * @see #addPropertyReference(BBacnetPropertyReference parameter)
   */
  @Generated
  public static final Action addPropertyReference = newAction(0, new BBacnetPropertyReference(), null);

  /**
   * Invoke the {@code addPropertyReference} action.
   * @since Niagara 4.14u3, 4.15u2
   * @see #addPropertyReference
   */
  @Generated
  public void addPropertyReference(BBacnetPropertyReference parameter) { invoke(addPropertyReference, parameter, null); }

  //endregion Action "addPropertyReference"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BReadAccessSpecification.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Constructors
////////////////////////////////////////////////////////////////

  /**
   * Default constructor.
   */
  public BReadAccessSpecification()
  {
  }

  /**
   * Single reference constructor.
   */
  public BReadAccessSpecification(BBacnetPropertyReference ref)
  {
    // FIXX: will determine if we need to do newCopy(), or if use cases
    // will not require it.
    add(null, ref);
  }

  /**
   * Single reference constructor.
   */
  public BReadAccessSpecification(BBacnetPropertyReference[] refs)
  {
    // FIXX: will determine if we need to do newCopy(), or if use cases
    // will not require it.
    if (refs != null)
    {
      for (int i = 0; i < refs.length; i++)
        add(null, refs[i]);
    }
  }


////////////////////////////////////////////////////////////////
//  BComponent
////////////////////////////////////////////////////////////////

  /**
   * No component children are allowed.  The only valid child is a
   * BBacnetObjectPropertyReference.
   */
  @Override
  public boolean isChildLegal(BComponent child)
  {
    return false;
  }

  @Override
  public void changed(Property property, Context context)
  {
    super.changed(property, context);

    if (!isRunning())
    {
      return;
    }

    // When any properties are changed, a parent config needs to write that to the remote device.
    notifyParentOfChange(context);
  }

  @Override
  public void added(Property property, Context context)
  {
    super.added(property, context);

    if (!isRunning())
    {
      return;
    }

    BValue newValue = get(property);
    if (newValue instanceof BBacnetPropertyReference)
    {
      // When a BACnetPropertyReference is added, a parent config needs to write that to the remote
      // device.
      notifyParentOfChange(context);
    }
  }

  @Override
  public void removed(Property property, BValue oldValue, Context context)
  {
    super.removed(property, oldValue, context);

    if (!isRunning())
    {
      return;
    }

    if (oldValue instanceof BBacnetPropertyReference)
    {
      // When a BACnetPropertyReference is removed, a parent config needs to write that to the
      // remote device.
      notifyParentOfChange(context);
    }
  }

  private void notifyParentOfChange(Context context)
  {
    BComplex parent = getParent();
    Property propertyInParent = getPropertyInParent();
    if (parent instanceof BComponent && propertyInParent != null)
    {
      ((BComponent) parent).changed(propertyInParent, context);
    }
  }

  public void doAddPropertyReference(BBacnetPropertyReference value, Context context)
  {
    add(null, value, context);
  }

  @Override
  public String toString(Context cx)
  {
    loadSlots();
    Object[] a = getChildren(BBacnetPropertyReference.class);

    StringBuilder sb = new StringBuilder(getObjectIdentifier().toString(cx));
    sb.append("{");
    for (int i = 0; i < a.length; i++)
    {
      sb.append(((BObject)a[i]).toString(cx)).append(',');
    }
    sb.append('}');
    return sb.toString();
  }


////////////////////////////////////////////////////////////////
//  Conversion
////////////////////////////////////////////////////////////////

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  public void writeAsn(AsnOutput out)
  {
    out.writeObjectIdentifier(OBJECT_ID_TAG, getObjectIdentifier());
    out.writeOpeningTag(LIST_OF_PROPERTY_REFERENCES_TAG);

    SlotCursor<Property> sc = getProperties();
    while (sc.next(BBacnetPropertyReference.class))
    {
      BBacnetPropertyReference propRef = (BBacnetPropertyReference)sc.get();
      propRef.writeAsn(out);
    }

    out.writeClosingTag(LIST_OF_PROPERTY_REFERENCES_TAG);
  }

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  public void readAsn(AsnInput in)
    throws AsnException
  {
    BBacnetObjectIdentifier objectIdentifier = in.readObjectIdentifier(OBJECT_ID_TAG);
    in.skipOpeningTag(LIST_OF_PROPERTY_REFERENCES_TAG);
    int tag = in.peekTag();
    List<BBacnetPropertyReference> propRefs = new ArrayList<>();
    while (!in.isClosingTag(LIST_OF_PROPERTY_REFERENCES_TAG))
    {
      if (tag == AsnInput.END_OF_DATA)
        throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);

      BBacnetPropertyReference propRef = new BBacnetPropertyReference();
      propRef.readAsn(in);
      propRefs.add(propRef);
      tag = in.peekTag();
    }
    in.skipClosingTag(LIST_OF_PROPERTY_REFERENCES_TAG);

    set(BReadAccessSpecification.objectIdentifier, objectIdentifier, noWrite);
    removeAll(noWrite);
    int length = propRefs.size();
    for (int i = 0; i < length; i++)
    {
      add("propertyReference" + (i + 1), propRefs.get(i), noWrite);
    }
  }


////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////

  public static final int OBJECT_ID_TAG = 0;
  public static final int LIST_OF_PROPERTY_REFERENCES_TAG = 1;


}
