/*
 * Copyright 2025 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDate;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnConst;

/**
 * Represents the BACnetOptionalDate choice, which may be null or contain a BACnet date value.
 *
 * @author Uday Rapuru on 08-Apr-2025
 * @since Niagara 4.14u2
 * @since Niagara 4.15u1
 */
@NiagaraType
@NiagaraProperty(
  name = "isNull",
  type = "boolean",
  defaultValue = "true"
)
@NiagaraProperty(
  name = "value",
  type = "BDate",
  defaultValue = "BDate.DEFAULT"
)
public class BBacnetOptionalDate
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetOptionalDate(2291145103)1.0$ @*/
/* Generated Tue Apr 08 20:03:42 IST 2025 by Slot-o-Matic (c) Tridium, Inc. 2012-2025 */

  //region Property "isNull"

  /**
   * Slot for the {@code isNull} property.
   * @see #getIsNull
   * @see #setIsNull
   */
  @Generated
  public static final Property isNull = newProperty(0, true, null);

  /**
   * Get the {@code isNull} property.
   * @see #isNull
   */
  @Generated
  public boolean getIsNull() { return getBoolean(isNull); }

  /**
   * Set the {@code isNull} property.
   * @see #isNull
   */
  @Generated
  public void setIsNull(boolean v) { setBoolean(isNull, v, null); }

  //endregion Property "isNull"

  //region Property "value"

  /**
   * Slot for the {@code value} property.
   * @see #getValue
   * @see #setValue
   */
  @Generated
  public static final Property value = newProperty(0, BDate.DEFAULT, null);

  /**
   * Get the {@code value} property.
   * @see #value
   */
  @Generated
  public BDate getValue() { return (BDate)get(value); }

  /**
   * Set the {@code value} property.
   * @see #value
   */
  @Generated
  public void setValue(BDate v) { set(value, v, null); }

  //endregion Property "value"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetOptionalDate.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BBacnetOptionalDate()
  {
  }

  public BBacnetOptionalDate(BDate value)
  {
    setIsNull(false);
    setValue(value);
  }

  @Override
  public boolean isNull()
  {
    return getIsNull();
  }

  @Override
  public void writeAsn(AsnOutput out)
  {
    if (getIsNull())
    {
      out.writeNull();
    }
    else
    {
      BDate date = getValue();
      out.writeDate(BAbsTime.make(date.getYear(), date.getMonth(), date.getDay()));
    }
  }

  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    int tag = in.peekTag();
    switch (tag)
    {
      case BacnetConst.ASN_NULL:
        in.readNull();
        setBoolean(isNull, true, noWrite);
        break;
      case BacnetConst.ASN_DATE:
        BBacnetDate bacnetDate = in.readDate();
        if (bacnetDate.isAnyUnspecified() || bacnetDate.isMonthSpecial() || bacnetDate.isDayOfMonthSpecial())
        {
          throw new OutOfRangeException("Decoded BACnet date pattern in BACnetOptionalDate: " + bacnetDate);
        }
        BDate date = bacnetDate.toBDate();
        setBoolean(isNull, false, noWrite);
        set(value, date, noWrite);
        break;
      default:
        throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
    }
  }

  @Override
  public String toString(Context context)
  {
    return getIsNull() ? "null" : getValue().toString(context);
  }
}
