/*
 * Copyright 2017 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.baja.bacnet.enums.BBacnetLifeSafetyState;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.AsnInputStream;

/**
 * Created by Sandipan Aich on 3/24/2017.
 */
@NiagaraType
@NiagaraProperty(
  name = "choice",
  type = "int",
  defaultValue = "0"
)
public class BBacnetFaultParameter extends BComponent implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetFaultParameter(946239666)1.0$ @*/
/* Generated Thu Jun 02 14:30:03 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "choice"

  /**
   * Slot for the {@code choice} property.
   * @see #getChoice
   * @see #setChoice
   */
  @Generated
  public static final Property choice = newProperty(0, 0, null);

  /**
   * Get the {@code choice} property.
   * @see #choice
   */
  @Generated
  public int getChoice() { return getInt(choice); }

  /**
   * Set the {@code choice} property.
   * @see #choice
   */
  @Generated
  public void setChoice(int v) { setInt(choice, v, null); }

  //endregion Property "choice"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetFaultParameter.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public void writeAsn(AsnOutput out)
  {
    int choice = getChoice();
    if (choice < 0 || choice > MAX_FAULT_PARAMETER_CHOICE)
    {
      throw new IllegalStateException("Invalid BACnetFaultParameter choice: " + choice);
    }

    out.writeOpeningTag(choice);

    try
    {
      switch(choice)
      {
        case NONE:
          out.writeNull();
          break;
        case FAULT_CHARACTERSTRING:
          out.writeOpeningTag(FAULT_CHARACTERSTRING_LIST_OF_FAULT_VALUES);
          ((BBacnetListOf)get("listOfFaultValues")).writeAsn(out);
          out.writeClosingTag(FAULT_CHARACTERSTRING_LIST_OF_FAULT_VALUES);
          break;
        case FAULT_EXTENDED:
          out.writeUnsigned(FAULT_EXTENDED_VENDOR_ID, (BBacnetUnsigned)get("vendorId"));
          out.writeUnsigned(FAULT_EXTENDED_EXTENDED_FAULT_TYPE, (BBacnetUnsigned)get("extendedFaultType"));
          out.writeEncodedValue(FAULT_EXTENDED_PARAMETERS, ((BBlob)get("parameters")).copyBytes());
          break;
        case FAULT_LIFE_SAFETY:
          out.writeOpeningTag(FAULT_LIFE_SAFETY_LIST_OF_FAULT_VALUES);
          ((BBacnetListOf)get("listOfFaultValues")).writeAsn(out);
          out.writeClosingTag(FAULT_LIFE_SAFETY_LIST_OF_FAULT_VALUES);

          out.writeOpeningTag(FAULT_LIFE_SAFETY_MODE_PROPERTY_REFERENCE);
          ((BBacnetDeviceObjectPropertyReference)get("modePropertyReference")).writeAsn(out);
          out.writeClosingTag(FAULT_LIFE_SAFETY_MODE_PROPERTY_REFERENCE);
          break;
        case FAULT_STATE:
          out.writeOpeningTag(FAULT_STATE_LIST_OF_FAULT_VALUES);
          ((BBacnetListOf)get("listOfFaultValues")).writeAsn(out);
          out.writeClosingTag(FAULT_STATE_LIST_OF_FAULT_VALUES);
          break;
        case FAULT_STATUS_FLAGS:
          out.writeOpeningTag(FAULT_STATUS_FLAGS_STATUS_FLAGS_REFERENCE);
          ((BBacnetDeviceObjectPropertyReference)get("statusFlagsReference")).writeAsn(out);
          out.writeClosingTag(FAULT_STATUS_FLAGS_STATUS_FLAGS_REFERENCE);
          break;
        case FAULT_OUT_OF_RANGE:
          out.writeOpeningTag(0);
          writeFaultOutOfRangeValue("minNormalValue", out);
          out.writeClosingTag(0);

          out.writeOpeningTag(1);
          writeFaultOutOfRangeValue("maxNormalValue", out);
          out.writeClosingTag(1);
          break;
      }
    }
    catch (Exception e)
    {
      logger.log(Level.SEVERE, "BBacnetFaultParameter writeAsn failure", e);
      throw new IllegalStateException(e);
    }

    out.writeClosingTag(choice);
  }

  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    int tag = in.peekTag();
    if (tag < 0 || tag > MAX_FAULT_PARAMETER_CHOICE)
    {
      throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
    }

    in.skipOpeningTag(tag);
    switch (tag)
    {
      case NONE:
        in.readNull();
        in.skipClosingTag(tag);
        updateChoice(tag);
        break;

      case FAULT_CHARACTERSTRING:
      {
        BBacnetListOf listOfFaultValues = new BBacnetListOf(BString.TYPE);
        listOfFaultValues.readAsn(AsnInputStream.make(in.readEncodedValue(FAULT_CHARACTERSTRING_LIST_OF_FAULT_VALUES)));
        in.skipClosingTag(tag);

        updateChoice(tag);
        BacUtil.setOrAdd(this, "listOfFaultValues", listOfFaultValues, noWrite);
        break;
      }

      case FAULT_EXTENDED:
      {
        long vendorId = in.readUnsignedInteger(FAULT_EXTENDED_VENDOR_ID);
        long extendedFaultType = in.readUnsignedInteger(FAULT_EXTENDED_EXTENDED_FAULT_TYPE);
        byte[] parameters = in.readEncodedValue(FAULT_EXTENDED_PARAMETERS);
        in.skipClosingTag(tag);

        updateChoice(tag);
        BacUtil.setOrAdd(this, "vendorId", BBacnetUnsigned.make(vendorId), noWrite);
        BacUtil.setOrAdd(this, "extendedFaultType", BBacnetUnsigned.make(extendedFaultType), noWrite);
        BacUtil.setOrAdd(this, "parameters", BBlob.make(parameters), noWrite);
        break;
      }

      case FAULT_LIFE_SAFETY:
      {
        BBacnetListOf listOfFaultValues = new BBacnetListOf(BBacnetLifeSafetyState.TYPE);
        listOfFaultValues.readAsn(AsnInputStream.make(in.readEncodedValue(FAULT_LIFE_SAFETY_LIST_OF_FAULT_VALUES)));
        BBacnetDeviceObjectPropertyReference modePropertyReference = new BBacnetDeviceObjectPropertyReference();
        in.skipOpeningTag(FAULT_LIFE_SAFETY_MODE_PROPERTY_REFERENCE);
        modePropertyReference.readAsn(in);
        in.skipClosingTag(FAULT_LIFE_SAFETY_MODE_PROPERTY_REFERENCE);
        in.skipClosingTag(tag);

        updateChoice(tag);
        BacUtil.setOrAdd(this, "listOfFaultValues", listOfFaultValues, noWrite);
        BacUtil.setOrAdd(this, "modePropertyReference", modePropertyReference, noWrite);
        break;
      }

      case FAULT_STATE:
      {
        BBacnetListOf listOfFaultValues = new BBacnetListOf(BBacnetPropertyStates.TYPE);
        listOfFaultValues.readAsn(AsnInputStream.make(in.readEncodedValue(FAULT_STATE_LIST_OF_FAULT_VALUES)));
        in.skipClosingTag(tag);

        updateChoice(tag);
        BacUtil.setOrAdd(this, "listOfFaultValues", listOfFaultValues, noWrite);
        break;
      }

      case FAULT_STATUS_FLAGS:
      {
        BBacnetDeviceObjectPropertyReference statusFlagsReference = new BBacnetDeviceObjectPropertyReference();
        in.skipOpeningTag(0);
        statusFlagsReference.readAsn(in);
        in.skipClosingTag(0);
        in.skipClosingTag(tag);

        updateChoice(tag);
        BacUtil.setOrAdd(this, "statusFlagsReference", statusFlagsReference, noWrite);
        break;
      }

      case FAULT_OUT_OF_RANGE:
      {
        in.skipOpeningTag(0);
        BValue minNormalValue = readFaultOutOfRangeValue(in);
        in.skipClosingTag(0);
        in.skipOpeningTag(1);
        BValue maxNormalValue = readFaultOutOfRangeValue(in);
        in.skipClosingTag(1);
        in.skipClosingTag(tag);

        updateChoice(tag);
        BacUtil.setOrAdd(this, "minNormalValue", minNormalValue, noWrite);
        BacUtil.setOrAdd(this, "maxNormalValue", maxNormalValue, noWrite);
        break;
      }
    }
  }

  private void updateChoice(int choice)
  {
    // If choice changed, remove anything that used to be here.
    if (choice != getChoice())
    {
      removeAll(noWrite);
    }

    setInt(BBacnetFaultParameter.choice, choice, noWrite);
  }

  private static BValue readFaultOutOfRangeValue(AsnInput in)
    throws AsnException
  {
    int tag = in.peekTag();
    switch (tag)
    {
      case ASN_REAL:
        return BFloat.make(in.readReal());
      case ASN_UNSIGNED:
        return in.readUnsigned();
      case ASN_DOUBLE:
        return BDouble.make(in.readDouble());
      case ASN_INTEGER:
        return in.readSigned();
      default:
        throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
    }
  }

  private void writeFaultOutOfRangeValue(String propertyName, AsnOutput out)
  {
    BValue value = get(propertyName);
    if (value instanceof BFloat)
    {
      out.writeReal((BFloat) value);
    }
    else if (value instanceof BBacnetUnsigned)
    {
      out.writeUnsigned((BBacnetUnsigned) value);
    }
    else if (value instanceof BDouble)
    {
      out.writeDouble((BDouble) value);
    }
    else if (value instanceof BInteger)
    {
      out.writeSignedInteger((BInteger) value);
    }
    else
    {
      throw new IllegalStateException("Invalid Fault OutOfRange Value type: " + (value != null ? value.getType() : "null"));
    }
  }

  ////////////////////////////////////////////////////////////////
// Spy
////////////////////////////////////////////////////////////////

  public void spy(SpyWriter out) throws Exception
  {
    super.spy(out);
    out.startProps();
    out.trTitle("BacnetFaultParameter", 2);
    out.prop("virtual", BacnetVirtualUtil.isVirtual(this));
    out.endProps();
  }


/////////////////////////////////////////////////////////////////
//  Constants
/////////////////////////////////////////////////////////////////

  public static final int NONE = 0;


  public static final int FAULT_CHARACTERSTRING = 1;
  public static final int FAULT_CHARACTERSTRING_LIST_OF_FAULT_VALUES    = 0;



  public static final int FAULT_EXTENDED = 2;
  public static final int FAULT_EXTENDED_VENDOR_ID                     = 0;
  public static final int FAULT_EXTENDED_EXTENDED_FAULT_TYPE           = 1;
  public static final int FAULT_EXTENDED_PARAMETERS                    = 2;

  public static final int FAULT_LIFE_SAFETY = 3;
  public static final int FAULT_LIFE_SAFETY_LIST_OF_FAULT_VALUES       = 0;
  public static final int FAULT_LIFE_SAFETY_MODE_PROPERTY_REFERENCE    = 1;

  public static final int FAULT_STATE = 4;
  public static final int FAULT_STATE_LIST_OF_FAULT_VALUES             = 0;

  public static final int FAULT_STATUS_FLAGS = 5;
  public static final int FAULT_STATUS_FLAGS_STATUS_FLAGS_REFERENCE    = 0;

  /**
   * BACnetFaultParameter choice value for fault-out-of-range
   * @since Niagara 4.14
   */
  public static final int FAULT_OUT_OF_RANGE = 6;

  private static final int MAX_FAULT_PARAMETER_CHOICE = FAULT_OUT_OF_RANGE;

  private static final Logger logger = Logger.getLogger("bacnet.datatypes");

}
