/*
 * Copyright 2025 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * @author Eric Anderson on 06 Jun 2025
 * @since Niagara 4.14u2
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("nullValue"),
    @Range("real"),
    @Range("unsigned"),
    @Range("booleanValue"),
    @Range("integer"),
    @Range("doubleValue"),
    @Range("octetString"),
    @Range("characterString"),
    @Range("bitString"),
    @Range("enumerated"),
    @Range("date"),
    @Range("time"),
    @Range("objectIdentifier"),
    @Range("reference")
  }
)
public final class BBacnetExtendedParameterChoice
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetExtendedParameterChoice(581658959)1.0$ @*/
/* Generated Fri Jun 06 13:55:33 CDT 2025 by Slot-o-Matic (c) Tridium, Inc. 2012-2025 */

  /** Ordinal value for nullValue. */
  @Generated
  public static final int NULL_VALUE = 0;
  /** Ordinal value for real. */
  @Generated
  public static final int REAL = 1;
  /** Ordinal value for unsigned. */
  @Generated
  public static final int UNSIGNED = 2;
  /** Ordinal value for booleanValue. */
  @Generated
  public static final int BOOLEAN_VALUE = 3;
  /** Ordinal value for integer. */
  @Generated
  public static final int INTEGER = 4;
  /** Ordinal value for doubleValue. */
  @Generated
  public static final int DOUBLE_VALUE = 5;
  /** Ordinal value for octetString. */
  @Generated
  public static final int OCTET_STRING = 6;
  /** Ordinal value for characterString. */
  @Generated
  public static final int CHARACTER_STRING = 7;
  /** Ordinal value for bitString. */
  @Generated
  public static final int BIT_STRING = 8;
  /** Ordinal value for enumerated. */
  @Generated
  public static final int ENUMERATED = 9;
  /** Ordinal value for date. */
  @Generated
  public static final int DATE = 10;
  /** Ordinal value for time. */
  @Generated
  public static final int TIME = 11;
  /** Ordinal value for objectIdentifier. */
  @Generated
  public static final int OBJECT_IDENTIFIER = 12;
  /** Ordinal value for reference. */
  @Generated
  public static final int REFERENCE = 13;

  /** BBacnetExtendedParameterChoice constant for nullValue. */
  @Generated
  public static final BBacnetExtendedParameterChoice nullValue = new BBacnetExtendedParameterChoice(NULL_VALUE);
  /** BBacnetExtendedParameterChoice constant for real. */
  @Generated
  public static final BBacnetExtendedParameterChoice real = new BBacnetExtendedParameterChoice(REAL);
  /** BBacnetExtendedParameterChoice constant for unsigned. */
  @Generated
  public static final BBacnetExtendedParameterChoice unsigned = new BBacnetExtendedParameterChoice(UNSIGNED);
  /** BBacnetExtendedParameterChoice constant for booleanValue. */
  @Generated
  public static final BBacnetExtendedParameterChoice booleanValue = new BBacnetExtendedParameterChoice(BOOLEAN_VALUE);
  /** BBacnetExtendedParameterChoice constant for integer. */
  @Generated
  public static final BBacnetExtendedParameterChoice integer = new BBacnetExtendedParameterChoice(INTEGER);
  /** BBacnetExtendedParameterChoice constant for doubleValue. */
  @Generated
  public static final BBacnetExtendedParameterChoice doubleValue = new BBacnetExtendedParameterChoice(DOUBLE_VALUE);
  /** BBacnetExtendedParameterChoice constant for octetString. */
  @Generated
  public static final BBacnetExtendedParameterChoice octetString = new BBacnetExtendedParameterChoice(OCTET_STRING);
  /** BBacnetExtendedParameterChoice constant for characterString. */
  @Generated
  public static final BBacnetExtendedParameterChoice characterString = new BBacnetExtendedParameterChoice(CHARACTER_STRING);
  /** BBacnetExtendedParameterChoice constant for bitString. */
  @Generated
  public static final BBacnetExtendedParameterChoice bitString = new BBacnetExtendedParameterChoice(BIT_STRING);
  /** BBacnetExtendedParameterChoice constant for enumerated. */
  @Generated
  public static final BBacnetExtendedParameterChoice enumerated = new BBacnetExtendedParameterChoice(ENUMERATED);
  /** BBacnetExtendedParameterChoice constant for date. */
  @Generated
  public static final BBacnetExtendedParameterChoice date = new BBacnetExtendedParameterChoice(DATE);
  /** BBacnetExtendedParameterChoice constant for time. */
  @Generated
  public static final BBacnetExtendedParameterChoice time = new BBacnetExtendedParameterChoice(TIME);
  /** BBacnetExtendedParameterChoice constant for objectIdentifier. */
  @Generated
  public static final BBacnetExtendedParameterChoice objectIdentifier = new BBacnetExtendedParameterChoice(OBJECT_IDENTIFIER);
  /** BBacnetExtendedParameterChoice constant for reference. */
  @Generated
  public static final BBacnetExtendedParameterChoice reference = new BBacnetExtendedParameterChoice(REFERENCE);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetExtendedParameterChoice make(int ordinal)
  {
    return (BBacnetExtendedParameterChoice)nullValue.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetExtendedParameterChoice make(String tag)
  {
    return (BBacnetExtendedParameterChoice)nullValue.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetExtendedParameterChoice(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetExtendedParameterChoice DEFAULT = nullValue;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetExtendedParameterChoice.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
