/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetLifeSafetyState;
import javax.baja.bacnet.enums.access.BBacnetAccessEvent;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.util.CompUtil;

/**
 * BBacnetEventParameter represents the BACnetEventParameter
 * choice.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 29 Jul 2005
 * @since Niagara 3.1
 */

@NiagaraType
@NiagaraProperty(
  name = "choice",
  type = "int",
  defaultValue = "BBacnetEventType.NONE",
  facets = @Facet(name = "BFacets.FIELD_EDITOR", value = "\"bacnet:BacnetEventTypeFE\"")
)
public final class BBacnetEventParameter
  extends BComponent
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetEventParameter(2917125664)1.0$ @*/
/* Generated Thu Jun 02 14:30:03 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "choice"

  /**
   * Slot for the {@code choice} property.
   * @see #getChoice
   * @see #setChoice
   */
  @Generated
  public static final Property choice = newProperty(0, BBacnetEventType.NONE, BFacets.make(BFacets.FIELD_EDITOR, "bacnet:BacnetEventTypeFE"));

  /**
   * Get the {@code choice} property.
   * @see #choice
   */
  @Generated
  public int getChoice() { return getInt(choice); }

  /**
   * Set the {@code choice} property.
   * @see #choice
   */
  @Generated
  public void setChoice(int v) { setInt(choice, v, null); }

  //endregion Property "choice"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetEventParameter.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
//  Constructors
////////////////////////////////////////////////////////////////

  /**
   * Default constructor.
   */
  public BBacnetEventParameter()
  {
  }

  public static BBacnetEventParameter makeChangeOfState(BRelTime timeDelay, BBacnetListOf listOfValues)
  {
    BBacnetEventParameter eventParams = new BBacnetEventParameter();
    eventParams.setChoice(BBacnetEventType.CHANGE_OF_STATE);
    eventParams.addTimeDelay(timeDelay);

    // Using a BBacnetSequenceOf to better handle listOfValues
    BBacnetSequenceOf sequenceOf = new BBacnetSequenceOf(BBacnetPropertyStates.TYPE);
    for (BBacnetPropertyStates value : listOfValues.getChildren(BBacnetPropertyStates.class))
    {
      sequenceOf.add(value.newCopy());
    }
    eventParams.add(LIST_OF_VALUES_SLOT_NAME, sequenceOf);
    return eventParams;
  }

  /**
   * @since Niagara 4.14u3, 4.15u2
   */
  public static BBacnetEventParameter makeChangeOfState(BRelTime timeDelay, BBacnetSequenceOf listOfValues)
  {
    BBacnetEventParameter eventParams = new BBacnetEventParameter();
    eventParams.setChoice(BBacnetEventType.CHANGE_OF_STATE);
    eventParams.addTimeDelay(timeDelay);
    eventParams.add(LIST_OF_VALUES_SLOT_NAME, listOfValues);
    return eventParams;
  }

  public static BBacnetEventParameter makeCommandFailure(BRelTime timeDelay, BBacnetDeviceObjectPropertyReference feedbackRef)
  {
    BBacnetEventParameter eventParams = new BBacnetEventParameter();
    eventParams.setChoice(BBacnetEventType.COMMAND_FAILURE);
    eventParams.addTimeDelay(timeDelay);
    eventParams.add(FEEDBACK_PROPERTY_REFERENCE_SLOT_NAME, feedbackRef);
    return eventParams;
  }

  public static BBacnetEventParameter makeFloatingLimit(
    BRelTime timeDelay,
    BBacnetDeviceObjectPropertyReference setpointRef,
    float lowDiffLimit,
    float highDiffLimit,
    float deadband)
  {
    BBacnetEventParameter eventParams = new BBacnetEventParameter();
    eventParams.setChoice(BBacnetEventType.FLOATING_LIMIT);
    eventParams.addTimeDelay(timeDelay);
    eventParams.add(SETPOINT_REFERENCE_SLOT_NAME, setpointRef);
    eventParams.add(LOW_DIFF_LIMIT_SLOT_NAME, BFloat.make(lowDiffLimit));
    eventParams.add(HIGH_DIFF_LIMIT_SLOT_NAME, BFloat.make(highDiffLimit));
    eventParams.add(DEADBAND_SLOT_NAME, BFloat.make(deadband));
    return eventParams;
  }

  public static BBacnetEventParameter makeOutOfRange(
    BRelTime timeDelay,
    float lowLimit,
    float highLimit,
    float deadband)
  {
    BBacnetEventParameter eventParams = new BBacnetEventParameter();
    eventParams.setChoice(BBacnetEventType.OUT_OF_RANGE);
    eventParams.addTimeDelay(timeDelay);
    eventParams.add(LOW_LIMIT_SLOT_NAME, BFloat.make(lowLimit));
    eventParams.add(HIGH_LIMIT_SLOT_NAME, BFloat.make(highLimit));
    eventParams.add(DEADBAND_SLOT_NAME, BFloat.make(deadband));
    return eventParams;
  }

  public static BBacnetEventParameter makeOutOfRange(
    BBacnetEventType eventType,
    BRelTime timeDelay,
    double lowLimit,
    double highLimit,
    double deadband)
  {
    BBacnetEventParameter eventParams = new BBacnetEventParameter();
    eventParams.setChoice(eventType.getOrdinal());
    eventParams.addTimeDelay(timeDelay);

    if (eventType.equals(BBacnetEventType.outOfRange))
    {
      eventParams.add(LOW_LIMIT_SLOT_NAME, BFloat.make((float) lowLimit));
      eventParams.add(HIGH_LIMIT_SLOT_NAME, BFloat.make((float) highLimit));
      eventParams.add(DEADBAND_SLOT_NAME, BFloat.make((float) deadband));
    }
    else
    {
      // Handle for SignedOutOfRange, DoubleOutOfRange, UnsignedOutOfRange
      eventParams.add(LOW_LIMIT_SLOT_NAME, BDouble.make(lowLimit));
      eventParams.add(HIGH_LIMIT_SLOT_NAME, BDouble.make(highLimit));
      eventParams.add(DEADBAND_SLOT_NAME, BDouble.make(deadband));
    }

    return eventParams;
  }

  public static BBacnetEventParameter makeBufferReady(long notificationThreshold, long previousNotificationCount)
  {
    BBacnetEventParameter eventParams = new BBacnetEventParameter();
    eventParams.setChoice(BBacnetEventType.BUFFER_READY);
    eventParams.add(NOTIFICATION_THRESHOLD_SLOT_NAME, BBacnetUnsigned.make(notificationThreshold));
    eventParams.add(PREVIOUS_NOTIFICATION_COUNT_SLOT_NAME, BBacnetUnsigned.make(previousNotificationCount));
    return eventParams;
  }

  public static BBacnetEventParameter makeSignedOutOfRange(BRelTime timeDelay, double lowLimit, double highLimit, double deadband)
  {
    BBacnetEventParameter eventParams = new BBacnetEventParameter();
    eventParams.setChoice(BBacnetEventType.SIGNED_OUT_OF_RANGE);
    eventParams.addTimeDelay(timeDelay);
    eventParams.add(LOW_LIMIT_SLOT_NAME, BDouble.make(lowLimit));
    eventParams.add(HIGH_LIMIT_SLOT_NAME, BDouble.make(highLimit));
    eventParams.add(DEADBAND_SLOT_NAME, BDouble.make(deadband));
    return eventParams;
  }

  public static BBacnetEventParameter makeChangeOfCharacterString(BRelTime timeDelay, BBacnetListOf listOfValues)
  {
    BBacnetEventParameter eventParams = new BBacnetEventParameter();
    eventParams.setChoice(BBacnetEventType.CHANGE_OF_CHARACTERSTRING);
    eventParams.addTimeDelay(timeDelay);

    // Using a BBacnetSequenceOf to better handle listOfValues
    BBacnetSequenceOf sequenceOf = new BBacnetSequenceOf(BString.TYPE);
    for (BString value : listOfValues.getChildren(BString.class))
    {
      sequenceOf.add(value.newCopy());
    }
    eventParams.add(LIST_OF_ALARM_VALUES_SLOT_NAME, sequenceOf);
    return eventParams;
  }

  /**
   * @since Niagara 4.14u3, 4.15u2
   */
  public static BBacnetEventParameter makeChangeOfCharacterString(BRelTime timeDelay, BBacnetSequenceOf listOfValues)
  {
    BBacnetEventParameter eventParams = new BBacnetEventParameter();
    eventParams.setChoice(BBacnetEventType.CHANGE_OF_CHARACTERSTRING);
    eventParams.addTimeDelay(timeDelay);
    eventParams.add(LIST_OF_ALARM_VALUES_SLOT_NAME, listOfValues);
    return eventParams;
  }

  /**
   * Create a BACnetEventParameter for the change-of-discrete-value choice.
   *
   * @since Niagara 4.14
   */
  public static BBacnetEventParameter makeChangeOfDiscreteValue(BRelTime timeDelay)
  {
    BBacnetEventParameter eventParams = new BBacnetEventParameter();
    eventParams.setChoice(BBacnetEventType.CHANGE_OF_DISCRETE_VALUE);
    eventParams.addTimeDelay(timeDelay);
    return eventParams;
  }

  private void addTimeDelay(BRelTime timeDelay)
  {
    add(
      BBacnetEventParameter.TIME_DELAY_SLOT_NAME,
      BBacnetUnsigned.make(timeDelay.getSeconds()),
      /* flags */ 0,
      BFacets.makeInt(BUnit.getUnit("second")),
      /* context */ null);
  }

////////////////////////////////////////////////////////////////
//  BComponent
////////////////////////////////////////////////////////////////

  @Override
  public void started()
    throws Exception
  {
    super.started();

    int choice = getChoice();
    if (choice == CHANGE_OF_BITSTRING_TAG)
    {
      BValue listOfValues = get(LIST_OF_BIT_STRING_VALUES_SLOT_NAME);
      if (listOfValues instanceof BBacnetListOf)
      {
        // Convert a BBacnetListOf to a BBacnetSequenceOf so parameters can be reordered, added, and
        // removed.
        BBacnetSequenceOf sequenceOf = new BBacnetSequenceOf(BBacnetBitString.TYPE);
        for (BBacnetBitString element : ((BBacnetListOf)listOfValues).getChildren(BBacnetBitString.class))
        {
          sequenceOf.add("element?", element, noWrite);
        }
        remove(LIST_OF_BIT_STRING_VALUES_SLOT_NAME);
        add(LIST_OF_BIT_STRING_VALUES_SLOT_NAME, sequenceOf);
      }
    }
    else if (choice == CHANGE_OF_STATE_TAG)
    {
      BValue listOfValues = get(LIST_OF_VALUES_SLOT_NAME);
      if (listOfValues instanceof BBacnetListOf)
      {
        // Convert a BBacnetListOf to a BBacnetSequenceOf so parameters can be reordered, added, and
        // removed.
        BBacnetSequenceOf sequenceOf = new BBacnetSequenceOf(BBacnetPropertyStates.TYPE);
        for (BBacnetPropertyStates element : ((BBacnetListOf)listOfValues).getChildren(BBacnetPropertyStates.class))
        {
          sequenceOf.add("element?", element.newCopy(), noWrite);
        }
        remove(LIST_OF_VALUES_SLOT_NAME);
        add(LIST_OF_VALUES_SLOT_NAME, sequenceOf);
      }
    }
    else if (choice == EXTENDED_TAG)
    {
      BValue parameters = get("parameters");
      if (parameters instanceof BBlob)
      {
        // Convert a BBlob to a BBacnetSequenceOf so parameters can be reordered, added, and
        // removed.
        BBacnetSequenceOf newParameters = new BBacnetSequenceOf(BBacnetExtendedParameter.TYPE);
        AsnUtil.fromAsn(ASN_ANY, ((BBlob) parameters).copyBytes(), newParameters);
        remove("parameters");
        add("parameters", newParameters);
      }
    }
    else if (choice == CHANGE_OF_VALUE_TAG)
    {
      BValue oldCovCriteria = get("covCriteria");
      if (oldCovCriteria instanceof BInteger)
      {
        // Convert the BInteger slot and additional slots to a single BBacnetChangeOfValueCriteria
        // slot that has dedicated field editors.
        BBacnetChangeOfValueCriteria newCovCriteria = new BBacnetChangeOfValueCriteria();
        int oldChoice = ((BInteger)oldCovCriteria).getInt();
        if (oldChoice == BBacnetChangeOfValueCriteriaChoice.BITMASK)
        {
          newCovCriteria.setChoice(BBacnetChangeOfValueCriteriaChoice.bitmask);
          BValue bitmask = get(BITMASK_SLOT_NAME);
          newCovCriteria.setValue(
            bitmask instanceof BBacnetBitString ? (BBacnetBitString)bitmask : BBacnetBitString.DEFAULT);
        }
        else if (oldChoice == BBacnetChangeOfValueCriteriaChoice.REFERENCED_PROPERTY_INCREMENT)
        {
          newCovCriteria.setChoice(BBacnetChangeOfValueCriteriaChoice.referencedPropertyIncrement);
          BValue increment = get(REFERENCED_PROPERTY_INCREMENT_SLOT_NAME);
          newCovCriteria.setValue(
            increment instanceof BFloat ? (BFloat)increment : BFloat.DEFAULT);
        }

        // These slots are no longer required.
        CompUtil.removeIfPresent(this, BITMASK_SLOT_NAME);
        CompUtil.removeIfPresent(this, REFERENCED_PROPERTY_INCREMENT_SLOT_NAME);

        set("covCriteria", newCovCriteria);
      }
    }
    else if (choice == CHANGE_OF_CHAR_STR_TAG)
    {
      BValue listOfValues = get(LIST_OF_ALARM_VALUES_SLOT_NAME);
      if (listOfValues instanceof BBacnetListOf)
      {
        // Convert a BBacnetListOf to a BBacnetSequenceOf so parameters can be reordered, added, and
        // removed.
        BBacnetSequenceOf sequenceOf = new BBacnetSequenceOf(BString.TYPE);
        for (BString element : ((BBacnetListOf)listOfValues).getChildren(BString.class))
        {
          sequenceOf.add("element?", element.newCopy(), noWrite);
        }
        remove(LIST_OF_ALARM_VALUES_SLOT_NAME);
        add(LIST_OF_ALARM_VALUES_SLOT_NAME, sequenceOf);
      }
    }
  }

  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;
    BComplex parent = getParent();
    if (parent != null)
      parent.asComponent().changed(getPropertyInParent(), cx);
    // vfixx: throw changed w/ GCC context?
  }

  /**
   * Callback when the component enters the subscribed state.
   */
  public void subscribed()
  {
    BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty(this);
    if (vp != null) vp.childSubscribed(this);
  }

  /**
   * Callback when the component leaves the subscribed state.
   */
  public void unsubscribed()
  {
    BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty(this);
    if (vp != null) vp.childUnsubscribed(this);
  }

  /**
   * Override to route to the virtual parent when we are in a virtual space.
   */
  public BCategoryMask getAppliedCategoryMask()
  {
    if (BacnetVirtualUtil.isVirtual(this))
      return getParent().asComponent().getAppliedCategoryMask();
    return super.getAppliedCategoryMask();
  }

  /**
   * Override to route to the virtual parent when we are in a virtual space.
   */
  public BCategoryMask getCategoryMask()
  {
    if (BacnetVirtualUtil.isVirtual(this)) return getParent().asComponent().getCategoryMask();
    return super.getCategoryMask();
  }

  /**
   * Override to route to the virtual parent when we are in a virtual space.
   */
  public BPermissions getPermissions(Context cx)
  {
    if (BacnetVirtualUtil.isVirtual(this)) return getParent().asComponent().getPermissions(cx);
    return super.getPermissions(cx);
  }


////////////////////////////////////////////////////////////////
//  BIBacnetDataType
////////////////////////////////////////////////////////////////

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  public void writeAsn(AsnOutput out)
  {
    out.writeOpeningTag(getChoice());
    try
    {
      switch (getChoice())
      {
        case CHANGE_OF_BITSTRING_TAG:
          out.writeUnsigned(CHANGE_OF_BITSTRING_TIME_DELAY_TAG, (BBacnetUnsigned) get(TIME_DELAY_SLOT_NAME));
          out.writeBitString(CHANGE_OF_BITSTRING_BITMASK_TAG, (BBacnetBitString)get("bitmask"));

          out.writeOpeningTag(CHANGE_OF_BITSTRING_LIST_OF_BITSTRING_VALUES_TAG);
          ((BBacnetSequenceOf)get(LIST_OF_BIT_STRING_VALUES_SLOT_NAME)).writeAsn(out);
          out.writeClosingTag(CHANGE_OF_BITSTRING_LIST_OF_BITSTRING_VALUES_TAG);
          break;
        case CHANGE_OF_STATE_TAG:
          out.writeUnsigned(CHANGE_OF_STATE_TIME_DELAY_TAG, (BBacnetUnsigned) get(TIME_DELAY_SLOT_NAME));

          out.writeOpeningTag(CHANGE_OF_STATE_LIST_OF_VALUES_TAG);
          ((BBacnetSequenceOf) get(LIST_OF_VALUES_SLOT_NAME)).writeAsn(out);
          out.writeClosingTag(CHANGE_OF_STATE_LIST_OF_VALUES_TAG);
          break;
        case CHANGE_OF_VALUE_TAG:
          out.writeUnsigned(CHANGE_OF_VALUE_TIME_DELAY_TAG, (BBacnetUnsigned) get(TIME_DELAY_SLOT_NAME));
          out.writeOpeningTag(CHANGE_OF_VALUE_COV_CRITERIA_TAG);
          ((BBacnetChangeOfValueCriteria)get("covCriteria")).writeAsn(out);
          out.writeClosingTag(CHANGE_OF_VALUE_COV_CRITERIA_TAG);
          break;
        case COMMAND_FAILURE_TAG:
          out.writeUnsigned(COMMAND_FAILURE_TIME_DELAY_TAG, (BBacnetUnsigned) get(TIME_DELAY_SLOT_NAME));
          out.writeOpeningTag(COMMAND_FAILURE_FEEDBACK_PROPERTY_REFERENCE_TAG);
          ((BBacnetDeviceObjectPropertyReference)get(FEEDBACK_PROPERTY_REFERENCE_SLOT_NAME)).writeAsn(out);
          out.writeClosingTag(COMMAND_FAILURE_FEEDBACK_PROPERTY_REFERENCE_TAG);
          break;
        case FLOATING_LIMIT_TAG:
          out.writeUnsigned(FLOATING_LIMIT_TIME_DELAY_TAG, (BBacnetUnsigned) get(TIME_DELAY_SLOT_NAME));
          out.writeOpeningTag(FLOATING_LIMIT_SETPOINT_REFERENCE_TAG);
          ((BBacnetDeviceObjectPropertyReference)get(SETPOINT_REFERENCE_SLOT_NAME)).writeAsn(out);
          out.writeClosingTag(FLOATING_LIMIT_SETPOINT_REFERENCE_TAG);
          out.writeReal(FLOATING_LIMIT_LOW_DIFF_LIMIT_TAG, (BFloat)get(LOW_DIFF_LIMIT_SLOT_NAME));
          out.writeReal(FLOATING_LIMIT_HIGH_DIFF_LIMIT_TAG, (BFloat)get(HIGH_DIFF_LIMIT_SLOT_NAME));
          out.writeReal(FLOATING_LIMIT_DEADBAND_TAG, (BFloat)get(DEADBAND_SLOT_NAME));
          break;
        case OUT_OF_RANGE_TAG:
          out.writeUnsigned(OUT_OF_RANGE_TIME_DELAY_TAG, (BBacnetUnsigned) get(TIME_DELAY_SLOT_NAME));
          out.writeReal(OUT_OF_RANGE_LOW_LIMIT_TAG, (BFloat)get(LOW_LIMIT_SLOT_NAME));
          out.writeReal(OUT_OF_RANGE_HIGH_LIMIT_TAG, (BFloat)get(HIGH_LIMIT_SLOT_NAME));
          out.writeReal(OUT_OF_RANGE_DEADBAND_TAG, (BFloat)get(DEADBAND_SLOT_NAME));
          break;
        case COMPLEX_EVENT_TYPE_TAG:
          throw new IllegalStateException("Complex Event Type not supported!");
        case BUFFER_READY_DEPRECATED_TAG:
          out.writeUnsigned(BUFFER_READY_DEPRECATED_NOTIFICATION_THRESHOLD_TAG, (BBacnetUnsigned)get(NOTIFICATION_THRESHOLD_SLOT_NAME));
          out.writeUnsigned(BUFFER_READY_DEPRECATED_PREVIOUS_NOTIFICATION_COUNT_TAG, (BBacnetUnsigned)get(PREVIOUS_NOTIFICATION_COUNT_SLOT_NAME));
          break;
        case CHANGE_OF_LIFE_SAFETY_TAG:
          out.writeUnsigned(CHANGE_OF_LIFE_SAFETY_TIME_DELAY_TAG, (BBacnetUnsigned) get(TIME_DELAY_SLOT_NAME));

          out.writeOpeningTag(CHANGE_OF_LIFE_SAFETY_LIST_OF_LIFE_SAFETY_ALARM_VALUES_TAG);
          ((BBacnetListOf)get("listOfLifeSafetyAlarmValues")).writeAsn(out);
          out.writeClosingTag(CHANGE_OF_LIFE_SAFETY_LIST_OF_LIFE_SAFETY_ALARM_VALUES_TAG);

          out.writeOpeningTag(CHANGE_OF_LIFE_SAFETY_LIST_ALARM_VALUES_TAG);
          ((BBacnetListOf)get(LIST_OF_ALARM_VALUES_SLOT_NAME)).writeAsn(out);
          out.writeClosingTag(CHANGE_OF_LIFE_SAFETY_LIST_ALARM_VALUES_TAG);

          out.writeOpeningTag(CHANGE_OF_LIFE_SAFETY_MODE_PROPERTY_REFERENCES_TAG);
          ((BBacnetDeviceObjectPropertyReference)get("modePropertyReference")).writeAsn(out);
          out.writeClosingTag(CHANGE_OF_LIFE_SAFETY_MODE_PROPERTY_REFERENCES_TAG);
          break;
        case EXTENDED_TAG:
          out.writeUnsigned(EXTENDED_VENDOR_ID_TAG, (BBacnetUnsigned)get("vendorId"));
          out.writeUnsigned(EXTENDED_EXTENDED_EVENT_TYPE_TAG, (BBacnetUnsigned)get("extendedEventType"));
          out.writeOpeningTag(EXTENDED_PARAMETERS_TAG);
          ((BBacnetSequenceOf) get("parameters")).writeAsn(out);
          out.writeClosingTag(EXTENDED_PARAMETERS_TAG);
          break;
        case BUFFER_READY_TAG:
          out.writeUnsigned(BUFFER_READY_NOTIFICATION_THRESHOLD_TAG, (BBacnetUnsigned)get(NOTIFICATION_THRESHOLD_SLOT_NAME));
          out.writeUnsigned(BUFFER_READY_PREVIOUS_NOTIFICATION_COUNT_TAG, (BBacnetUnsigned)get(PREVIOUS_NOTIFICATION_COUNT_SLOT_NAME));
          break;
        case UNSIGNED_RANGE_TAG:
          out.writeUnsigned(UNSIGNED_RANGE_TIME_DELAY_TAG, (BBacnetUnsigned) get(TIME_DELAY_SLOT_NAME));
          out.writeUnsigned(UNSIGNED_RANGE_LOW_LIMIT_TAG, (BBacnetUnsigned)get(LOW_LIMIT_SLOT_NAME));
          out.writeUnsigned(UNSIGNED_RANGE_HIGH_LIMIT_TAG, (BBacnetUnsigned)get(HIGH_LIMIT_SLOT_NAME));
          break;
        case ACCESS_EVENT_TAG:
          out.writeOpeningTag(LIST_OF_ACCESS_EVENTS_TAG);
          for (BBacnetAccessEvent accessEvent : getChildren(BBacnetAccessEvent.class))
          {
            out.writeEnumerated(accessEvent);
          }
          out.writeClosingTag(LIST_OF_ACCESS_EVENTS_TAG);

          BBacnetDeviceObjectPropertyReference accessEventTimeReference =
            (BBacnetDeviceObjectPropertyReference)get(ACCESS_EVENT_TIME_REFERENCE_SLOT_NAME);
          out.writeOpeningTag(ACCESS_EVENT_TIME_REFERENCE_TAG);
          accessEventTimeReference.writeAsn(out);
          out.writeClosingTag(ACCESS_EVENT_TIME_REFERENCE_TAG);

          break;
        case DOUBLE_OOR_TAG:
          out.writeUnsigned(OUT_OF_RANGE_TIME_DELAY_TAG, (BBacnetUnsigned) get(TIME_DELAY_SLOT_NAME));
          out.writeDouble(OUT_OF_RANGE_LOW_LIMIT_TAG, (BDouble)get(LOW_LIMIT_SLOT_NAME));
          out.writeDouble(OUT_OF_RANGE_HIGH_LIMIT_TAG, (BDouble)get(HIGH_LIMIT_SLOT_NAME));
          out.writeDouble(OUT_OF_RANGE_DEADBAND_TAG, (BDouble)get(DEADBAND_SLOT_NAME));
          break;
        case SIGNED_OOR_TAG:
          out.writeUnsigned(OUT_OF_RANGE_TIME_DELAY_TAG, (BBacnetUnsigned) get(TIME_DELAY_SLOT_NAME));
          out.writeSignedInteger(OUT_OF_RANGE_LOW_LIMIT_TAG, ((BDouble)get(LOW_LIMIT_SLOT_NAME)).getInt());
          out.writeSignedInteger(OUT_OF_RANGE_HIGH_LIMIT_TAG, ((BDouble)get(HIGH_LIMIT_SLOT_NAME)).getInt());
          out.writeUnsignedInteger(OUT_OF_RANGE_DEADBAND_TAG, ((BDouble)get(DEADBAND_SLOT_NAME)).getInt());
          break;
        case UNSIGNED_OOR_TAG:
          out.writeUnsigned(OUT_OF_RANGE_TIME_DELAY_TAG, (BBacnetUnsigned) get(TIME_DELAY_SLOT_NAME));
          out.writeUnsignedInteger(OUT_OF_RANGE_LOW_LIMIT_TAG, ((BDouble)get(LOW_LIMIT_SLOT_NAME)).getLong());
          out.writeUnsignedInteger(OUT_OF_RANGE_HIGH_LIMIT_TAG, ((BDouble)get(HIGH_LIMIT_SLOT_NAME)).getLong());
          out.writeUnsignedInteger(OUT_OF_RANGE_DEADBAND_TAG, ((BDouble)get(DEADBAND_SLOT_NAME)).getLong());
          break;
        case CHANGE_OF_CHAR_STR_TAG:
          out.writeUnsigned(CHANGE_OF_CHAR_STR_TIME_DELAY_TAG, (BBacnetUnsigned) get(TIME_DELAY_SLOT_NAME));
          out.writeOpeningTag(CHANGE_OF_CHAR_STR_ALARM_VALUES_TAG);
          ((BBacnetSequenceOf)get(LIST_OF_ALARM_VALUES_SLOT_NAME)).writeAsn(out);
          out.writeClosingTag(CHANGE_OF_CHAR_STR_ALARM_VALUES_TAG);
          break;
        case CHANGE_OF_STATUS_FLAGS_TAG:
          out.writeUnsigned(COSF_TIME_DELAY_TAG, (BBacnetUnsigned) get(TIME_DELAY_SLOT_NAME));
          BBacnetBitString statusFlags = (BBacnetBitString)get(STATUS_FLAGS_SLOT_NAME);
          if (statusFlags != null)
          {
            out.writeBitString(COSF_SELECTED_FLAGS_TAG, statusFlags);
          }
          else
          {
            out.writeBitString(COSF_SELECTED_FLAGS_TAG,
              BacnetBitStringUtil.DEFAULT_STATUS);
          }
          break;
        case CHANGE_OF_RELIABILITY_FLAGS_TAG:
          throw new IllegalStateException("Change Of Reliability not supported!");
        case BBacnetEventType.NONE:
          out.writeNull();
          break;
        case BBacnetEventType.CHANGE_OF_DISCRETE_VALUE:
          out.writeUnsigned(CHANGE_OF_DISCRETE_VALUE_TIME_DELAY_TAG, (BBacnetUnsigned) get(TIME_DELAY_SLOT_NAME));
          break;
      }
    }
    catch (Exception e)
    {
      logger.log(Level.SEVERE, "Exception occurred in writeAsn", e);
    }
    out.writeClosingTag(getChoice());
  }

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    int tag = in.peekTag();
    if (tag < 0 || tag > MAX_TAG)
    {
      throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
    }

    in.skipOpeningTag(tag);
    switch (tag)
    {
      case CHANGE_OF_BITSTRING_TAG:
      {
        long timeDelayValue = in.readUnsignedInteger(CHANGE_OF_BITSTRING_TIME_DELAY_TAG);
        BBacnetBitString bitmask = in.readBitString(CHANGE_OF_BITSTRING_BITMASK_TAG);
        in.skipOpeningTag(CHANGE_OF_BITSTRING_LIST_OF_BITSTRING_VALUES_TAG);
        List<BValue> listOfBitStringValues = BBacnetSequenceOf.readAsn(in, CHANGE_OF_BITSTRING_LIST_OF_BITSTRING_VALUES_TAG, BBacnetBitString.TYPE);
        in.skipClosingTag(CHANGE_OF_BITSTRING_LIST_OF_BITSTRING_VALUES_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd(TIME_DELAY_SLOT_NAME, BBacnetUnsigned.make(timeDelayValue), (BFacets) SECONDS_FACETS.newCopy());
        setOrAdd(BITMASK_SLOT_NAME, bitmask);
        updateOrAddSequenceOf(LIST_OF_BIT_STRING_VALUES_SLOT_NAME, BBacnetBitString.TYPE, listOfBitStringValues);
        break;
      }
      case CHANGE_OF_STATE_TAG:
      {
        long timeDelayValue = in.readUnsignedInteger(CHANGE_OF_STATE_TIME_DELAY_TAG);
        in.skipOpeningTag(CHANGE_OF_STATE_LIST_OF_VALUES_TAG);
        List<BValue> listOfValues = BBacnetSequenceOf.readAsn(in, CHANGE_OF_STATE_LIST_OF_VALUES_TAG, BBacnetPropertyStates.TYPE);
        in.skipClosingTag(CHANGE_OF_STATE_LIST_OF_VALUES_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd(TIME_DELAY_SLOT_NAME, BBacnetUnsigned.make(timeDelayValue), (BFacets) SECONDS_FACETS.newCopy());
        updateOrAddSequenceOf(LIST_OF_VALUES_SLOT_NAME, BBacnetPropertyStates.TYPE, listOfValues);
        break;
      }
      case CHANGE_OF_VALUE_TAG:
      {
        long timeDelayValue = in.readUnsignedInteger(CHANGE_OF_VALUE_TIME_DELAY_TAG);
        in.skipOpeningTag(CHANGE_OF_VALUE_COV_CRITERIA_TAG);
        BBacnetChangeOfValueCriteria covCriteria = new BBacnetChangeOfValueCriteria();
        covCriteria.readAsn(in);
        in.skipClosingTag(CHANGE_OF_VALUE_COV_CRITERIA_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd(TIME_DELAY_SLOT_NAME, BBacnetUnsigned.make(timeDelayValue), (BFacets) SECONDS_FACETS.newCopy());
        setOrAdd("covCriteria", covCriteria);
        break;
      }
      case COMMAND_FAILURE_TAG:
      {
        long timeDelayValue = in.readUnsignedInteger(COMMAND_FAILURE_TIME_DELAY_TAG);
        in.skipOpeningTag(COMMAND_FAILURE_FEEDBACK_PROPERTY_REFERENCE_TAG);
        BBacnetDeviceObjectPropertyReference feedbackPropRef = new BBacnetDeviceObjectPropertyReference();
        feedbackPropRef.readAsn(in);
        in.skipClosingTag(COMMAND_FAILURE_FEEDBACK_PROPERTY_REFERENCE_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd(TIME_DELAY_SLOT_NAME, BBacnetUnsigned.make(timeDelayValue), (BFacets) SECONDS_FACETS.newCopy());
        setOrAdd(FEEDBACK_PROPERTY_REFERENCE_SLOT_NAME, feedbackPropRef);
        break;
      }
      case FLOATING_LIMIT_TAG:
      {
        long timeDelayValue = in.readUnsignedInteger(FLOATING_LIMIT_TIME_DELAY_TAG);
        in.skipOpeningTag(FLOATING_LIMIT_SETPOINT_REFERENCE_TAG);
        BBacnetDeviceObjectPropertyReference setpointRef = new BBacnetDeviceObjectPropertyReference();
        setpointRef.readAsn(in);
        in.skipClosingTag(FLOATING_LIMIT_SETPOINT_REFERENCE_TAG);
        BFloat lowDiffLimit = in.readFloat(FLOATING_LIMIT_LOW_DIFF_LIMIT_TAG);
        BFloat highDiffLimit = in.readFloat(FLOATING_LIMIT_HIGH_DIFF_LIMIT_TAG);
        BFloat deadband = in.readFloat(FLOATING_LIMIT_DEADBAND_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd(TIME_DELAY_SLOT_NAME, BBacnetUnsigned.make(timeDelayValue), (BFacets) SECONDS_FACETS.newCopy());
        setOrAdd(SETPOINT_REFERENCE_SLOT_NAME, setpointRef);
        setOrAdd(LOW_DIFF_LIMIT_SLOT_NAME, lowDiffLimit);
        setOrAdd(HIGH_DIFF_LIMIT_SLOT_NAME, highDiffLimit);
        setOrAdd(DEADBAND_SLOT_NAME, deadband);
        break;
      }
      case OUT_OF_RANGE_TAG:
      {
        long timeDelayValue = in.readUnsignedInteger(OUT_OF_RANGE_TIME_DELAY_TAG);
        BFloat lowLimit = in.readFloat(OUT_OF_RANGE_LOW_LIMIT_TAG);
        BFloat highLimit = in.readFloat(OUT_OF_RANGE_HIGH_LIMIT_TAG);
        BFloat deadband = in.readFloat(OUT_OF_RANGE_DEADBAND_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd(TIME_DELAY_SLOT_NAME, BBacnetUnsigned.make(timeDelayValue), (BFacets) SECONDS_FACETS.newCopy());
        setOrAdd(LOW_LIMIT_SLOT_NAME, lowLimit);
        setOrAdd(HIGH_LIMIT_SLOT_NAME, highLimit);
        setOrAdd(DEADBAND_SLOT_NAME, deadband);
        break;
      }
      case COMPLEX_EVENT_TYPE_TAG:
      {
        BValue[] alarmParameters = AsnUtil.fromAsn(in, COMPLEX_EVENT_TYPE_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        for (BValue alarmParameter : alarmParameters)
        {
          setOrAdd(null, alarmParameter);
        }
        break;
      }
      case BUFFER_READY_DEPRECATED_TAG:
      {
        long notificationThreshold = in.readUnsignedInteger(BUFFER_READY_DEPRECATED_NOTIFICATION_THRESHOLD_TAG);
        long previousNotificationCount = in.readUnsignedInteger(BUFFER_READY_DEPRECATED_PREVIOUS_NOTIFICATION_COUNT_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd(NOTIFICATION_THRESHOLD_SLOT_NAME, BBacnetUnsigned.make(notificationThreshold));
        setOrAdd(PREVIOUS_NOTIFICATION_COUNT_SLOT_NAME, BBacnetUnsigned.make(previousNotificationCount));
        break;
      }
      case CHANGE_OF_LIFE_SAFETY_TAG:
      {
        long timeDelayValue = in.readUnsignedInteger(CHANGE_OF_LIFE_SAFETY_TIME_DELAY_TAG);
        BBacnetListOf lifeSafetyAlarmValues = new BBacnetListOf(BBacnetLifeSafetyState.TYPE);
        lifeSafetyAlarmValues.readAsn(AsnInputStream.make(in.readEncodedValue(CHANGE_OF_LIFE_SAFETY_LIST_OF_LIFE_SAFETY_ALARM_VALUES_TAG)));
        BBacnetListOf alarmValues = new BBacnetListOf(BBacnetLifeSafetyState.TYPE);
        alarmValues.readAsn(AsnInputStream.make(in.readEncodedValue(CHANGE_OF_LIFE_SAFETY_LIST_ALARM_VALUES_TAG)));
        in.skipOpeningTag(CHANGE_OF_LIFE_SAFETY_MODE_PROPERTY_REFERENCES_TAG);
        BBacnetDeviceObjectPropertyReference modePropRef = new BBacnetDeviceObjectPropertyReference();
        modePropRef.readAsn(in);
        in.skipClosingTag(CHANGE_OF_LIFE_SAFETY_MODE_PROPERTY_REFERENCES_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd(TIME_DELAY_SLOT_NAME, BBacnetUnsigned.make(timeDelayValue), (BFacets) SECONDS_FACETS.newCopy());
        setOrAdd("listOfLifeSafetyAlarmValues", lifeSafetyAlarmValues);
        setOrAdd(LIST_OF_ALARM_VALUES_SLOT_NAME, alarmValues);
        setOrAdd("modePropertyReference", modePropRef);
        break;
      }
      case EXTENDED_TAG:
      {
        long vendorId = in.readUnsignedInteger(EXTENDED_VENDOR_ID_TAG);
        long eventType = in.readUnsignedInteger(EXTENDED_EXTENDED_EVENT_TYPE_TAG);
        in.skipOpeningTag(EXTENDED_PARAMETERS_TAG);
        List<BValue> parameters = BBacnetSequenceOf.readAsn(in, EXTENDED_PARAMETERS_TAG, BBacnetExtendedParameter.TYPE);
        in.skipClosingTag(EXTENDED_PARAMETERS_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd("vendorId", BBacnetUnsigned.make(vendorId));
        setOrAdd("extendedEventType", BBacnetUnsigned.make(eventType));
        updateOrAddSequenceOf("parameters", BBacnetExtendedParameter.TYPE, parameters);
        break;
      }
      case BUFFER_READY_TAG:
      {
        long notificationThreshold = in.readUnsignedInteger(BUFFER_READY_NOTIFICATION_THRESHOLD_TAG);
        long previousNotificationCount = in.readUnsignedInteger(BUFFER_READY_PREVIOUS_NOTIFICATION_COUNT_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd(NOTIFICATION_THRESHOLD_SLOT_NAME, BBacnetUnsigned.make(notificationThreshold));
        setOrAdd(PREVIOUS_NOTIFICATION_COUNT_SLOT_NAME, BBacnetUnsigned.make(previousNotificationCount));
        break;
      }
      case UNSIGNED_RANGE_TAG:
      {
        long timeDelayValue = in.readUnsignedInteger(UNSIGNED_RANGE_TIME_DELAY_TAG);
        long lowLimit = in.readUnsignedInteger(UNSIGNED_RANGE_LOW_LIMIT_TAG);
        long highLimit = in.readUnsignedInteger(UNSIGNED_RANGE_HIGH_LIMIT_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd(TIME_DELAY_SLOT_NAME, BBacnetUnsigned.make(timeDelayValue), (BFacets) SECONDS_FACETS.newCopy());
        setOrAdd(LOW_LIMIT_SLOT_NAME, BBacnetUnsigned.make(lowLimit));
        setOrAdd(HIGH_LIMIT_SLOT_NAME, BBacnetUnsigned.make(highLimit));
        break;
      }
      case ACCESS_EVENT_TAG:
      {
        List<BBacnetAccessEvent> accessEvents = new ArrayList<>();
        in.skipOpeningTag(LIST_OF_ACCESS_EVENTS_TAG);
        in.peekTag();
        while (!in.isClosingTag(LIST_OF_ACCESS_EVENTS_TAG))
        {
          accessEvents.add(BBacnetAccessEvent.make(in.readEnumerated()));
          in.peekTag();
        }
        in.skipClosingTag(LIST_OF_ACCESS_EVENTS_TAG);
        in.skipOpeningTag(ACCESS_EVENT_TIME_REFERENCE_TAG);
        BBacnetDeviceObjectPropertyReference accessEventTimeReference = new BBacnetDeviceObjectPropertyReference();
        accessEventTimeReference.readAsn(in);
        in.skipClosingTag(ACCESS_EVENT_TIME_REFERENCE_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        for (int i = 0; i < accessEvents.size(); i++)
        {
          setOrAdd(ACCESS_EVENT_PREFIX + i, accessEvents.get(i));
        }
        setOrAdd(ACCESS_EVENT_TIME_REFERENCE_SLOT_NAME, accessEventTimeReference);
        break;
      }
      case DOUBLE_OOR_TAG:
      {
        long timeDelayValue = in.readUnsignedInteger(OUT_OF_RANGE_TIME_DELAY_TAG);
        double lowLimit = in.readDouble(OUT_OF_RANGE_LOW_LIMIT_TAG);
        double highLimit = in.readDouble(OUT_OF_RANGE_HIGH_LIMIT_TAG);
        double deadband = in.readDouble(OUT_OF_RANGE_DEADBAND_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd(TIME_DELAY_SLOT_NAME, BBacnetUnsigned.make(timeDelayValue), (BFacets) SECONDS_FACETS.newCopy());
        setOrAdd(LOW_LIMIT_SLOT_NAME, BDouble.make(lowLimit));
        setOrAdd(HIGH_LIMIT_SLOT_NAME, BDouble.make(highLimit));
        setOrAdd(DEADBAND_SLOT_NAME, BDouble.make(deadband));
        break;
      }
      case SIGNED_OOR_TAG:
      {
        long timeDelayValue = in.readUnsignedInteger(OUT_OF_RANGE_TIME_DELAY_TAG);
        int lowLimit = in.readSignedInteger(OUT_OF_RANGE_LOW_LIMIT_TAG);
        int highLimit = in.readSignedInteger(OUT_OF_RANGE_HIGH_LIMIT_TAG);
        long deadband = in.readUnsignedInteger(OUT_OF_RANGE_DEADBAND_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd(TIME_DELAY_SLOT_NAME, BBacnetUnsigned.make(timeDelayValue), (BFacets) SECONDS_FACETS.newCopy());
        setOrAdd(LOW_LIMIT_SLOT_NAME, BDouble.make(lowLimit));
        setOrAdd(HIGH_LIMIT_SLOT_NAME, BDouble.make(highLimit));
        setOrAdd(DEADBAND_SLOT_NAME, BDouble.make(deadband));
        break;
      }
      case UNSIGNED_OOR_TAG:
      {
        long timeDelayValue = in.readUnsignedInteger(OUT_OF_RANGE_TIME_DELAY_TAG);
        long lowLimit = in.readUnsignedInteger(OUT_OF_RANGE_LOW_LIMIT_TAG);
        long highLimit = in.readUnsignedInteger(OUT_OF_RANGE_HIGH_LIMIT_TAG);
        long deadband = in.readUnsignedInteger(OUT_OF_RANGE_DEADBAND_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd(TIME_DELAY_SLOT_NAME, BBacnetUnsigned.make(timeDelayValue), (BFacets) SECONDS_FACETS.newCopy());
        setOrAdd(LOW_LIMIT_SLOT_NAME, BDouble.make(lowLimit));
        setOrAdd(HIGH_LIMIT_SLOT_NAME, BDouble.make(highLimit));
        setOrAdd(DEADBAND_SLOT_NAME, BDouble.make(deadband));
        break;
      }
      /*
       * change-of-characterstring [17] SEQUENCE {
       *            time-delay           [0] Unsigned,
       *            list-of-alarm-values [1] SEQUENCE OF CharacterString
       * }
       */
      case CHANGE_OF_CHAR_STR_TAG:
      {
        long timeDelayValue = in.readUnsignedInteger(CHANGE_OF_CHAR_STR_TIME_DELAY_TAG);
        in.skipOpeningTag(CHANGE_OF_CHAR_STR_ALARM_VALUES_TAG);
        List<BValue> charStrValues = BBacnetSequenceOf.readAsn(in, CHANGE_OF_STATE_LIST_OF_VALUES_TAG, BString.TYPE);
        in.skipClosingTag(CHANGE_OF_CHAR_STR_ALARM_VALUES_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd(TIME_DELAY_SLOT_NAME, BBacnetUnsigned.make(timeDelayValue), (BFacets) SECONDS_FACETS.newCopy());
        updateOrAddSequenceOf(LIST_OF_ALARM_VALUES_SLOT_NAME, BString.TYPE, charStrValues);
        break;
      }
      case CHANGE_OF_STATUS_FLAGS_TAG:
      {
        long timeDelayValue = in.readUnsignedInteger(COSF_TIME_DELAY_TAG);
        BBacnetBitString cosfSelectedFalgs = in.readBitString(COSF_SELECTED_FLAGS_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd(TIME_DELAY_SLOT_NAME, BBacnetUnsigned.make(timeDelayValue), (BFacets) SECONDS_FACETS.newCopy());
        setOrAdd(STATUS_FLAGS_SLOT_NAME, cosfSelectedFalgs);
        break;
      }
      case CHANGE_OF_RELIABILITY_FLAGS_TAG:
        throw new IllegalStateException("Change Of Reliability not supported!");
      case BBacnetEventType.NONE:
        in.readNull();
        in.skipClosingTag(tag);
        updateChoice(tag);
        break;
      case BBacnetEventType.CHANGE_OF_DISCRETE_VALUE:
      {
        long timeDelayValue = in.readUnsignedInteger(CHANGE_OF_DISCRETE_VALUE_TIME_DELAY_TAG);
        in.skipClosingTag(tag);

        updateChoice(tag);
        setOrAdd(TIME_DELAY_SLOT_NAME, BBacnetUnsigned.make(timeDelayValue), (BFacets) SECONDS_FACETS.newCopy());
        break;
      }
    }
  }

  private void updateOrAddSequenceOf(String slotName, Type sequenceType, List<BValue> values)
  {
    // BacUtil.setOrAdd calls copyFrom on BComplexes, which only affects the frozen slots. The
    // dynamic slots were not changed potentially leaving outdated values. Reuse the update method
    // so minimal changes are made to the slots.
    BBacnetSequenceOf listOfValues = (BBacnetSequenceOf) get(slotName);
    if (listOfValues == null)
    {
      listOfValues = new BBacnetSequenceOf(sequenceType);
      listOfValues.updateElements(values, sequenceType, noWrite);
      add(slotName, listOfValues);
    }
    else
    {
      listOfValues.updateElements(values, sequenceType, noWrite);
    }
  }

////////////////////////////////////////////////////////////////
// Support
////////////////////////////////////////////////////////////////

  private void updateChoice(int tag)
  {
    // If choice changed, remove anything that used to be here.
    if (tag != getChoice())
    {
      removeAll(noWrite);
    }

    setInt(choice, tag, noWrite);
  }

  private void setOrAdd(String name, BValue value)
  {
    setOrAdd(name, value, null);
  }

  private void setOrAdd(String name, BValue value, BFacets facets)
  {
    BacUtil.setOrAdd(this, name, value, 0, facets, noWrite);
  }

////////////////////////////////////////////////////////////////
// Spy
////////////////////////////////////////////////////////////////

  public void spy(SpyWriter out) throws Exception
  {
    super.spy(out);
    out.startProps();
    out.trTitle("BacnetEventParameter", 2);
    out.prop("virtual", BacnetVirtualUtil.isVirtual(this));
    out.endProps();
  }


/////////////////////////////////////////////////////////////////
//  Constants
/////////////////////////////////////////////////////////////////

  private static final Logger logger = Logger.getLogger("bacnet.datatypes");

  private static final int MAX_TAG = 21;

  private static final BFacets SECONDS_FACETS = BFacets.makeInt(BUnit.getUnit("second"));

  public static final String TIME_DELAY_SLOT_NAME = "timeDelay";
  public static final String LIST_OF_VALUES_SLOT_NAME = "listOfValues";
  public static final String LIST_OF_BIT_STRING_VALUES_SLOT_NAME = "listOfBitstringValues";
  public static final String BITMASK_SLOT_NAME = "bitmask";
  public static final String REFERENCED_PROPERTY_INCREMENT_SLOT_NAME = "referencedPropertyIncrement";
  public static final String LIST_OF_ALARM_VALUES_SLOT_NAME = "listOfAlarmValues";
  public static final String FEEDBACK_PROPERTY_REFERENCE_SLOT_NAME = "feedbackPropertyReference";
  public static final String SETPOINT_REFERENCE_SLOT_NAME = "setpointReference";
  public static final String LOW_DIFF_LIMIT_SLOT_NAME = "lowDiffLimit";
  public static final String HIGH_DIFF_LIMIT_SLOT_NAME = "highDiffLimit";
  public static final String LOW_LIMIT_SLOT_NAME = "lowLimit";
  public static final String HIGH_LIMIT_SLOT_NAME = "highLimit";
  public static final String DEADBAND_SLOT_NAME = "deadband";
  public static final String NOTIFICATION_THRESHOLD_SLOT_NAME = "notificationThreshold";
  public static final String PREVIOUS_NOTIFICATION_COUNT_SLOT_NAME = "previousNotificationCount";
  public static final String STATUS_FLAGS_SLOT_NAME = "statusFlags";
  /** @since Niagara 4.14 */
  public static final String ACCESS_EVENT_TIME_REFERENCE_SLOT_NAME = "accessEventTimeReference";

  /**
   * change-of-bitstring
   */
  public static final int CHANGE_OF_BITSTRING_TAG = 0;
  public static final int CHANGE_OF_BITSTRING_TIME_DELAY_TAG = 0;
  public static final int CHANGE_OF_BITSTRING_BITMASK_TAG = 1;
  public static final int CHANGE_OF_BITSTRING_LIST_OF_BITSTRING_VALUES_TAG = 2;

  /**
   * change-of-state
   */
  public static final int CHANGE_OF_STATE_TAG = 1;
  public static final int CHANGE_OF_STATE_TIME_DELAY_TAG = 0;
  public static final int CHANGE_OF_STATE_LIST_OF_VALUES_TAG = 1;

  /**
   * change-of-value
   */
  public static final int CHANGE_OF_VALUE_TAG = 2;
  public static final int CHANGE_OF_VALUE_TIME_DELAY_TAG = 0;
  public static final int CHANGE_OF_VALUE_COV_CRITERIA_TAG = 1;
  public static final int CHANGE_OF_VALUE_BITMASK_TAG = 0;
  public static final int CHANGE_OF_VALUE_REFERENCED_PROPERTY_INCREMENT_TAG = 1;

  /**
   * command-failure
   */
  public static final int COMMAND_FAILURE_TAG = 3;
  public static final int COMMAND_FAILURE_TIME_DELAY_TAG = 0;
  public static final int COMMAND_FAILURE_FEEDBACK_PROPERTY_REFERENCE_TAG = 1;

  /**
   * floating-limit
   */
  public static final int FLOATING_LIMIT_TAG = 4;
  public static final int FLOATING_LIMIT_TIME_DELAY_TAG = 0;
  public static final int FLOATING_LIMIT_SETPOINT_REFERENCE_TAG = 1;
  public static final int FLOATING_LIMIT_LOW_DIFF_LIMIT_TAG = 2;
  public static final int FLOATING_LIMIT_HIGH_DIFF_LIMIT_TAG = 3;
  public static final int FLOATING_LIMIT_DEADBAND_TAG = 4;

  /**
   * out-of-range
   */
  public static final int OUT_OF_RANGE_TAG = 5;
  public static final int OUT_OF_RANGE_TIME_DELAY_TAG = 0;
  public static final int OUT_OF_RANGE_LOW_LIMIT_TAG = 1;
  public static final int OUT_OF_RANGE_HIGH_LIMIT_TAG = 2;
  public static final int OUT_OF_RANGE_DEADBAND_TAG = 3;

  /**
   * complex-event-type
   */
  public static final int COMPLEX_EVENT_TYPE_TAG = 6;

  /**
   * buffer-ready (deprecated)
   */
  public static final int BUFFER_READY_DEPRECATED_TAG = 7;
  public static final int BUFFER_READY_DEPRECATED_NOTIFICATION_THRESHOLD_TAG = 0;
  public static final int BUFFER_READY_DEPRECATED_PREVIOUS_NOTIFICATION_COUNT_TAG = 1;

  /**
   * change-of-life-safety
   */
  public static final int CHANGE_OF_LIFE_SAFETY_TAG = 8;
  public static final int CHANGE_OF_LIFE_SAFETY_TIME_DELAY_TAG = 0;
  public static final int CHANGE_OF_LIFE_SAFETY_LIST_OF_LIFE_SAFETY_ALARM_VALUES_TAG = 1;
  public static final int CHANGE_OF_LIFE_SAFETY_LIST_ALARM_VALUES_TAG = 2;
  public static final int CHANGE_OF_LIFE_SAFETY_MODE_PROPERTY_REFERENCES_TAG = 3;

  /**
   * extended
   */
  public static final int EXTENDED_TAG = 9;
  public static final int EXTENDED_VENDOR_ID_TAG = 0;
  public static final int EXTENDED_EXTENDED_EVENT_TYPE_TAG = 1;
  public static final int EXTENDED_PARAMETERS_TAG = 2;
  public static final int EXTENDED_REFERENCE_TAG = 0;

  /**
   * buffer-ready
   */
  public static final int BUFFER_READY_TAG = 10;
  public static final int BUFFER_READY_NOTIFICATION_THRESHOLD_TAG = 0;
  public static final int BUFFER_READY_PREVIOUS_NOTIFICATION_COUNT_TAG = 1;

  /**
   * unsigned-range
   */
  public static final int UNSIGNED_RANGE_TAG = 11;
  public static final int UNSIGNED_RANGE_TIME_DELAY_TAG = 0;
  public static final int UNSIGNED_RANGE_LOW_LIMIT_TAG = 1;
  public static final int UNSIGNED_RANGE_HIGH_LIMIT_TAG = 2;

  /**
   * -- enumeration value 12 is reserved for future addenda
   */

  public static final String ACCESS_EVENT_PREFIX = "accessEvent";
  public static final int ACCESS_EVENT_TAG = 13;
  public static final int LIST_OF_ACCESS_EVENTS_TAG = 0;
  public static final int ACCESS_EVENT_TIME_REFERENCE_TAG = 1;

  public static final int DOUBLE_OOR_TAG = 14;
  public static final int SIGNED_OOR_TAG = 15;
  public static final int UNSIGNED_OOR_TAG = 16;

  public static final String CHANGE_OF_CHAR_STR_PREFIX = "chrstr";
  public static final int CHANGE_OF_CHAR_STR_TAG = 17;
  public static final int CHANGE_OF_CHAR_STR_TIME_DELAY_TAG = 0;
  public static final int CHANGE_OF_CHAR_STR_ALARM_VALUES_TAG = 1;
  public static final int MAX_ALARM_VALUES = 50;

  public static final int CHANGE_OF_STATUS_FLAGS_TAG = 18;
  public static final int CHANGE_OF_RELIABILITY_FLAGS_TAG = 19;
  public static final int COSF_TIME_DELAY_TAG = 0;
  public static final int COSF_SELECTED_FLAGS_TAG = 1;

  public static final int EP_EVENT_TYPE_NONE = 20;

  /** @since Niagara 4.14 */
  public static final int CHANGE_OF_DISCRETE_VALUE_TAG = 21;
  /** @since Niagara 4.14 */
  public static final int CHANGE_OF_DISCRETE_VALUE_TIME_DELAY_TAG = 0;
}
