/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

import com.tridium.bacnet.asn.AsnConst;

/**
 * BBacnetChannelValue represents the BACnetChannelValue
 * choice.
 *
 * @author Joseph Chandler
 * @creation 15 Apr 15
 * @since Niagara 4
 */

/*
 * BACnetChannelValue ::= CHOICE {
           null NULL,
           real REAL,
           enumerated ENUMERATED,
           unsigned Unsigned,
           boolean BOOLEAN,
           signed INTEGER,
           double Double,
           time Time,
           characterString CharacterString,
           octetString OCTET STRING,
           bitString BIT STRING,
           date Date,
           objectid BACnetObjectIdentifier,
           lightingCommand [0] BACnetLightingCommand
    } 
 */

@NiagaraType
@NiagaraProperty(
  name = "choice",
  type = "int",
  defaultValue = "0",
  flags = Flags.HIDDEN
)
public class BBacnetChannelValue
  extends BComponent
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetChannelValue(246626917)1.0$ @*/
/* Generated Thu Jun 02 14:30:03 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "choice"

  /**
   * Slot for the {@code choice} property.
   * @see #getChoice
   * @see #setChoice
   */
  @Generated
  public static final Property choice = newProperty(Flags.HIDDEN, 0, null);

  /**
   * Get the {@code choice} property.
   * @see #choice
   */
  @Generated
  public int getChoice() { return getInt(choice); }

  /**
   * Set the {@code choice} property.
   * @see #choice
   */
  @Generated
  public void setChoice(int v) { setInt(choice, v, null); }

  //endregion Property "choice"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetChannelValue.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public void changed(Property property, Context context)
  {
    super.changed(property, context);

    // Notify the parent of a property change so, if the parent is a config object for a remote
    // object, the change will be written.
    BComplex parent = getParent();
    Property propertyInParent = getPropertyInParent();
    if (parent instanceof BComponent && propertyInParent != null)
    {
      ((BComponent) parent).changed(propertyInParent, context);
    }
  }

  public String toString(Context cx)
  {
    String slotName = getSlotName(getChoice());
    return slotName != null ?
      lex.getText("BacnetChannelValue." + slotName) + ": " + get(slotName) :
      lex.getText("BacnetChannelValue.invalid");
  }

////////////////////////////////////////////////////////////////
//  BIBacnetDataType
////////////////////////////////////////////////////////////////

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  public void writeAsn(AsnOutput out)
  {
    int choice = getChoice();
    switch (choice)
    {
      case NULL_TAG:
        out.writeNull();
        break;
      case REAL_TAG:
        out.writeReal((BNumber)get(REAl_SLOT_NAME));
        break;
      case ENUMERATED_TAG:
        out.writeEnumerated(((BInteger)get(ENUMERATED_SLOT_NAME)).getInt());
        break;
      case UNSIGNED_TAG:
        out.writeUnsigned((BBacnetUnsigned)get(UNSIGNED_SLOT_NAME));
        break;
      case BOOLEAN_TAG:
        out.writeBoolean((BBoolean)get(BOOLEAN_SLOT_NAME));
        break;
      case SIGNED_TAG:
        out.writeSignedInteger((BInteger)get(SIGNED_SLOT_NAME));
        break;
      case DOUBLE_TAG:
        out.writeDouble((BDouble)get(DOUBLE_SLOT_NAME));
        break;
      case TIME_TAG:
        out.writeTime((BBacnetTime)get(TIME_SLOT_NAME));
        break;
      case CHARACTERSTRING_TAG:
        out.writeCharacterString((BString)get(CHARACTER_STRING_SLOT_NAME));
        break;
      case OCTETSTRING_TAG:
        out.writeOctetString((BBacnetOctetString)get(OCTET_STRING_SLOT_NAME));
        break;
      case BITSTRING_TAG:
        out.writeBitString((BBacnetBitString)get(BIT_STRING_SLOT_NAME));
        break;
      case DATE_TAG:
        out.writeDate((BBacnetDate)get(DATE_SLOT_NAME));
        break;
      case OBJECTID_TAG:
        out.writeObjectIdentifier((BBacnetObjectIdentifier)get(OBJECT_ID_SLOT_NAME));
        break;
      case LIGHTCOMMAND_TAG:
        BBacnetLightingCommand lightingCommand = (BBacnetLightingCommand)get(LIGHTING_COMMAND_SLOT_NAME);
        out.writeOpeningTag(LIGHTCOMMAND_SUB_TAG);
        lightingCommand.writeAsn(out);
        out.writeClosingTag(LIGHTCOMMAND_SUB_TAG);
        break;
      default:
        // No support for constructed value choice
        throw new IllegalStateException("Invalid BACnetChannelValue choice: " + choice);
    }
  }

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  public void readAsn(AsnInput in)
    throws AsnException
  {
    int tag = in.peekTag();
    if (tag < 0 || tag > MAX_TAG)
    {
      throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
    }

    int choice;
    BValue value;
    if (in.isApplicationTag(tag))
    {
      switch (tag)
      {
        case ASN_NULL:
          choice = NULL_TAG;
          value = in.readNull();
          break;
        case ASN_BOOLEAN:
          choice = BOOLEAN_TAG;
          value = BBoolean.make(in.readBoolean());
          break;
        case ASN_UNSIGNED:
          choice = UNSIGNED_TAG;
          value = in.readUnsigned();
          break;
        case ASN_INTEGER:
          choice = SIGNED_TAG;
          value = in.readSigned();
          break;
        case ASN_REAL:
          choice = REAL_TAG;
          value = in.readFloat();
          break;
        case ASN_DOUBLE:
          choice = DOUBLE_TAG;
          value = BDouble.make(in.readDouble());
          break;
        case ASN_OCTET_STRING:
          choice = OCTETSTRING_TAG;
          value = in.readBacnetOctetString();
          break;
        case ASN_CHARACTER_STRING:
          choice = CHARACTERSTRING_TAG;
          value = BString.make(in.readCharacterString());
          break;
        case ASN_BIT_STRING:
          choice = BITSTRING_TAG;
          value = in.readBitString();
          break;
        case ASN_ENUMERATED:
          choice = ENUMERATED_TAG;
          value = BInteger.make(in.readEnumerated());
          break;
        case ASN_DATE:
          choice = DATE_TAG;
          value = in.readDate();
          break;
        case ASN_TIME:
          choice = TIME_TAG;
          value = in.readTime();
          break;
        case ASN_OBJECT_IDENTIFIER:
          choice = OBJECTID_TAG;
          value = in.readObjectIdentifier();
          break;
        default:
          throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
      }
    }
    else if (in.isOpeningTag(LIGHTCOMMAND_SUB_TAG))
    {
      in.skipTag();
      BBacnetLightingCommand lightingCommand = new BBacnetLightingCommand();
      lightingCommand.readAsn(in);
      in.skipClosingTag(LIGHTCOMMAND_SUB_TAG);

      choice = LIGHTCOMMAND_TAG;
      value = lightingCommand;
    }
    else
    {
      throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
    }

    removeAll(noWrite);
    add(getSlotName(choice), value, noWrite);
    // Set the choice value after adding the value slot so the property change and write property is
    // only sent once the value and choice are consistent with each other.
    setInt(BBacnetChannelValue.choice, choice, noWrite);
  }

////////////////////////////////////////////////////////////////
// Spy
////////////////////////////////////////////////////////////////

  public void spy(SpyWriter out) throws Exception
  {
    super.spy(out);
    out.startProps();
    out.trTitle("BacnetChannelValue", 2);
    out.prop("virtual", BacnetVirtualUtil.isVirtual(this));
    out.endProps();
  }

/////////////////////////////////////////////////////////////////
//  Constants
/////////////////////////////////////////////////////////////////

  private static final int MAX_TAG = 254;

  public static final int NULL_TAG = 0;
  public static final int REAL_TAG = 1;
  public static final int ENUMERATED_TAG = 2;
  public static final int UNSIGNED_TAG = 3;
  public static final int BOOLEAN_TAG = 4;
  public static final int SIGNED_TAG = 5;
  public static final int DOUBLE_TAG = 6;
  public static final int TIME_TAG = 7;
  public static final int CHARACTERSTRING_TAG = 8;
  public static final int OCTETSTRING_TAG = 9;
  public static final int BITSTRING_TAG = 10;
  public static final int DATE_TAG = 11;
  public static final int OBJECTID_TAG = 12;
  public static final int LIGHTCOMMAND_TAG = 13;
  public static final int LIGHTCOMMAND_SUB_TAG = 0;

  private static final String NULL_VALUE_SLOT_NAME = "null";
  private static final String REAl_SLOT_NAME = "real";
  private static final String ENUMERATED_SLOT_NAME = "enumerated";
  private static final String UNSIGNED_SLOT_NAME = "unsigned";
  private static final String BOOLEAN_SLOT_NAME = "boolean";
  private static final String SIGNED_SLOT_NAME = "signed";
  private static final String DOUBLE_SLOT_NAME = "double";
  private static final String TIME_SLOT_NAME = "time";
  private static final String CHARACTER_STRING_SLOT_NAME = "characterString";
  private static final String OCTET_STRING_SLOT_NAME = "octetString";
  private static final String BIT_STRING_SLOT_NAME = "bitString";
  private static final String DATE_SLOT_NAME = "date";
  private static final String OBJECT_ID_SLOT_NAME = "objectId";
  private static final String LIGHTING_COMMAND_SLOT_NAME = "lightingCommand";

  private static final Lexicon lex = Lexicon.make("bacnet");

  /**
   * Return the value of this object based on the choice value. Returns null if the choice is not
   * defined.
   *
   * @since Niagara 4.14U3
   * @since Niagara 4.15U2
   */
  public BValue getValue()
  {
    String slotName = getSlotName(getChoice());
    return slotName != null ? get(slotName) : null;
  }

  /**
   * Map of choice to choice info.
   */
  private static final Map<Integer, ChoiceInfo> choiceToInfoMap = makeChoiceInfoMap();

  private static Map<Integer, ChoiceInfo> makeChoiceInfoMap()
  {
    Map<Integer, ChoiceInfo> map = new LinkedHashMap<>();
    // choice, slotName, defaultValue
    putChoiceInfo(map, NULL_TAG, NULL_VALUE_SLOT_NAME, BBacnetNull.DEFAULT);
    putChoiceInfo(map, REAL_TAG, REAl_SLOT_NAME, BFloat.DEFAULT);
    putChoiceInfo(map, ENUMERATED_TAG, ENUMERATED_SLOT_NAME, BInteger.DEFAULT);
    putChoiceInfo(map, UNSIGNED_TAG, UNSIGNED_SLOT_NAME, BBacnetUnsigned.DEFAULT);
    putChoiceInfo(map, BOOLEAN_TAG, BOOLEAN_SLOT_NAME, BBoolean.DEFAULT);
    putChoiceInfo(map, SIGNED_TAG, SIGNED_SLOT_NAME, BInteger.DEFAULT);
    putChoiceInfo(map, DOUBLE_TAG, DOUBLE_SLOT_NAME, BDouble.DEFAULT);
    putChoiceInfo(map, TIME_TAG, TIME_SLOT_NAME, BBacnetTime.DEFAULT);
    putChoiceInfo(map, CHARACTERSTRING_TAG, CHARACTER_STRING_SLOT_NAME, BString.DEFAULT);
    putChoiceInfo(map, OCTETSTRING_TAG, OCTET_STRING_SLOT_NAME, BBacnetOctetString.DEFAULT);
    putChoiceInfo(map, BITSTRING_TAG, BIT_STRING_SLOT_NAME, BBacnetBitString.DEFAULT);
    putChoiceInfo(map, DATE_TAG, DATE_SLOT_NAME, BBacnetDate.DEFAULT);
    putChoiceInfo(map, OBJECTID_TAG, OBJECT_ID_SLOT_NAME, BBacnetObjectIdentifier.DEFAULT);
    putChoiceInfo(map, LIGHTCOMMAND_TAG, LIGHTING_COMMAND_SLOT_NAME, new BBacnetLightingCommand());
    return map;
  }

  private static void putChoiceInfo(Map<Integer, ChoiceInfo> map, int choice, String slotName, BValue defaultValue)
  {
    map.put(choice, new ChoiceInfo(slotName, defaultValue));
  }

  private static final BEnumRange choiceRange = makeChoiceRange();

  private static BEnumRange makeChoiceRange()
  {
    List<Map.Entry<Integer, ChoiceInfo>> entries = new ArrayList<>(choiceToInfoMap.entrySet());
    int size = entries.size();
    int[] ordinals = new int[size];
    String[] tags = new String[size];
    for (int i = 0; i < size; i++)
    {
      Map.Entry<Integer, ChoiceInfo> entry = entries.get(i);
      ordinals[i] = entry.getKey();
      tags[i] = SlotPath.escape("BacnetChannelValue." + entry.getValue().slotName);
    }
    BFacets options = BFacets.make("lexicon", "bacnet");
    return BEnumRange.make(null, ordinals, tags, size, options);
  }

  /**
   * Return the possible choices.
   * @since Niagara 4.14u3
   * @since Niagara 4.15u2
   */
  public static BEnumRange getChoiceRange()
  {
    return choiceRange;
  }

  /**
   * Return the slot name based on the choice.
   * @since Niagara 4.14u3
   * @since Niagara 4.15u2
   */
  public static String getSlotName(int choice)
  {
    if (choice < 0 || choice > LIGHTCOMMAND_TAG)
    {
      return null;
    }
    return choiceToInfoMap.get(choice).slotName;
  }

  /**
   * Return a default value based on the choice.
   * @since Niagara 4.14u3
   * @since Niagara 4.15u2
   */
  public static BValue getDefaultValue(int choice)
  {
    if (choice < 0 || choice > LIGHTCOMMAND_TAG)
    {
      return null;
    }
    return choiceToInfoMap.get(choice).defaultValue;
  }

  private static class ChoiceInfo
  {
    public final String slotName;
    public final BValue defaultValue;

    public ChoiceInfo(String slotName, BValue defaultValue)
    {
      this.slotName = slotName;
      this.defaultValue = defaultValue;
    }
  }
}
