/*
 * Copyright 2025 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * @author Bishal Debbarma on 03-July-2025
 * @since Niagara 4.14u3
 * @since Niagara 4.15u2
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("bitmask"),
    @Range("referencedPropertyIncrement")
  }
)
public final class BBacnetChangeOfValueCriteriaChoice
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetChangeOfValueCriteriaChoice(2920801901)1.0$ @*/
/* Generated Wed Jul 09 15:05:07 CDT 2025 by Slot-o-Matic (c) Tridium, Inc. 2012-2025 */

  /** Ordinal value for bitmask. */
  @Generated
  public static final int BITMASK = 0;
  /** Ordinal value for referencedPropertyIncrement. */
  @Generated
  public static final int REFERENCED_PROPERTY_INCREMENT = 1;

  /** BBacnetChangeOfValueCriteriaChoice constant for bitmask. */
  @Generated
  public static final BBacnetChangeOfValueCriteriaChoice bitmask = new BBacnetChangeOfValueCriteriaChoice(BITMASK);
  /** BBacnetChangeOfValueCriteriaChoice constant for referencedPropertyIncrement. */
  @Generated
  public static final BBacnetChangeOfValueCriteriaChoice referencedPropertyIncrement = new BBacnetChangeOfValueCriteriaChoice(REFERENCED_PROPERTY_INCREMENT);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetChangeOfValueCriteriaChoice make(int ordinal)
  {
    return (BBacnetChangeOfValueCriteriaChoice)bitmask.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetChangeOfValueCriteriaChoice make(String tag)
  {
    return (BBacnetChangeOfValueCriteriaChoice)bitmask.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetChangeOfValueCriteriaChoice(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetChangeOfValueCriteriaChoice DEFAULT = bitmask;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetChangeOfValueCriteriaChoice.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
