/*
 * Copyright 2025 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import static javax.baja.bacnet.datatypes.BBacnetChangeOfValueCriteriaChoice.bitmask;
import static javax.baja.bacnet.datatypes.BBacnetChangeOfValueCriteriaChoice.referencedPropertyIncrement;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFloat;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnConst;

/**
 * Represents the cov-criteria field of the BACnet Change of Value event parameter choice.
 *
 * @author Bishal Debbarma on 03-July-2025
 * @since Niagara 4.14u3
 * @since Niagara 4.15u2
 */

@NiagaraType
@NiagaraProperty(
  name = "choice",
  type = "BBacnetChangeOfValueCriteriaChoice",
  defaultValue = "BBacnetChangeOfValueCriteriaChoice.DEFAULT"
)
@NiagaraProperty(
  name = "value",
  type = "BSimple",
  defaultValue = "BBacnetBitString.DEFAULT"
)
public class BBacnetChangeOfValueCriteria
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetChangeOfValueCriteria(1007173301)1.0$ @*/
/* Generated Wed Jul 09 17:26:47 CDT 2025 by Slot-o-Matic (c) Tridium, Inc. 2012-2025 */

  //region Property "choice"

  /**
   * Slot for the {@code choice} property.
   * @see #getChoice
   * @see #setChoice
   */
  @Generated
  public static final Property choice = newProperty(0, BBacnetChangeOfValueCriteriaChoice.DEFAULT, null);

  /**
   * Get the {@code choice} property.
   * @see #choice
   */
  @Generated
  public BBacnetChangeOfValueCriteriaChoice getChoice() { return (BBacnetChangeOfValueCriteriaChoice)get(choice); }

  /**
   * Set the {@code choice} property.
   * @see #choice
   */
  @Generated
  public void setChoice(BBacnetChangeOfValueCriteriaChoice v) { set(choice, v, null); }

  //endregion Property "choice"

  //region Property "value"

  /**
   * Slot for the {@code value} property.
   * @see #getValue
   * @see #setValue
   */
  @Generated
  public static final Property value = newProperty(0, BBacnetBitString.DEFAULT, null);

  /**
   * Get the {@code value} property.
   * @see #value
   */
  @Generated
  public BSimple getValue() { return (BSimple)get(value); }

  /**
   * Set the {@code value} property.
   * @see #value
   */
  @Generated
  public void setValue(BSimple v) { set(value, v, null); }

  //endregion Property "value"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetChangeOfValueCriteria.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Write the value to the Asn output stream.
   */
  @Override
  public void writeAsn(AsnOutput out)
  {
    int choice = getChoice().getOrdinal();
    switch (choice)
    {
      case BBacnetChangeOfValueCriteriaChoice.BITMASK:
        out.writeBitString(choice, (BBacnetBitString)getValue());
        break;
      case BBacnetChangeOfValueCriteriaChoice.REFERENCED_PROPERTY_INCREMENT:
        out.writeReal(choice, (BFloat)getValue());
        break;
      default:
        throw new IllegalStateException("Invalid change of value criteria choice: " + choice);
    }
  }

  /**
   * Read the value from the Asn input stream.
   */
  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    int choice = in.peekTag();
    switch (choice)
    {
      case BBacnetChangeOfValueCriteriaChoice.BITMASK:
        setChoiceAndValue(bitmask, in.readBitString(choice));
        break;
      case BBacnetChangeOfValueCriteriaChoice.REFERENCED_PROPERTY_INCREMENT:
        setChoiceAndValue(referencedPropertyIncrement, in.readFloat(choice));
        break;
      default:
        throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + choice);
    }
  }

  private void setChoiceAndValue(BBacnetChangeOfValueCriteriaChoice choice, BValue value)
  {
    set(BBacnetChangeOfValueCriteria.choice, choice, noWrite);
    set(BBacnetChangeOfValueCriteria.value, value, noWrite);
  }

  public String toString(Context context)
  {
    BBacnetChangeOfValueCriteriaChoice choice = getChoice();
    return choice + " " + getValue().toString(context);
  }
}
