/*
 * Copyright 2022 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnConst;

/**
 * Represents the BACnetActionList structure, which contains a sequence of BACnetActionCommands
 *
 * @author Uday Rapuru on 04-Nov-2022
 * @since Niagara 4.14
 */

@NiagaraType
/*
 Add a BACnetActionCommand to this action list.
 @since Niagara 4.14u3
 @since Niagara 4.15u2
 */
@NiagaraAction(
  name = "addAction",
  parameterType = "BBacnetActionCommand",
  defaultValue = "new BBacnetActionCommand()"
)
public final class BBacnetActionList
  extends BComponent
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetActionList(3129138193)1.0$ @*/
/* Generated Fri Jun 06 12:50:00 CDT 2025 by Slot-o-Matic (c) Tridium, Inc. 2012-2025 */

  //region Action "addAction"

  /**
   * Slot for the {@code addAction} action.
   * Add a BACnetActionCommand to this action list.
   * @since Niagara 4.14u3
   * @since Niagara 4.15u2
   * @see #addAction(BBacnetActionCommand parameter)
   */
  @Generated
  public static final Action addAction = newAction(0, new BBacnetActionCommand(), null);

  /**
   * Invoke the {@code addAction} action.
   * Add a BACnetActionCommand to this action list.
   * @since Niagara 4.14u3
   * @since Niagara 4.15u2
   * @see #addAction
   */
  @Generated
  public void addAction(BBacnetActionCommand parameter) { invoke(addAction, parameter, null); }

  //endregion Action "addAction"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetActionList.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * return true if child is a BBacnetActionCommand
   */
  @Override
  public boolean isChildLegal(BComponent child)
  {
    return child instanceof BBacnetActionCommand;
  }

  /**
   * Add a BACnetActionCommand to this action list.
   * @since Niagara 4.14u3
   * @since Niagara 4.15u2
   */
  public void doAddAction(BBacnetActionCommand actionCommand, Context context)
  {
    add(null, actionCommand, context);
  }

  @Override
  public void changed(Property property, Context context)
  {
    super.changed(property, context);

    // Notify the parent of a property change so, if the parent is a config object for a remote
    // object, the change will be written.
    notifyParentOfChange(context);
  }

  @Override
  public void added(Property property, Context context)
  {
    super.added(property, context);

    if (!isRunning())
    {
      return;
    }

    BValue newValue = get(property);
    if (newValue instanceof BBacnetActionCommand)
    {
      // When a BBacnetActionCommand is added, a parent config needs to write that to the remote
      // device.
      notifyParentOfChange(context);
    }
  }

  @Override
  public void removed(Property property, BValue oldValue, Context context)
  {
    super.removed(property, oldValue, context);

    if (!isRunning())
    {
      return;
    }

    if (oldValue instanceof BBacnetActionCommand)
    {
      // When a BBacnetActionCommand is removed, a parent config needs to write that to the remote
      // device.
      notifyParentOfChange(context);
    }
  }

  private void notifyParentOfChange(Context context)
  {
    BComplex parent = getParent();
    Property propertyInParent = getPropertyInParent();
    if (parent instanceof BComponent && propertyInParent != null)
    {
      ((BComponent) parent).changed(propertyInParent, context);
    }
  }

  /**
   * Read the value from the Asn input stream.
   */
  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    List<BBacnetActionCommand> actionCommands = new ArrayList<>();
    in.skipOpeningTag(0);
    int tag = in.peekTag();
    while (!in.isClosingTag(0))
    {
      if (tag == AsnInput.END_OF_DATA)
      {
        throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + AsnInput.END_OF_DATA);
      }

      BBacnetActionCommand actionCommand = new BBacnetActionCommand();
      actionCommand.readAsn(in);
      actionCommands.add(actionCommand);
      tag = in.peekTag();
    }
    in.skipClosingTag(0);

    removeAll(noWrite);
    for (BBacnetActionCommand actionCommand : actionCommands)
    {
      add(null, actionCommand, noWrite);
    }
  }

  /**
   * Write the value to the Asn output stream.
   */
  @Override
  public void writeAsn(AsnOutput out)
  {
    out.writeOpeningTag(0);
    for (BBacnetActionCommand actionCommand : getChildren(BBacnetActionCommand.class))
    {
      actionCommand.writeAsn(out);
    }
    out.writeClosingTag(0);
  }

  @Override
  public String toString(Context context)
  {
    // Handle PropertySheet with just the top level string
    if (context != null)
    {
      return super.toString(context);
    }

    loadSlots();
    StringJoiner joiner = new StringJoiner(",", "{", "}");
    for (BBacnetActionCommand actionCommand : getChildren(BBacnetActionCommand.class))
    {
      joiner.add(actionCommand.toString(context));
    }
    return joiner.toString();
  }
}
