/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetNodeType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetStructuredView represents the BacnetStructuredView config.
 *
 * @author Bishal Debbarma
 * @since  Niagara 4.14
 */
@NiagaraType
@NiagaraProperty(
  name = "objectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.STRUCTURED_VIEW)",
  flags = Flags.SUMMARY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER)"),
  override = true
)
@NiagaraProperty(
  name = "objectType",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetObjectType.STRUCTURED_VIEW, BEnumRange.make(BBacnetObjectType.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED)"),
  override = true
)
@NiagaraProperty(
  name = "nodeType",
  type = "BBacnetNodeType",
  defaultValue = "BBacnetNodeType.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.NODE_TYPE, ASN_ENUMERATED)")
)
@NiagaraProperty(
  name = "subordinateList",
  type = "BBacnetArray",
  defaultValue = "new BBacnetArray(BBacnetDeviceObjectReference.TYPE)",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.SUBORDINATE_LIST, ASN_BACNET_ARRAY)")
)
public class BBacnetStructuredView
  extends BBacnetObject
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.config.BBacnetStructuredView(4212401870)1.0$ @*/
/* Generated Fri Feb 24 17:15:53 IST 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "objectId"

  /**
   * Slot for the {@code objectId} property.
   * @see #getObjectId
   * @see #setObjectId
   */
  @Generated
  public static final Property objectId = newProperty(Flags.SUMMARY, BBacnetObjectIdentifier.make(BBacnetObjectType.STRUCTURED_VIEW), makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER));

  //endregion Property "objectId"

  //region Property "objectType"

  /**
   * Slot for the {@code objectType} property.
   * @see #getObjectType
   * @see #setObjectType
   */
  @Generated
  public static final Property objectType = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetObjectType.STRUCTURED_VIEW, BEnumRange.make(BBacnetObjectType.TYPE)), makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED));

  //endregion Property "objectType"

  //region Property "nodeType"

  /**
   * Slot for the {@code nodeType} property.
   * @see #getNodeType
   * @see #setNodeType
   */
  @Generated
  public static final Property nodeType = newProperty(0, BBacnetNodeType.DEFAULT, makeFacets(BBacnetPropertyIdentifier.NODE_TYPE, ASN_ENUMERATED));

  /**
   * Get the {@code nodeType} property.
   * @see #nodeType
   */
  @Generated
  public BBacnetNodeType getNodeType() { return (BBacnetNodeType)get(nodeType); }

  /**
   * Set the {@code nodeType} property.
   * @see #nodeType
   */
  @Generated
  public void setNodeType(BBacnetNodeType v) { set(nodeType, v, null); }

  //endregion Property "nodeType"

  //region Property "subordinateList"

  /**
   * Slot for the {@code subordinateList} property.
   * @see #getSubordinateList
   * @see #setSubordinateList
   */
  @Generated
  public static final Property subordinateList = newProperty(0, new BBacnetArray(BBacnetDeviceObjectReference.TYPE), makeFacets(BBacnetPropertyIdentifier.SUBORDINATE_LIST, ASN_BACNET_ARRAY));

  /**
   * Get the {@code subordinateList} property.
   * @see #subordinateList
   */
  @Generated
  public BBacnetArray getSubordinateList() { return (BBacnetArray)get(subordinateList); }

  /**
   * Set the {@code subordinateList} property.
   * @see #subordinateList
   */
  @Generated
  public void setSubordinateList(BBacnetArray v) { set(subordinateList, v, null); }

  //endregion Property "subordinateList"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetStructuredView.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
