/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetActionList;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetCommand represents the BacnetCommand config.
 *
 * @author Bishal Debbarma
 * @since  Niagara 4.14
 */
@NiagaraType
@NiagaraProperty(
  name = "objectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.COMMAND)",
  flags = Flags.SUMMARY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER)"),
  override = true
)
@NiagaraProperty(
  name = "objectType",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetObjectType.COMMAND, BEnumRange.make(BBacnetObjectType.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED)"),
  override = true
)
@NiagaraProperty(
  name = "presentValue",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE, ASN_UNSIGNED)")
)
/*
 These facets are applied against the presentValue property.
 They can be used to describe the various actions available.
 */
@NiagaraProperty(
  name = "facets",
  type = "BFacets",
  defaultValue = "BFacets.DEFAULT"
)
@NiagaraProperty(
  name = "inProcess",
  type = "boolean",
  defaultValue = "false",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.IN_PROCESS, ASN_BOOLEAN)")
)
@NiagaraProperty(
  name = "allWritesSuccessful",
  type = "boolean",
  defaultValue = "true",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.ALL_WRITES_SUCCESSFUL, ASN_BOOLEAN)")
)
@NiagaraProperty(
  name = "action",
  type = "BBacnetArray",
  defaultValue = "new BBacnetArray(BBacnetActionList.TYPE)",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.ACTION, ASN_CONSTRUCTED_DATA)")
)
public class BBacnetCommand
  extends BBacnetObject
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.config.BBacnetCommand(2415369278)1.0$ @*/
/* Generated Fri Feb 24 17:14:22 IST 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "objectId"

  /**
   * Slot for the {@code objectId} property.
   * @see #getObjectId
   * @see #setObjectId
   */
  @Generated
  public static final Property objectId = newProperty(Flags.SUMMARY, BBacnetObjectIdentifier.make(BBacnetObjectType.COMMAND), makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER));

  //endregion Property "objectId"

  //region Property "objectType"

  /**
   * Slot for the {@code objectType} property.
   * @see #getObjectType
   * @see #setObjectType
   */
  @Generated
  public static final Property objectType = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetObjectType.COMMAND, BEnumRange.make(BBacnetObjectType.TYPE)), makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED));

  //endregion Property "objectType"

  //region Property "presentValue"

  /**
   * Slot for the {@code presentValue} property.
   * @see #getPresentValue
   * @see #setPresentValue
   */
  @Generated
  public static final Property presentValue = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE, ASN_UNSIGNED));

  /**
   * Get the {@code presentValue} property.
   * @see #presentValue
   */
  @Generated
  public BBacnetUnsigned getPresentValue() { return (BBacnetUnsigned)get(presentValue); }

  /**
   * Set the {@code presentValue} property.
   * @see #presentValue
   */
  @Generated
  public void setPresentValue(BBacnetUnsigned v) { set(presentValue, v, null); }

  //endregion Property "presentValue"

  //region Property "facets"

  /**
   * Slot for the {@code facets} property.
   * These facets are applied against the presentValue property.
   * They can be used to describe the various actions available.
   * @see #getFacets
   * @see #setFacets
   */
  @Generated
  public static final Property facets = newProperty(0, BFacets.DEFAULT, null);

  /**
   * Get the {@code facets} property.
   * These facets are applied against the presentValue property.
   * They can be used to describe the various actions available.
   * @see #facets
   */
  @Generated
  public BFacets getFacets() { return (BFacets)get(facets); }

  /**
   * Set the {@code facets} property.
   * These facets are applied against the presentValue property.
   * They can be used to describe the various actions available.
   * @see #facets
   */
  @Generated
  public void setFacets(BFacets v) { set(facets, v, null); }

  //endregion Property "facets"

  //region Property "inProcess"

  /**
   * Slot for the {@code inProcess} property.
   * @see #getInProcess
   * @see #setInProcess
   */
  @Generated
  public static final Property inProcess = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.IN_PROCESS, ASN_BOOLEAN));

  /**
   * Get the {@code inProcess} property.
   * @see #inProcess
   */
  @Generated
  public boolean getInProcess() { return getBoolean(inProcess); }

  /**
   * Set the {@code inProcess} property.
   * @see #inProcess
   */
  @Generated
  public void setInProcess(boolean v) { setBoolean(inProcess, v, null); }

  //endregion Property "inProcess"

  //region Property "allWritesSuccessful"

  /**
   * Slot for the {@code allWritesSuccessful} property.
   * @see #getAllWritesSuccessful
   * @see #setAllWritesSuccessful
   */
  @Generated
  public static final Property allWritesSuccessful = newProperty(0, true, makeFacets(BBacnetPropertyIdentifier.ALL_WRITES_SUCCESSFUL, ASN_BOOLEAN));

  /**
   * Get the {@code allWritesSuccessful} property.
   * @see #allWritesSuccessful
   */
  @Generated
  public boolean getAllWritesSuccessful() { return getBoolean(allWritesSuccessful); }

  /**
   * Set the {@code allWritesSuccessful} property.
   * @see #allWritesSuccessful
   */
  @Generated
  public void setAllWritesSuccessful(boolean v) { setBoolean(allWritesSuccessful, v, null); }

  //endregion Property "allWritesSuccessful"

  //region Property "action"

  /**
   * Slot for the {@code action} property.
   * @see #getAction
   * @see #setAction
   */
  @Generated
  public static final Property action = newProperty(0, new BBacnetArray(BBacnetActionList.TYPE), makeFacets(BBacnetPropertyIdentifier.ACTION, ASN_CONSTRUCTED_DATA));

  /**
   * Get the {@code action} property.
   * @see #action
   */
  @Generated
  public BBacnetArray getAction() { return (BBacnetArray)get(action); }

  /**
   * Set the {@code action} property.
   * @see #action
   */
  @Generated
  public void setAction(BBacnetArray v) { set(action, v, null); }

  //endregion Property "action"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetCommand.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
