function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bacnetAws/rc/wb/mgr/commands/RestoreCommand
 */
define(['baja!', 'baja!bacnetAws:RestoreConfig,bacnetAws:RestoreJob,bacnetAws:BacnetAwsNetwork', 'lex!bacnetAws', 'bajaux/commands/Command', 'dialogs', 'Promise', 'nmodule/js/rc/csrf/csrfUtil', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/FileInputEditor', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand', 'nmodule/bacnetAws/rc/wb/mgr/commands/BacnetCommandSheet'], function (baja, types, lexs, Command, dialogs, Promise, csrfUtil, feDialogs, FileInputEditor, mgrUtils, MgrCommand, BacnetCommandSheet) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    bacnetAwsLex = _lexs[0];
  var getMainTableSelectedSubjects = mgrUtils.getMainTableSelectedSubjects;
  var _MgrCommand$flags = MgrCommand.flags,
    ALL_BARS = _MgrCommand$flags.ALL_BARS,
    MAIN_CONTEXT_MENU = _MgrCommand$flags.MAIN_CONTEXT_MENU;

  /**
   * Return an object to be displayed in a property sheet for the Comm control config.
   * This will use a couple of dynamic enums, which will be converted to a instance
   * of BCommControlConfig later.
   *
   * @returns {Promise<baja.Component>}
   */
  function makeConfigObject() {
    var config = baja.$("bacnetAws:RestoreConfig"),
      comp = toComponent(config);
    return Promise.resolve(comp);
  }

  /**
   * Transfer the Struct slot values to a Component slot values as dynamicProperties
   * @param {baja.Struct} config
   * @returns {baja.Component}
   */
  function toComponent(config) {
    var comp = baja.$("baja:Component");
    var nameMap = {};
    comp.add({
      slot: "restoreFile",
      value: "",
      facets: baja.Facets.make({
        uxFieldEditor: 'nmodule/webEditors/rc/fe/baja/FileInputEditor',
        enablePopOut: false
      })
    });
    nameMap.restoreFile = bacnetAwsLex.get('restoreFile');
    config.getSlots().properties().each(function (prop) {
      var propName = prop.getName(),
        facets = config.getFacets(propName),
        flags = config.getFlags(propName),
        displayName = config.getDisplayName(propName),
        value = config.get(propName).newCopy();
      if (prop.getName() === "password") {
        facets = baja.Facets.make(facets, baja.Facets.make({
          enablePopOut: false
        }));
      }
      if (prop.getName() === "directory") {
        flags = flags | baja.Flags.HIDDEN;
      }
      comp.add({
        slot: propName,
        value: value,
        facets: facets,
        flags: flags
      });
      nameMap[propName] = displayName;
    });
    comp.add({
      slot: "displayNames",
      flags: baja.Flags.HIDDEN | baja.Flags.READONLY,
      value: baja.NameMap.make(nameMap)
    });
    return comp;
  }

  /**
   * Transfer the component slot values to the struct slot values
   * @param {baja.Struct} struct
   * @param {baja.Component} comp
   */
  function toStruct(struct, comp) {
    struct.getSlots().properties().each(function (prop) {
      struct.set({
        slot: prop.getName(),
        value: comp.get(prop.getName()).newCopy()
      });
    });
    return struct;
  }

  /**
   * Show the given configuration object in a property sheet. The
   * values will be used to set the argument for the job.
   *
   * @returns {Promise}
   */
  function showConfigDialog(config) {
    return Promise.resolve().then(function () {
      return feDialogs.showFor({
        title: bacnetAwsLex.get('restore.title'),
        type: BacnetCommandSheet,
        value: config,
        properties: {
          showHeader: false
        }
      });
    });
  }

  /**
   * Display an error dialog, inserting the error text into the failure message.
   */
  function showErrorDialog(err) {
    baja.error(err);
    dialogs.showOk({
      title: bacnetAwsLex.get('restore.title'),
      text: bacnetAwsLex.get({
        key: 'restore.fail',
        args: [err]
      })
    });
  }
  function marshal(object) {
    var password = object.get('password').valueOf();
    object.set({
      slot: 'password',
      value: baja.$('baja:Password')
    }); //empty the password
    return [JSON.stringify(baja.bson.encodeValue(object)), password];
  }

  /**
   * Command for firing a ReinitializeDevice on the BACnet AWS network.
   *
   * @class
   * @alias module:nmodule/bacnetAws/rc/wb/mgr/commands/RestoreCommand
   * @extends module:bajaux/commands/Command
   */
  var RestoreCommand = function RestoreCommand(mgr) {
    var that = this;
    Command.call(this, {
      displayName: bacnetAwsLex.get('restore.label'),
      description: bacnetAwsLex.get('restore.description'),
      icon: bacnetAwsLex.get('restore.icon'),
      enabled: false,
      flags: ALL_BARS | MAIN_CONTEXT_MENU,
      /**
       * Display a dialog with the choices of RestoreConfig parameters.
       *
       * @alias module:nmodule/bacnetAws/rc/wb/mgr/commands/RestoreCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        var network = mgr.getNetwork();
        var original;
        return makeConfigObject().then(function (c) {
          original = c;
          return showConfigDialog(c);
        }).then(function (diff) {
          if (diff) {
            return original;
          }
        }).then(function (config) {
          if (!config) {
            return;
          }
          var jobConfig = toStruct(baja.$('bacnetAws:RestoreConfig'), config);

          //add device specific info
          var selection = getMainTableSelectedSubjects(mgr)[0];
          jobConfig.set({
            slot: 'deviceAddress',
            value: selection.getAddress().newCopy()
          });
          jobConfig.set({
            slot: 'characterSet',
            value: selection.getCharacterSet()
          });
          jobConfig.set({
            slot: 'deviceId',
            value: selection.getConfig().getDeviceObject().getObjectId()
          });
          var args = marshal(jobConfig),
            formData = new FormData();
          formData.append("networkOrd", String(network.getNavOrd()));
          formData.append("config", args[0]);
          formData.append("password", args[1]);
          formData.append("file", FileInputEditor.getLastUploadedFile());
          //
          var xhr = new XMLHttpRequest();
          xhr.open("POST", "/bacnetAws/bacnetAws/restore");
          xhr.setRequestHeader("x-niagara-csrfToken", csrfUtil.getCsrfToken());
          xhr.onreadystatechange = function () {
            if (xhr.readyState === XMLHttpRequest.DONE) {
              var ord = baja.Ord.make(xhr.responseText);

              // Pass the job to the manager. This will set it on the job bar and
              // will listen for the completion event. It will check the type and
              // display a message when complete.

              mgr.setJob(baja.Ord.make({
                base: baja.Ord.make('station:'),
                child: ord.relativizeToSession()
              }));
            }
          };
          xhr.send(formData);
        })["catch"](showErrorDialog);
      }
    });
    mgr.on('jobcomplete', function (job) {
      if (job.getType().is('bacnetAws:RestoreJob')) {
        that.complete(job);
      }
    });
  };
  RestoreCommand.prototype = Object.create(Command.prototype);
  RestoreCommand.prototype.constructor = RestoreCommand;

  /**
   * Function called when the RestoreCommand has completed.
   *
   * @param {baja.Component} job - the time synch job, submitted by the invoke function
   * above.
   */
  RestoreCommand.prototype.complete = function (job) {
    var msg, cause;
    if (job.getJobState().getTag() === 'success') {
      msg = bacnetAwsLex.get('restore.success');
    } else {
      cause = job.get('failureCause') || '';
      msg = bacnetAwsLex.get({
        key: 'restore.fail',
        args: [cause]
      });
    }
    dialogs.showOk({
      title: bacnetAwsLex.get('restore.title'),
      text: msg
    });
  };
  return RestoreCommand;
});
