function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnetAws/rc/wb/mgr/commands/DeviceCommunicationControlCommand
 */
define(['baja!', 'baja!bacnetAws:CommControlConfig,bacnetAws:DeviceCommControlJob,bacnetAws:BacnetAwsNetwork', 'lex!bacnetAws', 'bajaux/commands/Command', 'dialogs', 'Promise', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand', 'nmodule/bacnetAws/rc/wb/mgr/commands/BacnetCommandSheet'], function (baja, types, lexs, Command, dialogs, Promise, feDialogs, mgrUtils, MgrCommand, BacnetCommandSheet) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    bacnetAwsLex = _lexs[0];
  var getMainTableSelectedSubjects = mgrUtils.getMainTableSelectedSubjects;
  var _MgrCommand$flags = MgrCommand.flags,
    ALL_BARS = _MgrCommand$flags.ALL_BARS,
    MAIN_CONTEXT_MENU = _MgrCommand$flags.MAIN_CONTEXT_MENU;

  /**
   * Return an object to be displayed in a property sheet for the Comm control config.
   * This will use a couple of dynamic enums, which will be converted to a instance
   * of BCommControlConfig later.
   *
   * @returns {Promise<baja.Component>}
   */
  function makeConfigObject() {
    var config = baja.$("bacnetAws:CommControlConfig"),
      comp = toComponent(config);
    return Promise.resolve(comp);
  }

  /**
   * Transfer the Struct slot values to a Component slot values as dynamicProperties
   * @param {baja.Struct} config
   * @returns {baja.Component}
   */
  function toComponent(config) {
    var comp = baja.$("baja:Component"),
      nameMap = {};
    config.getSlots().properties().each(function (prop) {
      var name = prop.getName(),
        facets = config.getFacets(name);
      if (name === "password") {
        facets = baja.Facets.make(facets, baja.Facets.make({
          enablePopOut: false
        }));
      }
      comp.add({
        slot: name,
        value: config.get(name).newCopy(),
        facets: facets,
        flags: config.getFlags(name)
      });
      nameMap[name] = config.getDisplayName(name);
    });
    comp.add({
      slot: "displayNames",
      flags: baja.Flags.HIDDEN | baja.Flags.READONLY,
      value: baja.NameMap.make(nameMap)
    });
    return comp;
  }

  /**
   * Transfer the component slot values to the struct slot values
   * @param {baja.Struct} struct
   * @param {baja.Component} comp
   */
  function toStruct(struct, comp) {
    struct.getSlots().properties().each(function (prop) {
      var name = prop.getName();
      struct.set({
        slot: name,
        value: comp.get(name).newCopy()
      });
    });
    return struct;
  }

  /**
   * Show the given configuration object in a property sheet. The
   * values will be used to set the argument for the job.
   *
   * @returns {Promise}
   */
  function showConfigDialog(config) {
    return Promise.resolve().then(function () {
      return feDialogs.showFor({
        title: bacnetAwsLex.get('devCommCtrl.title'),
        type: BacnetCommandSheet,
        value: config,
        properties: {
          showHeader: false
        }
      });
    });
  }

  /**
   * Display an error dialog, inserting the error text into the failure message.
   */
  function showErrorDialog(err) {
    baja.error(err);
    dialogs.showOk({
      title: bacnetAwsLex.get('devCommCtrl.title'),
      text: bacnetAwsLex.get({
        key: 'devCommCtrl.fail',
        args: [err]
      })
    });
  }
  function marshal(object) {
    var password = object.get('password').valueOf();
    object.set({
      slot: 'password',
      value: baja.$('baja:Password')
    }); //empty the password
    return [JSON.stringify(baja.bson.encodeValue(object)), password];
  }

  /**
   * Command for firing a DeviceCommunicationControl on the BACnet AWS network.
   *
   * @class
   * @alias module:nmodule/bacnetAws/rc/wb/mgr/commands/DeviceCommunicationControlCommand
   * @extends module:bajaux/commands/Command
   */
  var DeviceCommunicationControlCommand = function DeviceCommunicationControlCommand(mgr) {
    var that = this;
    Command.call(this, {
      displayName: bacnetAwsLex.get('devCommCtrl.label'),
      description: bacnetAwsLex.get('devCommCtrl.description'),
      icon: bacnetAwsLex.get('devCommCtrl.icon'),
      enabled: false,
      flags: ALL_BARS | MAIN_CONTEXT_MENU,
      /**
       * Display a dialog with the choices of CommControlConfig parameters.
       *
       * @alias module:nmodule/bacnetAws/rc/wb/mgr/commands/DeviceCommunicationControlCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        var network = mgr.getNetwork();
        var original;
        return makeConfigObject().then(function (c) {
          original = c;
          return showConfigDialog(c);
        }).then(function (diff) {
          if (diff) {
            return original;
          }
        }).then(function (config) {
          if (!config) {
            return;
          }
          var jobConfig = toStruct(baja.$('bacnetAws:CommControlConfig'), config);

          //add device specific info
          var selection = getMainTableSelectedSubjects(mgr);
          jobConfig.set({
            slot: 'deviceAddress',
            value: selection[0].getAddress().newCopy()
          });
          jobConfig.set({
            slot: 'characterSet',
            value: selection[0].getCharacterSet()
          });
          return baja.rpc({
            ord: network.getNavOrd(),
            method: 'doSubmitDeviceManagerJob',
            args: marshal(jobConfig)
          }).then(function (ord) {
            //rpc returns a string, not an ord
            ord = baja.Ord.make(ord);

            // Pass the job to the manager. This will set it on the job bar and
            // will listen for the completion event. It will check the type and
            // display a message when complete.

            mgr.setJob(baja.Ord.make({
              base: baja.Ord.make('station:'),
              child: ord.relativizeToSession()
            }));
          });
        })["catch"](showErrorDialog);
      }
    });
    mgr.on('jobcomplete', function (job) {
      if (job.getType().is('bacnetAws:DeviceCommControlJob')) {
        that.complete(job);
      }
    });
  };
  DeviceCommunicationControlCommand.prototype = Object.create(Command.prototype);
  DeviceCommunicationControlCommand.prototype.constructor = DeviceCommunicationControlCommand;

  /**
   * Function called when the DeviceCommunicationControlCommand has completed.
   *
   * @param {baja.Component} job - the time synch job, submitted by the invoke function
   * above.
   */
  DeviceCommunicationControlCommand.prototype.complete = function (job) {
    var msg, cause;
    if (job.getJobState().getTag() === 'success') {
      msg = bacnetAwsLex.get('devCommCtrl.success');
    } else {
      cause = job.get('failureCause') || '';
      msg = bacnetAwsLex.get({
        key: 'devCommCtrl.fail',
        args: [cause]
      });
    }
    dialogs.showOk({
      title: bacnetAwsLex.get('devCommCtrl.title'),
      text: msg
    });
  };
  return DeviceCommunicationControlCommand;
});
