function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bacnetAws/rc/wb/mgr/commands/BackupCommand
 */
define(['baja!', 'baja!bacnetAws:BackupConfig,bacnetAws:BackupJob,bacnetAws:BacnetAwsNetwork', 'lex!bacnetAws', 'bajaux/commands/Command', 'dialogs', 'jquery', 'moment', 'Promise', 'nmodule/bacnetAws/rc/wb/mgr/commands/BacnetCommandSheet', 'nmodule/js/rc/csrf/csrfUtil', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand'], function (baja, types, lexs, Command, dialogs, $, moment, Promise, BacnetCommandSheet, csrfUtil, feDialogs, mgrUtils, MgrCommand) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    bacnetAwsLex = _lexs[0];
  var getMainTableSelectedSubjects = mgrUtils.getMainTableSelectedSubjects;
  var _MgrCommand$flags = MgrCommand.flags,
    ALL_BARS = _MgrCommand$flags.ALL_BARS,
    MAIN_CONTEXT_MENU = _MgrCommand$flags.MAIN_CONTEXT_MENU;

  /**
   * Return an object to be displayed in a property sheet for the Comm control config.
   * This will use a couple of dynamic enums, which will be converted to a instance
   * of BCommControlConfig later.
   *
   * @returns {Promise<baja.Component>}
   */
  function makeConfigObject() {
    var config = baja.$("bacnetAws:BackupConfig"),
      comp = toComponent(config);
    return Promise.resolve(comp);
  }

  /**
   * Transfer the Struct slot values to a Component slot values as dynamicProperties
   * @param {baja.Struct} config
   * @returns {baja.Component}
   */
  function toComponent(config) {
    var comp = baja.$("baja:Component");
    var nameMap = {};
    config.getSlots().properties().each(function (prop) {
      var propName = prop.getName(),
        facets = config.getFacets(propName),
        flags = config.getFlags(propName),
        displayName = config.getDisplayName(propName),
        value = config.get(propName).newCopy();
      if (prop.getName() === "password") {
        facets = baja.Facets.make(facets, baja.Facets.make({
          enablePopOut: false
        }));
      }
      if (prop.getName() === "baseDirectory") {
        flags = flags | baja.Flags.HIDDEN;
      }
      if (prop.getName() === "deviceDirectoryName") {
        displayName = bacnetAwsLex.get('downloadFileName');
      }
      comp.add({
        slot: propName,
        value: value,
        facets: facets,
        flags: flags
      });
      nameMap[propName] = displayName;
    });
    comp.add({
      slot: "displayNames",
      flags: baja.Flags.HIDDEN | baja.Flags.READONLY,
      value: baja.NameMap.make(nameMap)
    });
    return comp;
  }

  /**
   * Transfer the component slot values to the struct slot values
   * @param {baja.Struct} struct
   * @param {baja.Component} comp
   */
  function toStruct(struct, comp) {
    struct.getSlots().properties().each(function (prop) {
      struct.set({
        slot: prop.getName(),
        value: comp.get(prop.getName()).newCopy()
      });
    });
    return struct;
  }

  /**
   * Show the given configuration object in a property sheet. The
   * values will be used to set the argument for the job.
   *
   * @returns {Promise}
   */
  function showConfigDialog(config) {
    return feDialogs.showFor({
      title: bacnetAwsLex.get('backup.title'),
      type: BacnetCommandSheet,
      value: config,
      properties: {
        showHeader: false
      }
    });
  }

  /**
   * Display an error dialog, inserting the error text into the failure message.
   */
  function showErrorDialog(err) {
    baja.error(err);
    dialogs.showOk({
      title: bacnetAwsLex.get('backup.title'),
      text: bacnetAwsLex.get({
        key: 'backup.fail',
        args: [err]
      })
    });
  }
  function marshal(object) {
    var password = object.get('password').valueOf();
    object.set({
      slot: 'password',
      value: baja.$('baja:Password')
    }); //empty the password
    return [JSON.stringify(baja.bson.encodeValue(object)), password];
  }

  /**
   * Command for firing a Backup on the BACnet AWS network.
   *
   * @class
   * @alias module:nmodule/bacnetAws/rc/wb/mgr/commands/BackupCommand
   * @extends module:bajaux/commands/Command
   */
  var BackupCommand = function BackupCommand(mgr) {
    var that = this;
    Command.call(this, {
      displayName: bacnetAwsLex.get('backup.label'),
      description: bacnetAwsLex.get('backup.description'),
      icon: bacnetAwsLex.get('backup.icon'),
      enabled: false,
      flags: ALL_BARS | MAIN_CONTEXT_MENU,
      /**
       * Display a dialog with the choices of BackupConfig parameters.
       *
       * @alias module:nmodule/bacnetAws/rc/wb/mgr/commands/BackupCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        var network = mgr.getNetwork(),
          selection = getMainTableSelectedSubjects(mgr)[0];
        var original;
        return makeConfigObject().then(function (c) {
          original = c;
          c.set({
            slot: 'deviceDirectoryName',
            value: selection.getName() + moment().format('YYYYMMDD_HHmm')
          });
          return showConfigDialog(c);
        }).then(function (diff) {
          //If OK was pressed, a Complex Diff will be given as the result, but the original object was already applied.
          if (diff) {
            return original;
          }
        }).then(function (config) {
          if (!config) {
            return;
          }
          var jobConfig = toStruct(baja.$('bacnetAws:BackupConfig'), config);

          //add device specific info

          jobConfig.set({
            slot: 'deviceAddress',
            value: selection.getAddress().newCopy()
          });
          jobConfig.set({
            slot: 'characterSet',
            value: selection.getCharacterSet()
          });
          jobConfig.set({
            slot: 'deviceId',
            value: selection.getConfig().getDeviceObject().getObjectId()
          });
          var args = marshal(jobConfig);
          return that.ajax("/bacnetAws/bacnetAws/backup", {
            type: "POST",
            data: {
              networkOrd: String(network.getNavOrd()),
              config: args[0],
              password: args[1]
            }
          }).then(function (response) {
            var split = response.split('\n');
            //rpc returns a string, not an ord
            var ord = baja.Ord.make(baja.SlotPath.unescape(split[0])),
              downloadName = baja.SlotPath.unescape(split[1]);

            // Pass the job to the manager. This will set it on the job bar and
            // will listen for the completion event. It will check the type and
            // display a message when complete.

            var jobOrd = baja.Ord.make({
              base: baja.Ord.make('station:'),
              child: ord.relativizeToSession()
            });
            mgr.setJob(jobOrd);

            //before providing a download, give some time to ensure job doesn't fail early in the job for things like password failures
            return jobOrd.get({
              lease: true
            }).then(function (job) {
              setTimeout(function () {
                var tag = job.getJobState().getTag();
                if (tag === 'running' || tag === 'success') {
                  //download the backup via the BacnetAwsServelet backup
                  //backup is considered a sensitive download, so require csrf token
                  var requestString = "/bacnetAws/bacnetAws/download/" + baja.SlotPath.escape(ord.toString());
                  requestString += "/" + baja.SlotPath.escape(downloadName + '.zip');
                  requestString += "?csrfToken=" + csrfUtil.getCsrfToken();
                  that.download(requestString);
                }
              }, 1000);
            });
          });
        })["catch"](showErrorDialog);
      }
    });
    mgr.on('jobcomplete', function (job) {
      if (job.getType().is('bacnetAws:BackupJob')) {
        that.complete(job);
      }
    });
  };
  BackupCommand.prototype = Object.create(Command.prototype);
  BackupCommand.prototype.constructor = BackupCommand;

  /**
   * Backup currently does not work in workbench due to
   * NCCB-7155: Download functionality is currently not implemented in JavaFx WebView
   */
  BackupCommand.prototype.setEnabled = function () {
    var isWb = window.niagara && window.niagara.env && window.niagara.env.type === "wb";
    if (!isWb) {
      Command.prototype.setEnabled.apply(this, arguments);
    }
  };

  /**
   * Change window location to new url for download
   * @param {String} newLocation for download
   */
  BackupCommand.prototype.download = function (newLocation) {
    window.location = newLocation;
  };

  /**
   * Function called when the BackupCommand has completed.
   *
   * @param {baja.Component} job - the time synch job, submitted by the invoke function
   * above.
   */
  BackupCommand.prototype.complete = function (job) {
    var msg, cause;
    if (job.getJobState().getTag() === 'success') {
      msg = bacnetAwsLex.get('backup.success');
    } else {
      cause = job.get('failureCause') || '';
      msg = bacnetAwsLex.get({
        key: 'backup.fail',
        args: [cause]
      });
    }
    dialogs.showOk({
      title: bacnetAwsLex.get('backup.title'),
      text: msg
    });
  };

  /**
   * Request an ajax call to a servlet and use proper error handling.
   * @param {String} uri
   * @param {Object} [params]
   * @returns {Promise}
   */
  BackupCommand.prototype.ajax = function (uri, params) {
    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve, reject) {
      if (!params) {
        params = {};
      }
      if (!params.type) {
        params.type = "GET";
      }
      params.success = function (result) {
        resolve(result);
      };
      params.error = function (jqXHR, textStatus, errorThrown) {
        var errorResult = {};
        errorResult.toString = function () {
          return errorThrown;
        };
        errorResult.textStatus = textStatus;
        errorResult.jqXHR = jqXHR;
        reject(errorResult); //make sure the toString is not just Object
      };

      //Add the CSRF token
      var token = csrfUtil.getCsrfToken();
      if (!params.headers) {
        params.headers = {
          'x-niagara-csrfToken': token
        };
      } else {
        params.headers['x-niagara-csrfToken'] = token;
      }
      $.ajax(uri, params);
    });
  };
  return BackupCommand;
});
