function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*jshint browser: true */ /* eslint-env browser */

define(['baja!', 'jquery', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/wiresheet/rc/wb/WbConstants'], function (baja, $, _, asyncUtils, htmlUtils, WbConstants) {
  'use strict';

  var doRequire = asyncUtils.doRequire,
    LINK_H = WbConstants.LINK_H,
    LINK_V = WbConstants.LINK_V,
    LINK_L2U = WbConstants.LINK_L2U,
    LINK_L2D = WbConstants.LINK_L2D,
    LINK_R2U = WbConstants.LINK_R2U,
    LINK_R2D = WbConstants.LINK_R2D,
    LINK_U_TURN = WbConstants.LINK_U_TURN,
    WIXEL = WbConstants.WIXEL;
  var getCssTransformScaling = htmlUtils.getCssTransformScaling;
  var WIXEL_PRECISION = 2;
  var DRAG_THRESHOLD = 10;

  /**
   * API Status: **Private**
   *
   * Miscellaneous wiresheet utility functions.
   *
   * @exports nmodule/wiresheet/rc/wb/util/wsUtils
   */
  var exports = {};

  /**
   * Getting page coordinates behaves a bit differently between mouse and touch.
   * Rather than referencing `event.offsetX` etc. in an event handler, this
   * normalizes the behaviors to return the right values regardless of
   * environment. (It's also Wiresheet-specific, so don't expect the same
   * behavior if your event originates in a different view.)
   *
   * @param {Event|TouchEvent} event
   * @param {Element|JQuery} offsetParent coordinates will be calculated
   * relative to the offset parent.
   * @param {number} [zoom=1] zoom level
   * @returns {{ x: number, y: number }} the wiresheet coordinates of the event,
   * in wixels. May be negative if dragged outside the wiresheet.
   * @see #getRoundedWixelCoords
   */
  exports.getWixelCoords = function (event, offsetParent) {
    var zoom = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
    if (!offsetParent) {
      throw new Error('offsetParent required');
    }
    var actualEvent = normalizeEventInfo(event);
    var pageX = actualEvent.pageX,
      pageY = actualEvent.pageY;
    var scaling = getCssTransformScaling(offsetParent);
    var _ref = $(offsetParent).offset() || {},
      _ref$left = _ref.left,
      left = _ref$left === void 0 ? 0 : _ref$left,
      _ref$top = _ref.top,
      top = _ref$top === void 0 ? 0 : _ref$top;
    return {
      x: round((pageX - left) / WIXEL / zoom / scaling.x),
      y: round((pageY - top) / WIXEL / zoom / scaling.y)
    };
  };

  /**
   * Gets the wixel coordinates, but rounded off so that they may be used to
   * access glyphs in a wiresheet mask.
   *
   * @param {Event|TouchEvent} event
   * @param {Element|JQuery} offsetParent
   * @param {number} [zoom=1]
   * @returns {{ x: number, y: number }}
   * @see #getWixelCoords
   */
  exports.getRoundedWixelCoords = function (event, offsetParent) {
    var zoom = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
    var _exports$getWixelCoor = exports.getWixelCoords(event, offsetParent, zoom),
      x = _exports$getWixelCoor.x,
      y = _exports$getWixelCoor.y;
    return {
      x: Math.floor(x),
      y: Math.floor(y)
    };
  };

  // TODO: this is ViewModel's job
  /**
   * @param {object} entity
   * @returns {boolean}
   */
  exports.isEdge = function (entity) {
    switch (entity && entity.glyph && entity.glyph.type) {
      case 'SnakeGlyph':
      case 'StubGlyph':
        return true;
    }
    return false;
  };

  /**
   * @param {JQuery.Event} e
   * @returns {boolean} true if this is a multitouch event
   */
  exports.isMultitouch = function (e) {
    var touches = e.touches;
    return !!(touches && touches.length > 1);
  };

  /**
   * @param {JQuery.Event} e
   * @returns {boolean} true if this is a touch event
   */
  exports.isTouch = function (e) {
    var touches = e.touches;
    return !!(touches && touches.length);
  };

  // TODO: this is ViewModel's job
  /**
   * @param {object} entity
   * @returns {boolean}
   */
  exports.isVertex = function (entity) {
    switch (entity && entity.glyph && entity.glyph.type) {
      case 'ComponentGlyph':
      case 'TextBlockGlyph':
        return true;
    }
    return false;
  };

  /**
   * @param {object} entity
   * @returns {boolean} true if the provided entity has a component glyph, false
   * otherwise
   */
  exports.isComponentGlyph = function (entity) {
    switch (entity && entity.glyph && entity.glyph.type) {
      case 'ComponentGlyph':
        return true;
    }
    return false;
  };

  /**
   * @param {object} entity
   * @returns {boolean}
   */
  exports.isTextBlock = function (entity) {
    switch (entity && entity.glyph && entity.glyph.type) {
      case 'TextBlockGlyph':
        return true;
    }
    return false;
  };

  /**
   * @param {object} entity
   * @returns {boolean}
   */
  exports.isStub = function (entity) {
    switch (entity && entity.glyph && entity.glyph.type) {
      case 'StubGlyph':
        return true;
    }
    return false;
  };

  /**
   * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} entity
   * @returns {boolean} true if the given entity is selectable, false otherwise
   */
  exports.isSelectable = function (entity) {
    return !!entity.glyph.uiStatus && entity.glyph.uiStatus.selectable !== false;
  };

  /**
   * @param {JQuery.Event} event latest mousemove event
   * @param {JQuery.Event} originatingEvent event that started the op
   * @returns {boolean} true if the event is within 10px of the originating op -
   * indicating that the user hasn't really dragged like they mean it
   */
  exports.isWobble = function (event, originatingEvent) {
    if (!originatingEvent) {
      return true;
    }
    var _normalizeEventInfo = normalizeEventInfo(originatingEvent),
      origX = _normalizeEventInfo.pageX,
      origY = _normalizeEventInfo.pageY;
    var _normalizeEventInfo2 = normalizeEventInfo(event),
      pageX = _normalizeEventInfo2.pageX,
      pageY = _normalizeEventInfo2.pageY;
    var deltaX = pageX - origX;
    var deltaY = pageY - origY;
    return !(Math.abs(deltaX) > DRAG_THRESHOLD || Math.abs(deltaY) > DRAG_THRESHOLD);
  };

  /**
   * Getting the target of a mouseup behaves a bit differently between mouse
   * and touch. Rather than referencing `event.target` in a mouseup/touchend,
   * this normalizes the behaviors to find out which event over which you
   * released your finger/mouse button.
   * @param {MouseEvent|TouchEvent} event
   * @returns {Element}
   */
  exports.getMouseupTarget = function (event) {
    var changedTouches = event.changedTouches;
    if (changedTouches && changedTouches.length === 1) {
      var touch = changedTouches[0];
      return document.elementFromPoint(touch.pageX, touch.pageY);
    } else {
      return event.target;
    }
  };

  /**
   * Check to see if the given point is inside the given layout.
   * @param {{ x: number, y: number, width: number, height: number }} layout
   * @param {{ x: number, y: number }} p
   * @returns {boolean}
   */
  exports.layoutContainsPoint = function (layout, p) {
    var x = layout.x,
      y = layout.y,
      width = layout.width,
      height = layout.height;
    var px = p.x,
      py = p.y;
    return px >= x && px <= x + width && py >= y && py <= y + height;
  };

  /**
   * Check to see if the first layout object completely contains the second.
   * @param {{ x: number, y: number, width: number, height: number }} layout1
   * @param {{ x: number, y: number, width: number, height: number }} layout2
   * @returns {boolean}
   */
  exports.layoutContainsLayout = function (_ref2, _ref3) {
    var x1 = _ref2.x,
      y1 = _ref2.y,
      w1 = _ref2.width,
      h1 = _ref2.height;
    var x2 = _ref3.x,
      y2 = _ref3.y,
      w2 = _ref3.width,
      h2 = _ref3.height;
    return x2 >= x1 && y2 >= y1 && x2 + w2 <= x1 + w1 && y2 + h2 <= y1 + h1;
  };

  /**
   * Check to see if the two layout intersect at all.
   * @param {{ x: number, y: number, width: number, height: number }} layout1
   * @param {{ x: number, y: number, width: number, height: number }} layout2
   * @returns {boolean}
   */
  exports.layoutsIntersect = function (_ref4, _ref5) {
    var x1 = _ref4.x,
      y1 = _ref4.y,
      w1 = _ref4.width,
      h1 = _ref4.height;
    var x2 = _ref5.x,
      y2 = _ref5.y,
      w2 = _ref5.width,
      h2 = _ref5.height;
    return x1 < x2 + w2 && x2 < x1 + w1 && y1 < y2 + h2 && y2 < y1 + h1;
  };

  /**
   * Get a bounding box (width 1 or height 1) for two points.
   * @param {{x: number, y: number }} p1
   * @param {{x: number, y: number }} p2
   * @returns {{x: number, y: number, width: number, height: number}}
   */
  exports.segmentToBox = function (p1, p2) {
    return exports.boundingBox([p1, p2]);
  };

  /**
   * @param {{ x: number, y: number, width: number, height: number }} box
   * @returns {Array.<{ x: number, y: number }>} array of all points in the box
   */
  exports.allPointsInBox = function (_ref6) {
    var x = _ref6.x,
      y = _ref6.y,
      width = _ref6.width,
      height = _ref6.height;
    var ys = _.range(y, y + height),
      xs = _.range(x, x + width);
    return _.flatten(_.map(ys, function (y) {
      return _.map(xs, function (x) {
        return {
          x: x,
          y: y
        };
      });
    }));
  };

  /**
   * Derive the direction when moving from point 1 to point 2.
   * @param {{x: number, y: number}} p1
   * @param {{x: number, y: number}} p2
   * @returns {string} `U`, `D`, `L`, `R`
   * @throws {Error} if the points are not on a straight line
   */
  exports.toDirection = function (p1, p2) {
    if (p1.x === p2.x) {
      return p2.y > p1.y ? 'D' : 'U';
    } else if (p1.y === p2.y) {
      return p2.x > p1.x ? 'R' : 'L';
    } else {
      throw new Error('diagonal??');
    }
  };

  /**
   * Given a set of points, derive layout data for the smallest bounding box
   * containing all of those points.
   *
   * @param {Array.<{ x: number, y: number }>} points
   * @returns {{x: number, y: number, width: number, height: number}}
   */
  exports.boundingBox = function (points) {
    var xs = _.pluck(points, 'x'),
      ys = _.pluck(points, 'y'),
      minX = Math.min.apply(null, xs),
      minY = Math.min.apply(null, ys),
      maxX = Math.max.apply(null, xs),
      maxY = Math.max.apply(null, ys);
    return {
      x: minX,
      y: minY,
      width: maxX - minX + 1,
      height: maxY - minY + 1
    };
  };

  /**
   * Translate a point by an offset in x and y directions.
   * @param {{ x: number, y: number }} offset
   * @param {{ x: number, y: number }} point
   * @returns {{ x: number, y: number }} the translated point
   */
  exports.translate = function () {
    var _ref7 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref7$x = _ref7.x,
      x = _ref7$x === void 0 ? 0 : _ref7$x,
      _ref7$y = _ref7.y,
      y = _ref7$y === void 0 ? 0 : _ref7$y;
    var point = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
      x: 0,
      y: 0
    };
    return _.extend({}, point, {
      x: point.x + x,
      y: point.y + y
    });
  };

  /**
   * Given a triple representing a link from a `WbViewModel`, find the wixel
   * coordinates of the start and end points for that link. Note that the
   * components represented by the subject and object *must* already have
   * associated layout data.
   *
   * If the start or end points cannot be calculated, their values will be undefined.
   *
   * @param {{ subject: object, predicate: object, object: object }} triple
   * @returns {{start: {x: number, y: number}|undefined, end: {x: number, y: number}|undefined}}
   */
  exports.getLinkStartAndEnd = function (_ref8) {
    var subject = _ref8.subject,
      predicate = _ref8.predicate,
      object = _ref8.object;
    var sourceConnector = predicate.glyph.sourceConnector,
      targetConnector = predicate.glyph.targetConnector;
    return {
      start: exports.getLinkSourceWixel(subject, sourceConnector),
      end: exports.getLinkTargetWixel(object, targetConnector)
    };
  };

  /**
   * Find the wixel to start an outgoing link/knob from a component entity.
   *
   * @param {{ glyph: Object, layout: Object }} entity
   * @param {String} sourceConnector
   * @returns {{x: number, y: number}|undefined} The wixel where the snake
   * should connect to the source component, or undefined if no matching visible
   * bars are found.
   */
  exports.getLinkSourceWixel = function (_ref9, sourceConnector) {
    var glyph = _ref9.glyph,
      layout = _ref9.layout;
    var barIndex = _.findIndex(glyph.bars, function (bar) {
      return bar.id === sourceConnector;
    });
    if (barIndex < 0) {
      return;
    }
    return {
      x: layout.x + layout.width,
      y: layout.y + 2 + barIndex
    };
  };

  /**
   * Find the wixel to end an incoming link/knob to a component entity.
   *
   * @param {{ glyph: Object, layout: Object }} entity
   * @param {String} targetConnector
   * @returns {{x: number, y: number}|undefined} The wixel where the snake
   * should connect to the target component, or undefined if no matching visible
   * bars are found.
   */
  exports.getLinkTargetWixel = function (_ref10, targetConnector) {
    var glyph = _ref10.glyph,
      layout = _ref10.layout;
    var barIndex = _.findIndex(glyph.bars, function (bar) {
      return bar.id === targetConnector;
    });
    if (barIndex < 0) {
      return;
    }
    return {
      x: layout.x - 1,
      y: layout.y + 2 + barIndex
    };
  };
  exports.isUsableWixel = function (mask, glyph, x, y, roadTile) {
    var maskWidth = mask.getWidth(),
      maskHeight = mask.getHeight();
    return x >= 0 && y >= 0 && x < maskWidth && y < maskHeight && roadTile !== -1 &&
    //never allow doubling back
    canCross(mask, glyph, x, y, roadTile);
  };
  exports.getRoadTile = function (lastX, lastY, thisX, thisY, nextX, nextY) {
    if (lastX === nextX && lastY === nextY) {
      return LINK_U_TURN;
    }
    if (Math.abs(lastY - nextY) === 2) {
      return LINK_V;
    }
    if (Math.abs(lastX - nextX) === 2) {
      return LINK_H;
    }
    var lastPoint = {
        x: lastX,
        y: lastY
      },
      thisPoint = {
        x: thisX,
        y: thisY
      },
      nextPoint = {
        x: nextX,
        y: nextY
      };
    switch (exports.toDirection(lastPoint, thisPoint) + exports.toDirection(thisPoint, nextPoint)) {
      case 'DL':
      case 'RU':
        return LINK_L2U;
      case 'DR':
      case 'LU':
        return LINK_R2U;
      case 'UL':
      case 'RD':
        return LINK_L2D;
      case 'UR':
      case 'LD':
        return LINK_R2D;
      default:
        throw new Error();
    }
  };
  exports.validateSchema = function (obj, schemaName) {
    return doRequire([
    // don't pick up on this as a runtime dependency
    'nmodule'.toLowerCase() + '/jsTest/ext/ajv.min', "text!nmodule/wiresheet/rc/wb/schema/".concat(schemaName, ".json")]).then(function (_ref11) {
      var _ref12 = _slicedToArray(_ref11, 2),
        Ajv = _ref12[0],
        jsonText = _ref12[1];
      var ajv = new Ajv({
          verbose: true
        }),
        valid = ajv.validate(JSON.parse(jsonText), obj);
      if (!valid) {
        throw new Error(ajv.errors.map(function (_ref13) {
          var data = _ref13.data,
            message = _ref13.message;
          return "".concat(data, " ").concat(message);
        }).join('\n'));
      }
    });
  };

  /**
   * @param {String} entityId
   * @return {String}
   */
  exports.toBajaId = function (entityId) {
    return entityId.split(':').slice(1).join(':');
  };

  /**
   * @param {String|Object} entity
   * @param {module:nmodule/wiresheet/rc/core/ViewModel} viewModel
   * @return {baja.Ord}
   */
  exports.entityToOrd = function (entity, viewModel) {
    return exports.entityIdToOrd(viewModel.getId(entity));
  };

  /**
   * @param {String} entityId
   * @return {baja.Ord}
   */
  exports.entityIdToOrd = function (entityId) {
    return baja.Ord.make(exports.toBajaId(entityId));
  };

  /**
   * 
   * @param {object} entity 
   * @param {module:nmodule/wiresheet/rc/wb/controller/ThumbnailController} controller
   */
  exports.scrollToEntity = function (entity, controller) {
    var layout = {};
    if (exports.isVertex(entity)) {
      layout = entity.layout;
    } else {
      var subject = entity.subject,
        predicate = entity.predicate,
        object = entity.object,
        _ref14 = predicate || {},
        glyph = _ref14.glyph,
        _ref15 = glyph || {},
        direction = _ref15.direction;
      if (direction === 'in') {
        layout = object.layout || {};
      }
      if (direction === 'out') {
        layout = subject.layout || {};
      }
    }
    var layoutCenter = getCenterCoords(layout);
    controller.scrollTo(layoutCenter.x, layoutCenter.y);
  };
  function canCross(mask, glyph, x, y, roadTile) {
    var tiles = mask.getTiles(x, y),
      sourceId = glyph.sourceId,
      sourceConnector = glyph.sourceConnector,
      targetId = glyph.targetId,
      targetConnector = glyph.targetConnector;
    for (var i = 0, len = tiles.length; i < len; ++i) {
      var _tiles$i = tiles[i],
        entity = _tiles$i.entity,
        tile = _tiles$i.tile,
        otherGlyph = entity.glyph;
      if (otherGlyph.type !== 'SnakeGlyph') {
        return false;
      }
      var sharesSource = sourceId === otherGlyph.sourceId && sourceConnector === otherGlyph.sourceConnector,
        sharesTarget = targetId === otherGlyph.targetId && targetConnector === otherGlyph.targetConnector;
      if (!sharesSource && !sharesTarget) {
        var isSimpleCrossing = roadTile === LINK_V && tile === LINK_H || roadTile === LINK_H && tile === LINK_V;
        if (!isSimpleCrossing) {
          return false;
        }
      }
    }
    return true;
  }
  function round(num, places) {
    var p = Math.pow(10, WIXEL_PRECISION);
    return Math.round(num * p) / p;
  }

  /**
   * Takes the given event and extracts the location info for mouse and touch
   * events.
   *
   * @inner
   * @param {JQuery.Event} event
   * @returns {Object}
   */
  function normalizeEventInfo(event) {
    if (event.touches && event.touches.length === 1) {
      return event.touches[0];
    }
    // `touchend` populates changedTouches and not touches
    if (event.changedTouches && event.changedTouches.length === 1) {
      return event.changedTouches[0];
    }
    return event;
  }
  function getCenterCoords(_ref16) {
    var _ref16$x = _ref16.x,
      x = _ref16$x === void 0 ? 0 : _ref16$x,
      _ref16$y = _ref16.y,
      y = _ref16$y === void 0 ? 0 : _ref16$y,
      _ref16$width = _ref16.width,
      width = _ref16$width === void 0 ? 0 : _ref16$width,
      _ref16$height = _ref16.height,
      height = _ref16$height === void 0 ? 0 : _ref16$height;
    return {
      x: x + width / 2,
      y: y + height / 2
    };
  }
  return exports;
});
