function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/render/themes/WiresheetCssTheme
 */

define(['underscore', 'nmodule/wiresheet/rc/wb/render/themes/WiresheetTheme', 'css!nmodule/wiresheet/rc/wiresheet'], function (_, WiresheetTheme) {
  'use strict';

  /**
   * Extracts information from the styling applied to wiresheet CSS
   * classes and makes it available for wiresheet theme support.
   *
   * @extends {module:nmodule/wiresheet/rc/wb/render/themes/WiresheetTheme}
   */
  var WiresheetCssTheme = /*#__PURE__*/function (_WiresheetTheme) {
    /**
     *
     * @param {String} [rootCssClasses=""] specifies any additional css classes
     * that should be applied to the root for subclasses. The WebWiresheet class
     * will always be present.
     */
    function WiresheetCssTheme() {
      var _this;
      var rootCssClasses = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
      _classCallCheck(this, WiresheetCssTheme);
      _this = _callSuper(this, WiresheetCssTheme);
      var styleCache = createCssClassStyleCache(rootCssClasses);
      _this.$thumbnail = new CssThumbnail(styleCache);
      _this.$canvas = new CssCanvas(styleCache);
      _this.$glyph = new CssGlyph(styleCache);
      return _this;
    }
    _inherits(WiresheetCssTheme, _WiresheetTheme);
    return _createClass(WiresheetCssTheme, [{
      key: "getThumbnail",
      value: function getThumbnail() {
        return this.$thumbnail;
      }
    }, {
      key: "getGlyph",
      value: function getGlyph() {
        return this.$glyph;
      }
    }, {
      key: "getCanvas",
      value: function getCanvas() {
        return this.$canvas;
      }
    }]);
  }(WiresheetTheme);
  /**
   * Extracts thumbnail styles from the loaded css rules.
   *
   * @extends {module:nmodule/wiresheet/rc/wb/render/themes/WiresheetTheme.Thumbnail}
   */
  var CssThumbnail = /*#__PURE__*/function (_WiresheetTheme$Thumb) {
    function CssThumbnail(styleCache) {
      var _this2;
      _classCallCheck(this, CssThumbnail);
      _this2 = _callSuper(this, CssThumbnail);
      _this2.$getStyles = styleCache;
      return _this2;
    }
    _inherits(CssThumbnail, _WiresheetTheme$Thumb);
    return _createClass(CssThumbnail, [{
      key: "getViewportColor",
      value: function getViewportColor() {
        return this.$getStyles("ws-thumb-overlay", "fill");
      }
    }, {
      key: "getOutline",
      value: function getOutline() {
        // Can apply directly to the .ws-thumb-container border property
        return "";
      }
    }, {
      key: "getBackground",
      value: function getBackground() {
        // Can apply directly to the .ws-thumb-container background property
        return "";
      }
    }]);
  }(WiresheetTheme.Thumbnail);
  /**
   * Extracts glyph styles from the loaded css rules.
   *
   * @extends {module:nmodule/wiresheet/rc/wb/render/themes/WiresheetTheme.Glyph}
   */
  var CssGlyph = /*#__PURE__*/function (_WiresheetTheme$Glyph) {
    function CssGlyph(styleCache) {
      var _this3;
      _classCallCheck(this, CssGlyph);
      _this3 = _callSuper(this, CssGlyph);
      _this3.$getStyles = styleCache;
      return _this3;
    }
    _inherits(CssGlyph, _WiresheetTheme$Glyph);
    return _createClass(CssGlyph, [{
      key: "getComponentSelectionOutline",
      value: function getComponentSelectionOutline() {
        return this.$getStyles("ws-component-selection", "stroke");
      }
    }, {
      key: "getComponentOutline",
      value: function getComponentOutline() {
        return this.$getStyles("ws-component-border", "fill");
      }
    }, {
      key: "getComponentTitleBackground",
      value: function getComponentTitleBackground() {
        var image = this.$getStyles("ws-component-title-background", "background-image");
        if (image && image.startsWith('linear-gradient')) {
          return image;
        }
        return this.$getStyles("ws-component-title-background", "fill");
      }
    }, {
      key: "getLinkSelectionBackground",
      value: function getLinkSelectionBackground() {
        return this.$getStyles("ws-path-selected-bg", "stroke");
      }
    }, {
      key: "getLinkSelectionForeground",
      value: function getLinkSelectionForeground() {
        return this.$getStyles("ws-path-selected-fg", "stroke");
      }
    }, {
      key: "getLinkHighlightForeground",
      value: function getLinkHighlightForeground() {
        return this.$getStyles("ws-path-highlight-fg", "stroke");
      }
    }, {
      key: "getLinkHighlightBackground",
      value: function getLinkHighlightBackground() {
        return this.$getStyles("ws-path-highlight-bg", "stroke");
      }
    }, {
      key: "getComponentTitleFont",
      value: function getComponentTitleFont() {
        return getFontStringFromClass("ws-title", this.$getStyles);
      }
    }, {
      key: "getComponentSubtitleFont",
      value: function getComponentSubtitleFont() {
        return getFontStringFromClass("ws-subtitle", this.$getStyles);
      }
    }, {
      key: "getComponentBarFont",
      value: function getComponentBarFont() {
        return getFontStringFromClass("ws-bar-display", this.$getStyles);
      }
    }, {
      key: "getComponentFontColor",
      value: function getComponentFontColor() {
        return this.$getStyles("ws-title", "fill");
      }
    }, {
      key: "getDropOkBackground",
      value: function getDropOkBackground() {
        return this.$getStyles("ws-dropper-bg", "stroke");
      }
    }, {
      key: "getInLinkHighlightBackground",
      value: function getInLinkHighlightBackground() {
        return this.$getStyles("ws-inLink-highlight-bg", "fill");
      }
    }, {
      key: "getOutLinkHighlightBackground",
      value: function getOutLinkHighlightBackground() {
        return this.$getStyles("ws-outLink-highlight-bg", "fill");
      }
    }]);
  }(WiresheetTheme.Glyph);
  /**
   * Extracts canvas styles from the loaded css rules.
   *
   * @extends {module:nmodule/wiresheet/rc/wb/render/themes/WiresheetTheme.Canvas}
   */
  var CssCanvas = /*#__PURE__*/function (_WiresheetTheme$Canva) {
    function CssCanvas(styleCache) {
      var _this4;
      _classCallCheck(this, CssCanvas);
      _this4 = _callSuper(this, CssCanvas);
      _this4.$getStyles = styleCache;
      return _this4;
    }
    _inherits(CssCanvas, _WiresheetTheme$Canva);
    return _createClass(CssCanvas, [{
      key: "getGridColor",
      value: function getGridColor() {
        return this.$getStyles("ws-grid-pattern-rect", "stroke");
      }
    }, {
      key: "getOutline",
      value: function getOutline() {
        // Can apply directly to the .ws-content-inner class
        return "";
      }
    }, {
      key: "getBackground",
      value: function getBackground() {
        // Can apply directly to the .WebWiresheet class
        return "";
      }
    }]);
  }(WiresheetTheme.Canvas);
  function getFontStringFromClass(className, styleCache) {
    var weight = styleCache(className, "font-weight"),
      fontSize = styleCache(className, "font-size"),
      fontFamily = styleCache(className, "font-family");
    return "".concat(weight, " ").concat(fontSize, " ").concat(fontFamily);
  }
  function createCssClassStyleCache(rootCssClasses) {
    return _.memoize(function (className, styleName) {
      var wiresheet = document.createElement('div');
      wiresheet.className = "WebWiresheet ".concat(rootCssClasses);
      var svg = document.createElement('svg');
      svg.className = 'ws-root';
      wiresheet.append(svg);
      var rect = document.createElement('rect');
      rect.className = className;
      svg.appendChild(rect);
      document.body.appendChild(wiresheet);
      var style = getComputedStyle(rect).getPropertyValue(styleName);
      wiresheet.remove();
      return style;
    }, function (className, styleName) {
      return className + styleName;
    });
  }
  return WiresheetCssTheme;
});
