/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

define(['underscore'], function (_) {
  'use strict';

  var styles = {};
  return {
    get: function get(className, style) {
      var stylesForClass = styles[className] || (styles[className] = {});
      if (stylesForClass[style] === undefined) {
        var svg = document.createElement('svg');
        svg.className = 'ws-root';
        var rect = document.createElement('rect');
        svg.appendChild(rect);
        document.body.appendChild(svg);
        stylesForClass[style] = rect.style[style];
        svg.remove();
      }
    }
  };
});
