function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/render/canvas/CanvasThumb
 */
define(['Promise', 'nmodule/wiresheet/rc/wb/WbConstants'], function (Promise, WbConstants) {
  'use strict';

  var BLACK_FILL = 'rgb(0, 0, 0)',
    GRAY_FILL = 'rgb(128, 128, 128)';
  var CanvasThumb = /*#__PURE__*/function () {
    function CanvasThumb(theme) {
      _classCallCheck(this, CanvasThumb);
      this.$theme = theme;
    }

    /**
     * Initialize the canvas for the thumbnail inside of the provided container.
     *
     * @param {JQuery} container
     * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} mask
     * @returns {Promise}
     */
    return _createClass(CanvasThumb, [{
      key: "initialize",
      value: function initialize(container, mask) {
        this.$containerJq = container;
        container.html("\n        <canvas \n          class=\"ws-thumb ws-thumb-entity\"\n          style=\"position: absolute;\" ></canvas>\n        <canvas\n          style=\"position: absolute;\"\n          class=\"ws-thumb ws-thumb-overlay\"></canvas>\n      ");
        container.css("border-color", "".concat(this.$theme.getOutline()));
        container.css("background-color", "".concat(this.$theme.getBackground()));
        this.$entityContext = container.children(".ws-thumb-entity")[0].getContext('2d');
        this.$overlayContext = container.children(".ws-thumb-overlay")[0].getContext('2d');
        this.$updateSize(mask);
        return Promise.resolve();
      }

      /**
       * Paints an overview of all items on the wiresheet in the thumbnail based
       * upon the wixels in the mask. Each wixel is equivalent to one pixel on the
       * thumbnail canvas. This will also paint the overlay for the wiresheet
       * thumbnail that shows the current viewport.
       *
       * This method should not be used if the changes are only needed to the
       * overlay. Use paintOverlay instead in that case.
       *
       * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} mask
       * @param {module:nmodule/wiresheet/rc/typedefs~Layout} viewportBounds
       * represents the bounds of the displayed wiresheet area in wixels.
       */
    }, {
      key: "paint",
      value: function paint(mask, viewportBounds) {
        this.$updateSize(mask);
        this.$paintEntities(mask);
        this.paintOverlay(mask, viewportBounds);
      }

      /**
       * Paints the overlay for the thumbnail that indicates the current viewport
       * within the wiresheet.
       *
       * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} mask
       * @param {module:nmodule/wiresheet/rc/typedefs~Layout} viewportBounds
       * represents the bounds of the displayed wiresheet area in wixels.
       */
    }, {
      key: "paintOverlay",
      value: function paintOverlay(mask, _ref) {
        var x = _ref.x,
          y = _ref.y,
          width = _ref.width,
          height = _ref.height;
        var ctx = this.$overlayContext;
        ctx.clearRect(0, 0, mask.getWidth(), mask.getHeight());
        ctx.beginPath();
        ctx.fillStyle = this.$theme.getViewportColor();
        ctx.fillRect(x, y, width, height);
      }

      /**
       * Paints the entity pixels to the canvas.
       * @private
       * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} mask
       */
    }, {
      key: "$paintEntities",
      value: function $paintEntities(mask) {
        var ctx = this.$entityContext;
        var _mask$getOccupiedSize = mask.getOccupiedSize(),
          width = _mask$getOccupiedSize.width,
          height = _mask$getOccupiedSize.height;
        ctx.clearRect(0, 0, mask.getWidth(), mask.getHeight());
        for (var x = 0; x < width; x++) {
          for (var y = 0; y < height; y++) {
            var tileMask = mask.getTileMask(x, y);
            this.$paintPixel(tileMask, x, y, mask.getWidth(), mask.getHeight());
          }
        }
      }

      /**
       * Paint an individual wixel based upon the provided tile mask.
       *
       * @private
       * @param {Number} tileMask the mask of the current wixel
       * @param {Number} x the x position of the current wixel
       * @param {Number} y the y position of the current wixel
       * @param {Number} width the total width of the wiresheet in wixels
       * @param {Number} height the total height of the wiresheet in wixels
       */
    }, {
      key: "$paintPixel",
      value: function $paintPixel(tileMask, x, y, width, height) {
        var ctx = this.$entityContext;
        if (tileMask) {
          if (tileMask & WbConstants.COMPONENT_OUT) {
            ctx.fillStyle = BLACK_FILL;
          } else {
            ctx.fillStyle = GRAY_FILL;
          }
          ctx.fillRect(x, y, 1, 1);
        }
      }
    }, {
      key: "$updateSize",
      value: function $updateSize(mask) {
        var width = mask.getWidth(),
          height = mask.getHeight(),
          containerJq = this.$containerJq,
          canvasJq = containerJq.find('canvas');
        containerJq.css("width", width);
        containerJq.css("height", height);
        canvasJq.attr("width", width);
        canvasJq.attr("height", height);
        canvasJq.css("width", width);
        canvasJq.css("height", height);
      }
    }]);
  }();
  return CanvasThumb;
});
