/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/layout/LinkStubGlyphLayoutStrategy
 */
define(['underscore', 'nmodule/wiresheet/rc/wb/util/wsUtils'], function (_, wsUtils) {
  'use strict';

  var isEqual = _.isEqual;
  var getLinkSourceWixel = wsUtils.getLinkSourceWixel,
    getLinkTargetWixel = wsUtils.getLinkTargetWixel;

  /**
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/layout/LinkStubGlyphLayoutStrategy
   * @implements module:nmodule/wiresheet/rc/typedefs~EdgeLayoutStrategy
   */
  var StubGlyphLayoutStrategy = function StubGlyphLayoutStrategy() {};

  /**
   * Set the layout of a link stub (always 1x1, placed next to the target slot).
   * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetTriple} triple the
   * triple containing the `StubGlyph`
   * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} mask
   * @returns {boolean} true if the layout was updated
   */
  StubGlyphLayoutStrategy.prototype.update = function (triple, mask) {
    var wixel = getWixel(triple);
    var newLayout;
    if (wixel) {
      var x = wixel.x,
        y = wixel.y;
      newLayout = {
        x: x,
        y: y,
        width: 1,
        height: 1
      };
    }
    var updated = !isEqual(newLayout, triple.predicate.layout);
    triple.predicate.layout = newLayout;
    return updated;
  };
  function getWixel(_ref) {
    var subject = _ref.subject,
      predicate = _ref.predicate,
      object = _ref.object;
    var _predicate$glyph = predicate.glyph,
      direction = _predicate$glyph.direction,
      sourceConnector = _predicate$glyph.sourceConnector,
      targetConnector = _predicate$glyph.targetConnector;
    switch (direction) {
      case 'in':
        return getLinkTargetWixel(object, targetConnector);
      case 'out':
        return getLinkSourceWixel(subject, sourceConnector);
    }
  }
  return StubGlyphLayoutStrategy;
});
