function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*jshint devel: true */
/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/layout/SimpleRoutingStrategy
 */
define(['nmodule/wiresheet/rc/wb/WbConstants', 'nmodule/wiresheet/rc/wb/util/wsUtils'], function (WbConstants, wsUtils) {
  'use strict';

  var LINK_H = WbConstants.LINK_H,
    LINK_V = WbConstants.LINK_V,
    LINK_L2U = WbConstants.LINK_L2U,
    LINK_L2D = WbConstants.LINK_L2D,
    LINK_R2U = WbConstants.LINK_R2U,
    LINK_R2D = WbConstants.LINK_R2D,
    boundingBox = wsUtils.boundingBox,
    getLinkStartAndEnd = wsUtils.getLinkStartAndEnd,
    isUsableWixel = wsUtils.isUsableWixel,
    translate = wsUtils.translate;

  ////////////////////////////////////////////////////////////////
  // SimpleRoutingStrategy
  ////////////////////////////////////////////////////////////////

  /**
   * Strategy for laying out and routing `SnakeGlyph`s. Replicates the
   * simple Workbench routing logic in the `LinkSnakeGlyph` class.
   *
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/layout/SimpleRoutingStrategy
   */
  var SimpleRoutingStrategy = function SimpleRoutingStrategy() {};

  /**
   * Route one link using simple 1, 3, or 5-segment path.
   *
   * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetTriple} triple the
   * triple containing the `SnakeGlyph`
   * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} mask
   * @returns {{ layout: object, segments: Array.<{ x: number, y: number }>}|null}
   * an object with desired `layout` and `segments` properties, or `null` if
   * simple routing was not possible
   */
  SimpleRoutingStrategy.prototype.route = function (triple, mask) {
    var _getLinkStartAndEnd = getLinkStartAndEnd(triple),
      start = _getLinkStartAndEnd.start,
      end = _getLinkStartAndEnd.end;
    if (!start || !end) {
      return null;
    }
    var startX = start.x,
      startY = start.y;
    var endX = end.x,
      endY = end.y;
    var glyph = triple.predicate.glyph;
    var usableWixel = isUsableWixel.bind(null, mask, glyph);
    var segments;
    if (endX > startX) {
      if (startY === endY) {
        segments = routeStraight(start, end, usableWixel);
      } else {
        segments = routeLeftToRight(start, end, usableWixel);
      }
    } else {
      if (startY === endY) {
        //cannot route-around
      } else {
        segments = routeAround(start, end, usableWixel);
      }
    }
    if (segments) {
      var layout = boundingBox(segments);
      return {
        segments: segments.map(translate.bind(null, {
          x: -layout.x,
          y: -layout.y
        })),
        layout: layout
      };
    }
  };

  ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  function routeStraight(start, end, usableWixel) {
    var segments = [start, end];
    return isStraightValid(segments, usableWixel) && segments;
  }
  function routeLeftToRight(_ref, _ref2, usableWixel) {
    var x1 = _ref.x,
      y1 = _ref.y;
    var x2 = _ref2.x,
      y2 = _ref2.y;
    var halfway = Math.floor((x1 + x2) / 2),
      maxOffset = Math.ceil(x2 - x1);
    var getValidSegments = function getValidSegments(bp) {
      var segments = [{
        x: x1,
        y: y1
      }, {
        x: bp,
        y: y1
      }, {
        x: bp,
        y: y2
      }, {
        x: x2,
        y: y2
      }];
      return isLeftToRightValid(segments, usableWixel) && segments;
    };
    for (var offset = 0; offset <= maxOffset; offset++) {
      var segments = getValidSegments(halfway - offset);
      if (segments) {
        return segments;
      }
      segments = offset && getValidSegments(halfway + offset);
      if (segments) {
        return segments;
      }
    }
  }
  function routeAround(_ref3, _ref4, usableWixel) {
    var x1 = _ref3.x,
      y1 = _ref3.y;
    var x2 = _ref4.x,
      y2 = _ref4.y;
    var halfway = Math.floor((y1 + y2) / 2),
      maxOffset = halfway - Math.min(y1, y2);
    var getValidSegments = function getValidSegments(bp) {
      var segments = [{
        x: x1,
        y: y1
      }, {
        x: x1 + 1,
        y: y1
      }, {
        x: x1 + 1,
        y: bp
      }, {
        x: x2 - 1,
        y: bp
      }, {
        x: x2 - 1,
        y: y2
      }, {
        x: x2,
        y: y2
      }];
      return isAroundValid(segments, usableWixel) && segments;
    };
    for (var offset = 0; offset < maxOffset; offset++) {
      var segments = getValidSegments(halfway - offset);
      if (segments) {
        return segments;
      }
      segments = offset && getValidSegments(halfway + offset);
      if (segments) {
        return segments;
      }
    }
  }

  // s--t
  function isStraightValid(_ref5, usableWixel) {
    var _ref6 = _slicedToArray(_ref5, 2),
      s = _ref6[0],
      t = _ref6[1];
    return horizontalRunValid(s.x, t.x, s.y, usableWixel);
  }

  // s--b
  //    |
  //    r--t
  function isLeftToRightValid(_ref7, usableWixel) {
    var _ref8 = _slicedToArray(_ref7, 4),
      s = _ref8[0],
      b = _ref8[1],
      r = _ref8[2],
      t = _ref8[3];
    var down = b.y < r.y;
    return horizontalRunValid(s.x, b.x, s.y, usableWixel) &&
    // s-> b
    usableWixel(b.x, b.y, down ? LINK_L2D : LINK_L2U) &&
    // b
    verticalRunValid(b.y, r.y, b.x, usableWixel) &&
    // b -> r
    usableWixel(r.x, r.y, down ? LINK_R2U : LINK_R2D) &&
    // r
    horizontalRunValid(r.x, t.x, t.y, usableWixel); // r -> t
  }

  //     s--s2
  //         |
  // r-------b
  // |
  // t2--t
  function isAroundValid(_ref9, usableWixel) {
    var _ref10 = _slicedToArray(_ref9, 6),
      s = _ref10[0],
      s2 = _ref10[1],
      b = _ref10[2],
      r = _ref10[3],
      t2 = _ref10[4],
      t = _ref10[5];
    var down = s.y < t.y;
    return usableWixel(s2.x, s2.y, down ? LINK_L2D : LINK_L2U) &&
    // s2
    verticalRunValid(s2.y, b.y, s2.x, usableWixel) &&
    // s2 -> b
    usableWixel(b.x, b.y, down ? LINK_L2U : LINK_L2D) &&
    // b
    horizontalRunValid(b.x, r.x, r.y, usableWixel) &&
    // b -> r
    usableWixel(r.x, r.y, down ? LINK_R2D : LINK_R2U) &&
    // r
    verticalRunValid(r.y, t2.y, r.x, usableWixel) &&
    // r -> t2
    usableWixel(t2.x, t2.y, down ? LINK_R2U : LINK_R2D); // t2
  }
  function horizontalRunValid(x1, x2, y, usableWixel) {
    var xMin = Math.min(x1, x2),
      xMax = Math.max(x1, x2);
    for (var i = xMin + 1; i < xMax; i++) {
      if (!usableWixel(i, y, LINK_H)) {
        return false;
      }
    }
    return true;
  }
  function verticalRunValid(y1, y2, x, usableWixel) {
    var yMin = Math.min(y1, y2),
      yMax = Math.max(y1, y2);
    for (var i = yMin + 1; i < yMax; i++) {
      if (!usableWixel(x, i, LINK_V)) {
        return false;
      }
    }
    return true;
  }
  return SimpleRoutingStrategy;
});
