function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/controller/ops/RubberBandOp
 */
define(['Promise', 'nmodule/wiresheet/rc/wb/util/wsUtils'], function (Promise, wsUtils) {
  'use strict';

  var layoutContainsLayout = wsUtils.layoutContainsLayout,
    isSelectable = wsUtils.isSelectable,
    RUBBER_BAND_ID = 'rubberBand';

  /**
   * This op allows the user to move a rubber band around the wiresheet,
   * selecting all entities within the desired box.
   *
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/controller/ops/RubberBandOp
   * @implements module:nmodule/wiresheet/rc/typedefs~DragOp
   * @param {Object} params
   * @param {number} params.x x coordinate of the start of the rubber band, in wixels
   * @param {number} params.y y coordinate of the start of the rubber band, in wixels
   * @param {module:nmodule/wiresheet/rc/core/ViewModel} params.viewModel
   * @param {module:nmodule/wiresheet/rc/core/controller/Selection} params.selection
   */
  var RubberBandOp = function RubberBandOp(_ref) {
    var origX = _ref.x,
      origY = _ref.y,
      viewModel = _ref.viewModel,
      selection = _ref.selection;
    /**
     * When the user drags around, move the rubber band around and mark those
     * vertices within it as selected.
     *
     * @param {module:nmodule/wiresheet/rc/typedefs~DragOpState} dragOpState
     * @returns {Promise}
     */
    this.update = function (_ref2) {
      var x = _ref2.x,
        y = _ref2.y;
      var deltaX = x - origX,
        deltaY = y - origY;
      var rubberBand = {
        glyph: {
          type: 'RubberBandGlyph'
        },
        layout: {
          x: deltaX > 0 ? origX : origX + deltaX,
          y: deltaY > 0 ? origY : origY + deltaY,
          width: Math.abs(deltaX),
          height: Math.abs(deltaY)
        }
      };
      return Promise.all([viewModel.getVertices(), viewModel.getEdges(), viewModel.put(rubberBand, RUBBER_BAND_ID)]).then(function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 2),
          vertices = _ref4[0],
          edges = _ref4[1];
        var isSelected = function isSelected(v) {
          return isSelectable(v) && inRubberBand(v, rubberBand);
        };
        var toSelect = vertices.filter(isSelected).concat(edges.filter(function (e) {
          return isSelected(e.predicate);
        }));
        return selection.setSelectedEntities(toSelect);
      });
    };

    /**
     * @returns {Promise} noop
     */
    this.commit = function () {
      return Promise.resolve();
    };

    /**
     * When the user is done, just remove the rubber band glyph, as all
     * selections were already made in `update()`.
     * @returns {Promise}
     */
    this.destroy = function () {
      return viewModel.del(RUBBER_BAND_ID);
    };
  };
  function inRubberBand(entity, rubberBand) {
    return layoutContainsLayout(rubberBand.layout, entity.layout);
  }
  return RubberBandOp;
});
