function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/controller/ops/DropperOp
 */
define(['baja!', 'lex!webEditors', 'Promise', 'nmodule/wiresheet/rc/wb/util/wsUtils'], function (baja, lexs, Promise, wsUtils) {
  'use strict';

  var DROPPER_ID = 'dropper';
  var isComponentGlyph = wsUtils.isComponentGlyph;
  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];

  /**
   * This op allows the user to drag a component into the wiresheet
   * with visual indications of the drop.
   *
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/controller/ops/DropperOp
   * @implements module:nmodule/wiresheet/rc/typedefs~DragOp
   * @param {Object} params
   * @param {number} params.x x coordinate of the start of the dropper, in wixels
   * @param {number} params.y y coordinate of the start of the dropper, in wixels
   * @param {number} params.showRelations whether or not to show dropper for
   * relations
   * @param {function} params.setToolTip sets the message displayed
   * @param {function} params.cancelToolTip cancels the message displayed right
   * now
   * @param {module:nmodule/wiresheet/rc/core/ViewModel} params.viewModel
   */
  var DropperOp = function DropperOp(_ref) {
    var _this = this;
    var origX = _ref.x,
      origY = _ref.y,
      viewModel = _ref.viewModel,
      setToolTip = _ref.setToolTip,
      cancelToolTip = _ref.cancelToolTip,
      showRelations = _ref.showRelations;
    var handleToolTipForLinkOrRelation = function handleToolTipForLinkOrRelation(target, direction, connectorType, showRelations) {
      if ((connectorType === 'footer' || connectorType === 'relation') && showRelations) {
        var toolTip = webEditorsLex.get({
          key: direction === 'to' ? 'commands.relateTo.displayName' : 'commands.relateFrom.displayName',
          args: [target]
        });
        setToolTip(toolTip);
      } else {
        var _toolTip = webEditorsLex.get({
          key: direction === 'to' ? 'commands.linkTo.displayName' : 'commands.linkFrom.displayName',
          args: [target]
        });
        setToolTip(_toolTip);
      }
    };

    /**
     * When the user drags around, move the Dropper to position the entity from 
     * its top-left.
     *
     * If over top of a component, this will instead provide a visual indication
     * of a possible link / relation the user can create.
     *
     * @param {module:nmodule/wiresheet/rc/typedefs~DragOpState} dragOpState
     * @returns {Promise}
     */
    this.update = function (_ref2) {
      var x = _ref2.x,
        y = _ref2.y,
        horizontalPosition = _ref2.horizontalPosition,
        entity = _ref2.entity,
        connectorType = _ref2.connectorType;
      var deltaX = x - origX,
        deltaY = y - origY;
      var layout = {
        x: deltaX > 0 ? origX : origX + deltaX,
        y: deltaY > 0 ? origY : origY + deltaY
      };
      if (horizontalPosition === undefined || !isComponentGlyph(entity)) {
        var _dropper = {
          glyph: {
            type: 'DropperGlyph'
          },
          layout: layout
        };
        cancelToolTip();
        return viewModel.put(_dropper, DROPPER_ID);
      }
      var dropper = {
        glyph: {
          type: horizontalPosition === 'left' ? 'DropperInGlyph' : 'DropperOutGlyph'
        },
        layout: layout
      };
      var direction = horizontalPosition === 'left' ? 'to' : 'from';
      handleToolTipForLinkOrRelation(entity.glyph.header.title, direction, connectorType, showRelations);
      return viewModel.put(dropper, DROPPER_ID);
    };

    /**
     * @returns {Promise} noop
     */
    this.commit = function () {
      return _this.destroy();
    };

    /**
     * When the user is done, just remove the dropper glyph.
     * @returns {Promise}
     */
    this.destroy = function () {
      return viewModel.del(DROPPER_ID);
    };
  };
  return DropperOp;
});
