/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/WbController
 */
define(['nmodule/wiresheet/rc/wb/baja/BajaEventHandler'], function (BajaEventHandler) {
  'use strict';

  ////////////////////////////////////////////////////////////////
  // WbViewModel
  ////////////////////////////////////////////////////////////////

  /**
   * `WbController` manages the interactions between BajaScript component
   * events, the wiresheet view model, and the displayed SVG.
   *
   * @class
   * @param {Object} params
   * @param {module:nmodule/wiresheet/rc/wb/WbViewModel} params.viewModel
   * @param {baja.Component} params.component
   * @param {module:nmodule/wiresheet/rc/wb/WbLayoutStrategy} params.layoutStrategy
   */
  var WbController = function WbController(_ref) {
    var viewModel = _ref.viewModel,
      component = _ref.component,
      layoutStrategy = _ref.layoutStrategy;
    var bajaEventHandler = new BajaEventHandler({
      component: component,
      viewModel: viewModel
    });
    this.release = function () {
      bajaEventHandler.release();
    };
    this.initialize = function () {
      return viewModel.initialize().then(function () {
        return layoutStrategy.initialize(viewModel);
      });
    };
  };
  return WbController;
});
