function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/commands/ArrangeCommand
 */

define(['baja!', 'dialogs', 'Promise', 'bajaux/commands/Command', 'lex!wiresheet', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/wiresheet/rc/wb/baja/bajaUtils'], function (baja, dialogs, Promise, Command, lexs, feDialogs, bajaUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    WIRESHEET_LEX = _lexs[0];
  var resolveEntityId = bajaUtils.resolveEntityId;
  var showOkCancel = dialogs.showOkCancel;

  /**
   * @class
   * @memberof module:nmodule/wiresheet/rc/wb/commands/ArrangeCommand
   */
  var ArrangeAllCommand = /*#__PURE__*/function (_Command) {
    function ArrangeAllCommand(arrangeCommand, viewModel) {
      var _this;
      _classCallCheck(this, ArrangeAllCommand);
      return _this = _callSuper(this, ArrangeAllCommand, [{
        module: 'wiresheet',
        lex: 'WebWiresheet.commands.arrange.all',
        func: function func() {
          return _this.$confirmArrangeAll(function () {
            return viewModel.getVertices().then(function (entities) {
              return arrangeCommand.performCommand(entities)["catch"](feDialogs.error);
            });
          });
        },
        undoable: function undoable() {
          return _this.$confirmArrangeAll(function () {
            return viewModel.getVertices().then(function (entities) {
              return arrangeCommand.$makeUndoable(entities);
            });
          });
        }
      }]);
    }

    /**
     * @private
     * @param {Function} func 
     * @returns {Promise}
     */
    _inherits(ArrangeAllCommand, _Command);
    return _createClass(ArrangeAllCommand, [{
      key: "$confirmArrangeAll",
      value: function $confirmArrangeAll(func) {
        // eslint-disable-next-line promise/avoid-new
        return new Promise(function (resolve) {
          showOkCancel({
            title: WIRESHEET_LEX.get('WebWiresheet.commands.arrange.all.confirm.title'),
            content: WIRESHEET_LEX.getSafe('WebWiresheet.commands.arrange.all.confirm.content')
          }).ok(function () {
            return resolve(func());
          }).cancel(function () {
            return resolve(null);
          });
        });
      }
    }]);
  }(Command);
  /**
   * @class
   * @memberof module:nmodule/wiresheet/rc/wb/commands/ArrangeCommand
   */
  var ArrangeSelectedCommand = /*#__PURE__*/function (_Command2) {
    function ArrangeSelectedCommand(arrangeCommand, selection) {
      _classCallCheck(this, ArrangeSelectedCommand);
      return _callSuper(this, ArrangeSelectedCommand, [{
        module: 'wiresheet',
        lex: 'WebWiresheet.commands.arrange.selection',
        func: function func() {
          return arrangeCommand.performCommand(selection.getSelectedVertices()["catch"](feDialogs.error));
        },
        undoable: function undoable() {
          return arrangeCommand.$makeUndoable(selection.getSelectedVertices());
        }
      }]);
    }
    _inherits(ArrangeSelectedCommand, _Command2);
    return _createClass(ArrangeSelectedCommand);
  }(Command);
  /**
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/commands/ArrangeCommand
   */
  return /*#__PURE__*/function () {
    /**
     * 
     * @param {module:nmodule/wiresheet/rc/core/ViewModel} viewModel 
     * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} mask
     * @param {module:nmodule/wiresheet/rc/core/controller/Selection} selection
     */
    function ArrangeCommand(viewModel, mask, selection) {
      _classCallCheck(this, ArrangeCommand);
      this.$mask = mask;
      this.$vm = viewModel;
      this.$arrangeAllCmd = new ArrangeAllCommand(this, viewModel);
      this.$arrangeSelectedCmd = new ArrangeSelectedCommand(this, selection);
    }

    /**
     * @param {Array<object>} entities 
     * @returns {Promise}
     */
    return _createClass(ArrangeCommand, [{
      key: "performCommand",
      value: function performCommand(entities) {
        var _this$$prepEntities = this.$prepEntities(entities, this.$mask),
          xNew = _this$$prepEntities.xNew,
          yNew = _this$$prepEntities.yNew;
        return this.$setAnnotations(xNew, yNew, entities, this.$vm);
      }

      /**
       * @returns {module:nmodule/wiresheet/rc/wb/commands/ArrangeCommand.ArrangeAllCommand}
       */
    }, {
      key: "getArrangeAllCommand",
      value: function getArrangeAllCommand() {
        return this.$arrangeAllCmd;
      }

      /**
       * @returns {module:nmodule/wiresheet/rc/wb/commands/ArrangeCommand.ArrangeSelectedCommand}
       */
    }, {
      key: "getArrangeSelectedCommand",
      value: function getArrangeSelectedCommand() {
        return this.$arrangeSelectedCmd;
      }

      /**
       * @private
       * @param {Array<object>} entities 
       * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} mask 
       * @returns {object} with 'xOld', 'yOld', 'xNew' and 'yNew'
       */
    }, {
      key: "$prepEntities",
      value: function $prepEntities(entities, mask) {
        var x = 1,
          y = 1,
          maxw = 0,
          xOld = [],
          yOld = [],
          xNew = [],
          yNew = [];
        var width = mask.getWidth(),
          height = mask.getHeight();
        entities.forEach(function (_ref) {
          var layout = _ref.layout;
          xOld.push(layout.x);
          yOld.push(layout.y);
          var w = layout.width,
            h = layout.height;

          // Check if it fits the current column  
          if (y + h < height) {
            xNew.push(x);
            yNew.push(y);
            maxw = Math.max(maxw, w);
          } else {
            // wrap to next column
            x = x + maxw + 1;
            if (x + 6 > width) {
              x = 1;
            }
            y = 1;
            xNew.push(x);
            yNew.push(y);
            maxw = w;
          }
          y += h + 1;
        });
        return {
          xOld: xOld,
          yOld: yOld,
          xNew: xNew,
          yNew: yNew
        };
      }

      /**
       * 
       * @private
       * @param {Array<object>} entities 
       * @returns {object}
       */
    }, {
      key: "$makeUndoable",
      value: function $makeUndoable(entities) {
        var _this2 = this;
        var _this$$prepEntities2 = this.$prepEntities(entities, this.$mask),
          xOld = _this$$prepEntities2.xOld,
          yOld = _this$$prepEntities2.yOld,
          xNew = _this$$prepEntities2.xNew,
          yNew = _this$$prepEntities2.yNew;
        return {
          undo: function undo() {
            return _this2.$setAnnotations(xOld, yOld, entities, _this2.$vm)["catch"](feDialogs.error);
          },
          redo: function redo() {
            return _this2.$setAnnotations(xNew, yNew, entities, _this2.$vm)["catch"](feDialogs.error);
          }
        };
      }

      /**
       * @private
       * @param {*} xs 
       * @param {*} ys 
       * @param {*} entities 
       * @returns {Promise}
       */
    }, {
      key: "$setAnnotations",
      value: function $setAnnotations(xs, ys, entities) {
        return toBajaValues(entities, this.$vm).then(function (values) {
          var p = [];
          entities.forEach(function (_ref2, i) {
            var layout = _ref2.layout;
            var width = layout.width,
              height = layout.height;
            var anno = baja.$('baja:WsAnnotation', xs[i], ys[i], width, height);
            var value = values[i];
            if (value.has('wsAnnotation')) {
              p.push(value.set({
                slot: 'wsAnnotation',
                value: anno
              }));
            } else {
              p.push(value.add({
                slot: 'wsAnnotation',
                value: anno,
                flags: baja.Flags.READONLY
              }));
            }
          });
          return Promise.all(p);
        });
      }
    }]);
  }();

  /**
   * @param {Array.<object>} entities vertices
   * @param {module:nmodule/wiresheet/rc/core/ViewModel} viewModel
   * @returns {Promise.<Array.<baja.Value>>}
   */
  function toBajaValues(entities, viewModel) {
    return Promise.all(entities.map(function (entity) {
      var id = viewModel.getId(entity.predicate || entity);
      return resolveEntityId(id, {
        base: viewModel.$container
      });
    }));
  }
});
