function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['baja!', 'Promise', 'underscore'], function (baja, Promise, _) {
  'use strict';

  var ordAsId = false;

  /**
   * API Status: **Private**
   *
   * BajaScript-specific utility functions for use in various wiresheet modules.
   *
   * @exports nmodule/wiresheet/rc/wb/baja/bajaUtils
   */
  var exports = {};

  /**
   * @param {baja.Component} comp
   * @param {object} [params]
   * @param {boolean} [params.useOrd] true to use the nav ord as the ID instead
   * of the handle (for testing)
   * @returns {string}
   */
  exports.componentToId = function (comp) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref$useOrd = _ref.useOrd,
      useOrd = _ref$useOrd === void 0 ? ordAsId : _ref$useOrd;
    if (useOrd) {
      var navOrd = comp.$cachedNavOrd || comp.getNavOrd().relativizeToSession();
      // if a component is removed, its nav ord becomes null - cache it so removals still work
      if (navOrd) {
        comp.$cachedNavOrd = navOrd;
      }
      return 'component:' + navOrd;
    } else {
      return 'component:h:' + comp.getHandle();
    }
  };

  /**
   * Find the `Link` on the target component that matches up to the source knob.
   *
   * @param {baja.Component} comp - target component
   * @param {Object} knob - knob on source component
   * @param {object} params
   * @param {baja.Component} params.base a base to use when resolving ORDs (the
   * source ORD of each link on the target component may have to be resolved to
   * find the one pointing at the knob's component)
   * @param {boolean} [params.useOrd] true if using nav ORDs as ViewModel ids
   * @returns {Promise.<baja.Struct|undefined>} the matching `baja:Link`
   */
  exports.getLink = function (comp, knob, params) {
    var sourceSlot = knob.getSourceSlotName();
    var targetSlot = knob.getTargetSlotName();
    var links = comp.getLinks();
    var sourceOrds = links.map(function (link) {
      return link.get('sourceOrd');
    });
    var sourceId = exports.componentToId(knob.getSourceComponent(), params);
    return Promise.all(sourceOrds.map(function (ord) {
      return exports.ordToComponentId(ord, params);
    })).then(function (sourceIds) {
      return _.find(links, function (link, i) {
        return sourceIds[i] === sourceId && link.get('sourceSlotName') === sourceSlot && link.get('targetSlotName') === targetSlot;
      });
    });
  };

  /**
   * Find the `Relation` on the source component that matches up to the target
   * relation knob.
   *
   * @param {baja.Component} comp - source component
   * @param {Object} relationKnob - relation knob on target component
   * @param {object} params
   * @param {baja.Component} params.base a base to use when resolving ORDs (the
   * target ORD of each relation on the source component may have to be resolved
   * to find the one pointing at the knob's component)
   * @param {boolean} [params.useOrd] true if using nav ORDs as ViewModel ids
   * @returns {Promise.<baja.Struct|undefined>} the matching `baja:Relation`
   */
  exports.getRelation = function (comp, relationKnob, params) {
    var targetComponent = relationKnob.getEndpointComponent();
    var relationId = relationKnob.getRelationId();
    var relations = comp.getSlots().is('baja:Relation').toValueArray().filter(exports.isRelation);
    var targetOrds = relations.map(function (r) {
      return r.getSourceOrd();
    });
    var targetId = exports.componentToId(targetComponent, params);
    return Promise.all(targetOrds.map(function (ord) {
      return exports.ordToComponentId(ord, params);
    })).then(function (targetIds) {
      return _.find(relations, function (relation, i) {
        return targetIds[i] === targetId && relation.getRelationId() === relationId;
      });
    });
  };

  /**
   * Find the knob on the source component that matches up to the target link.
   *
   * @param {baja.Component} comp - source component
   * @param {baja.Struct} link - `baja:Link` on target component
   * @returns {Object|undefined} the matching knob
   */
  exports.getKnob = function (comp, link) {
    var sourceSlot = link.get('sourceSlotName'),
      targetSlot = link.get('targetSlotName');
    return _.find(comp.getKnobs(), function (knob) {
      return sourceSlot === knob.getSourceSlotName() && targetSlot === knob.getTargetSlotName();
    });
  };

  /**
   * Get the relation knob on the target component that matches up with the
   * source relation.
   *
   * @param {baja.Component} comp - target component
   * @param {baja.Struct} relation - `baja:Relation` on source component
   * @returns {Object|null}
   */
  exports.getRelationKnob = function (comp, relation) {
    return comp.getRelationKnob(relation.getRelationId());
  };

  /**
   * @param {*} comp
   * @returns {boolean} true if object is a `baja:Component`
   */
  exports.isComponent = function (comp) {
    return baja.hasType(comp, 'baja:Component');
  };

  /**
   * @param {*} link
   * @returns {boolean} true if object is a `baja:Link`
   */
  exports.isLink = function (link) {
    return baja.hasType(link, 'baja:Link');
  };

  /**
   * @param {*} knob
   * @returns {boolean} true if object is a Knob
   */
  exports.isKnob = function (knob) {
    return knob && !baja.hasType(knob) && _.isFunction(knob.getSourceSlotName) && _.isFunction(knob.getSourceComponent);
  };

  /**
  * @param {*} relation
   * @returns {boolean} true if object is a `baja:Relation` (and not a Link)
   */
  exports.isRelation = function (relation) {
    return relation && baja.hasType(relation, 'baja:Relation') && !baja.hasType(relation, 'baja:Link');
  };

  /**
   * @param {*} relationKnob
   * @returns {boolean} true if object is a relation knob
   */
  exports.isRelationKnob = function (relationKnob) {
    return relationKnob && _.isFunction(relationKnob.getRelationId) && _.isFunction(relationKnob.getEndpointComponent);
  };

  /**
   * @param {*} textBlock
   * @returns {boolean} true if object is a `baja:WsTextBlock`
   */
  exports.isTextBlock = function (textBlock) {
    return baja.hasType(textBlock, 'baja:WsTextBlock');
  };

  /**
   * @param {*} vector
   * @returns {boolean} true if the object is a `baja:Vector`
   */
  exports.isVector = function (vector) {
    return baja.hasType(vector, 'baja:Vector');
  };

  /**
   * Convert an ORD to a component ID usable in a ViewModel. Typically this will
   * just be handle ORDs: `h:123` becomes `component:123` but station/slot ords
   * will be resolved and the option of using nav ORDs as IDs is available (for
   * testing). Compare with `WsController#toComponentGlyph`.
   *
   * @param {baja.Ord} ord
   * @param {object} [params]
   * @param {baja.Component} [params.base] use as a base in case a `slot` ord
   * needs to resolve
   * @param {boolean} [params.useOrd] if true, the whole ORD will be used as the
   * ID instead of the handle. Slower but can actually be debugged by a human.
   * @returns {Promise.<string>}
   */
  exports.ordToComponentId = function (ord) {
    var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      base = _ref2.base,
      _ref2$useOrd = _ref2.useOrd,
      useOrd = _ref2$useOrd === void 0 ? ordAsId : _ref2$useOrd;
    if (ord === baja.Ord.DEFAULT) {
      return Promise.resolve("null");
    }
    if (useOrd) {
      return ord.get({
        base: base
      }).then(function (comp) {
        return 'component:' + comp.getNavOrd().relativizeToSession();
      });
    }
    try {
      ord = baja.Ord.make(ord).relativizeToSession();
    } catch (cannotParse) {
      return Promise.resolve('component:' + ord);
    }
    var ordStr = String(ord);
    if (ordStr.startsWith('h:')) {
      return Promise.resolve('component:' + ordStr);
    } else if (ordStr.startsWith('slot:') || ordStr.startsWith('station:')) {
      //TODO: OrdCoalescer
      return ord.get({
        base: base
      }).then(function (comp) {
        return 'component:h:' + comp.getHandle();
      })["catch"](function (ignore) {
        return 'component:' + ord;
      });
    } else {
      return Promise.reject(new Error('cannot convert ord ' + ord + ' to component id'));
    }
  };

  /**
   * @param {string} entityId an entity ID from a ViewModel, like
   * `component:h:abc` or `link:def.in10`
   * @param {baja.Component} base base to resolve ORDs against
   * @returns {Promise.<baja.Value>} the baja value represented by this entity
   */
  exports.resolveEntityId = function (entityId) {
    var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      base = _ref3.base,
      lease = _ref3.lease;
    entityId = entityId || '';
    var match = entityId.match(/^component:(.+)/);
    if (match) {
      var _match = match,
        _match2 = _slicedToArray(_match, 2),
        ord = _match2[1];
      return baja.Ord.make(ord).get({
        base: base,
        lease: lease
      });
    }
    match = entityId.match(/^(relation|link):([^.]+)\.([^.]+)/);
    if (match) {
      var _match3 = match,
        _match4 = _slicedToArray(_match3, 4),
        componentId = _match4[2],
        slot = _match4[3];
      return exports.resolveEntityId(componentId, {
        base: base,
        lease: true
      }).then(function (comp) {
        return comp.get(slot);
      });
    }

    // Try to match knob
    match = entityId.match(/^(knob):([^.]+)\.([^.]+)->component:([^.]+)\.([^.]+)/);
    if (match) {
      var _match5 = match,
        _match6 = _slicedToArray(_match5, 6),
        srcId = _match6[2],
        ss = _match6[3],
        targetId = _match6[4],
        ts = _match6[5];
      // If matched return the Knob object on the source
      return exports.resolveEntityId(srcId, {
        base: base,
        lease: true
      }).then(function (srcComp) {
        var knobs = srcComp.getKnobs().filter(function (knob) {
          return knob.getSourceSlotName() === ss && knob.getTargetSlotName() === ts;
        });
        if (knobs.length < 2) {
          return knobs[0];
        } else {
          var filteredKnobs = knobs.filter(function (knob) {
            return targetId === String(knob.getTargetOrd());
          });
          if (filteredKnobs.length > 0) {
            return filteredKnobs[0];
          } else {
            //if targetOrd does not match anything, just fallback to the first knob (this is unlikely)
            return knobs[0];
          }
        }
      });
    }

    // Try to match relation knob
    match = entityId.match(/^(relationKnob):component:([^.]+)-<([^.]+:[^.]+)>-([^.]+)/);
    if (match) {
      var _match7 = match,
        _match8 = _slicedToArray(_match7, 5),
        relationOrd = _match8[2],
        rDisplayId = _match8[3],
        trgId = _match8[4];
      // If matched then return the RelationKnob object on the target
      return exports.resolveEntityId(trgId, {
        base: base,
        lease: true
      }).then(function (trgComp) {
        var relationKnobs = trgComp.getRelationKnobs().filter(function (relationKnob) {
          return relationKnob.getRelationId() === rDisplayId;
        });
        if (relationKnobs.length < 2) {
          return relationKnobs[0];
        } else {
          var filteredRelationKnobs = relationKnobs.filter(function (relationKnob) {
            return relationOrd === String(relationKnob.getRelationOrd());
          });
          if (filteredRelationKnobs.length > 0) {
            return filteredRelationKnobs[0];
          } else {
            //if source does not match anything, just fallback to the first knob (this is unlikely)
            return relationKnobs[0];
          }
        }
      });
    }
    return Promise.reject(new Error('malformed entity id: ' + entityId));
  };
  exports.addAnnotation = function (addCmd, x, y) {
    var width = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 8;
    var height = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
    var anno = baja.$('baja:WsAnnotation', x, y, width, height);
    var _invoke = addCmd.invoke;
    addCmd.invoke = function (params) {
      return _invoke.call(addCmd, _.extend({
        properties: {
          wsAnnotation: anno
        }
      }, params));
    };
    return addCmd;
  };
  exports.addOrigin = function (transferCmd, x, y) {
    var width = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 8;
    var _invoke = transferCmd.invoke;
    transferCmd.invoke = function (params) {
      return _invoke.call(transferCmd, _.extend({
        origin: "".concat(x, ",").concat(y, ",").concat(width)
      }, params));
    };
    return transferCmd;
  };

  /**
   * Resolves a set of parameters into the target value to help with selection.
   * Specifically useful while hyperlinking or navigating to a bookmarked wiresheet
   *
   * @param {module:nmodule/wiresheet/rc/wb/baja/bajaUtils~SelectionParams} params
   * @param {baja.Component} [params.base]
   * @returns {Promise.<undefined|Array>} the first item in the array is the desired item, 
   * the other items to help with ensuring all Stubs are Selected if one Stub to the same slot is selected
   */
  exports.paramsToValues = function () {
    var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      sHandle = _ref4.sHandle,
      sSlot = _ref4.sSlot,
      tHandle = _ref4.tHandle,
      tSlot = _ref4.tSlot,
      selectedType = _ref4.selectedType,
      _ref4$base = _ref4.base,
      base = _ref4$base === void 0 ? baja.station : _ref4$base;
    if (!sHandle && !sSlot && !tHandle && !tSlot && !selectedType) {
      return Promise.resolve();
    }
    if (selectedType) {
      switch (selectedType) {
        case 'link':
          return baja.Ord.make('h:' + tHandle).get({
            base: base,
            lease: true
          }).then(function (c) {
            var links = c.getLinks(tSlot);
            var primary = links.find(function (l) {
              return l.getTargetSlotName() === tSlot && l.getSourceSlotName() === sSlot;
            });
            var others = links.filter(function (l) {
              return l !== primary;
            });
            return [primary].concat(_toConsumableArray(others));
          });
        case 'knob':
          return baja.Ord.make('h:' + sHandle).get({
            base: base,
            lease: true
          }).then(function (c) {
            var knobs = c.getKnobs(sSlot);
            var primary = knobs.find(function (knob) {
              return knob.getTargetSlotName() === tSlot && knob.getSourceSlotName() === sSlot;
            });
            var others = knobs.filter(function (l) {
              return l !== primary;
            });
            return [primary].concat(_toConsumableArray(others));
          });
        case 'relation':
          return baja.Ord.make('h:' + sHandle).get({
            base: base,
            lease: true
          }).then(function (c) {
            return c.getSlots().toValueArray().filter(function (val) {
              return exports.isRelation(val) && val.getRelationId() === tSlot;
            });
          });
        case 'relationKnob':
          return baja.Ord.make('h:' + tHandle).get({
            base: base,
            lease: true
          }).then(function (c) {
            var relationKnobs = c.getRelationKnobs();
            return relationKnobs.filter(function (relationKnob) {
              return relationKnob.getRelationId() === tSlot;
            });
          });
      }
    } else {
      if (tHandle) {
        return baja.Ord.make('h:' + tHandle).get({
          base: base,
          lease: true
        }).then(function (value) {
          return [value];
        });
      }
      return Promise.resolve();
    }
  };

  /**
   * When hyperlinking to a wiresheet, the user may want a component to be
   * preselected. These parameters go in the view query and specify which
   * component to preselect when the wiresheet is loaded.
   *
   * @typedef {object} module:nmodule/wiresheet/rc/wb/baja/bajaUtils~SelectionParams
   * @property {String} sHandle handle of the source component
   * @property {String} sSlot source slot
   * @property {String} tHandle handle of the target component
   * @property {String} tSlot source slot
   * @property {String} selectedType 'link', 'knob', 'relation' or 'relationKnob'
   */

  return exports;
});
