/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define([], function () {
  'use strict';

  /**
   * API Status: **Private**
   * @exports nmodule/wiresheet/rc/wb/WbConstants
   */
  var exports = {};

  /**
   * The width/height of one wiresheet wixel, in pixels.
   * @type {number}
   */
  exports.WIXEL = 12;

  /** horizontal */
  exports.LINK_H = 0x001;

  /** vertical */
  exports.LINK_V = 0x002;

  /** target stub */
  exports.LINK_STUB_T = 0x004;

  /** source stub */
  exports.LINK_STUB_S = 0x008;

  /** horizontal cross */
  exports.LINK_HX = exports.LINK_H | exports.LINK_V;

  /** vertical cross */
  exports.LINK_VX = exports.LINK_H | exports.LINK_V;

  /** left to up */
  exports.LINK_L2U = 0x040;

  /** left to down */
  exports.LINK_L2D = 0x080;

  /** right to up */
  exports.LINK_R2U = 0x100;

  /** right to down */
  exports.LINK_R2D = 0x200;

  /** component outline */
  exports.COMPONENT_OUT = 0x400;

  /** component fill */
  exports.COMPONENT_IN = 0x800;
  exports.LINK_U_TURN = -1;

  /**
   * The padding to give the wiresheet beyond the last occupied wixel.
   *
   * @type {number}
   */
  exports.WIXEL_PADDING = 60;
  exports.LINK_COLOR_NORMAL = 0;
  exports.LINK_COLOR_LON = 1;
  exports.LINK_COLOR_RELATION = 2;

  /**
   * Defaults for user configurable wiresheet options
   * 
   * @type {Object}
   */
  exports.DEFAULT_USER_OPTIONS = {
    SHOW_GRID: true,
    SHOW_STATUS_COLORS: true,
    SHOW_THUMBNAIL: true,
    SHOW_LINKS: true,
    SHOW_RELATIONS: true,
    THUMBNAIL_X: -5,
    THUMBNAIL_Y: 5,
    LINK_HIGHLIGHTING: true,
    MAX_WIDTH: 600,
    MAX_HEIGHT: 600
  };

  /** Wiresheet view parameters */
  exports.NAV_SOURCE_HANDLE = 'sHandle';
  exports.NAV_SOURCE_SLOT = 'sSlot';
  exports.NAV_TARGET_HANDLE = 'tHandle';
  exports.NAV_TARGET_SLOT = 'tSlot';

  /** 
   * This is the default minimum mask height/width in wixels.
   * @type {Number}
   */
  exports.DEFAULT_MIN_DIMENSION = 120;

  /** 
   * This is the usable minimum mask height/width in wixels
   * after factoring in the edge padding and WIXEL width.
   * 120 (min height/width), 10 (edge padding) and 12 (WIXEL)
   * @type {Number}
   */
  exports.USABLE_MIN_DIMENSION = Math.round(exports.DEFAULT_MIN_DIMENSION + (exports.WIXEL + 10) / exports.WIXEL);
  return exports;
});
