/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview SaveButton class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'lex!mobile', 'jquery', 'jquerymobile', 'Promise', 'mobile/px/widgets/Button', 'mobile/util/mobile/dialogs', 'bajaux/events'], function (baja, lexs, $, jqm, Promise, Button, dialogs, events) {
  "use strict";

  var callSuper = baja.callSuper,
    mobileLex = lexs[0];

  /**
   * @class SaveButton
   *
   * The Widget that represents Niagara's 'kitPx:SaveButton' Type.
   *
   * @name SaveButton
   * @extends Button
   */
  function SaveButton() {
    callSuper(SaveButton, this, arguments);
  }
  baja.subclass(SaveButton, Button);
  function updateEnabled(propName) {
    return propName === "enabled";
  }

  /**
   * Append the Widget's DOM content onto the specified DOM element.
   *
   * @param {Object} dom DOM element to append content too.
   */
  SaveButton.prototype.load = function (dom) {
    callSuper("load", SaveButton, this, arguments);
    var that = this,
      throttledFunc = baja.throttle(function () {
        that.update(updateEnabled)["catch"](baja.error);
      }, 1000);

    // Respond to editor change or saved events    
    this.getRootContainer().getDomElement().on(events.MODIFY_EVENT + ' ' + events.SAVE_EVENT, throttledFunc);
  };

  /**
   * Append the Widget's DOM content onto the specified DOM element.
   *
   * @name SaveButton#update
   * @function
   *
   * @param {Function} hasUpdate
   */
  SaveButton.prototype.doUpdate = function (hasUpdate) {
    var that = this;

    //doUpdate on Button looks at 'enabled' slot, so set it first
    if (hasUpdate("enabled")) {
      that.setEnabled(that.getRootContainer().isWidgetTreeModified());
    }
    return Promise.resolve(callSuper("doUpdate", SaveButton, that, arguments)).then(function () {
      if (hasUpdate("text")) {
        // The text always says save
        that.setText(mobileLex.get("save"));
      }
    });
  };

  /**
   * Handle a UI Widget event.
   */
  SaveButton.prototype.doHandleEvent = function (eventName) {
    // For each modifyable Widget, save the changes
    this.getRootContainer().saveWidgets()["catch"](dialogs.error);

    // Return true so the event doesn't filter down to the bindings
    return true;
  };
  return SaveButton;
});
