/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview IBooleanToSimple class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/px/converters/Converter'], function (baja, Converter) {
  "use strict";

  /**
   * @class BIBoolean To Simple Converter.
   * 
   * A Component that represents a Niagara 'converters:BIBooleanToSimple' Type.
   * 
   * Please note, this doesn't work properly since BajaScript Components don't have
   * properly implement BIBoolean like their Java counterparts.
   *
   * @name IBooleanToSimple
   * @extends Converter
   */
  function IBooleanToSimple() {
    baja.callSuper(IBooleanToSimple, this, arguments);
  }
  baja.subclass(IBooleanToSimple, Converter);

  /**
   * Convert the first object to the second object and return the result.
   *
   * @param {baja.Object} from.
   * @param {baja.Object} to.
   * @param {OrdTarget} target.
   * @returns {Boolean} the converter's `trueValue` or `falseValue` depending
   * on the converted object's boolean value
   */
  IBooleanToSimple.prototype.convert = function (from, to, target) {
    var bool = Boolean.getBooleanFromIBoolean(from);
    return bool ? this.getTrueValue() : this.getFalseValue();
  };
  return IBooleanToSimple;
});
