function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/* eslint-env browser */

/**
* API Status: **Private**
* @module nmodule/bajaui/rc/ux/shape/Shape
*/
define(['baja!', 'baja!gx:Pen', 'bajaux/spandrel', 'Promise'], function (baja, types, spandrel, Promise) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-shape',
        fill: baja.$('gx:Brush', 'null'),
        stroke: baja.$('gx:Brush', 'null'),
        enabled: true,
        visible: true,
        pen: baja.$('gx:Pen')
      }
    };
  };
  return /*#__PURE__*/function (_spandrel) {
    function Shape(params) {
      _classCallCheck(this, Shape);
      return _callSuper(this, Shape, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * Allow Shape implementation to return its content to append
     * 
     * @abstract
     * @returns {Element} to append to the base Shape
     */
    _inherits(Shape, _spandrel);
    return _createClass(Shape, [{
      key: "renderContents",
      value: function renderContents() {
        throw new Error('Not implemented');
      }

      /**
       * 
       * @returns {module:bajaux/Widget|undefined}
       */
    }, {
      key: "getShapeSvg",
      value: function getShapeSvg() {
        return this.queryWidget(0);
      }

      /**
       * Returns the transform element
       * 
       * @returns {Element}
       */
    }, {
      key: "getTransformEl",
      value: function getTransformEl() {
        return this.getShapeSvg().jq().children('g')[0];
      }

      /**
       * Get the shape element of this svg.
       * Returns the line, rect, path, etc svg element
       *
       * @abstract
       * @param {Element} element the element to search for the shape
       * @returns {Element}
       */
    }, {
      key: "getShapeEl",
      value: function getShapeEl(element) {
        throw new Error('Not implemented');
      }

      /**
       * Apply fill, stroke and pen properties to the shape.
       * Subclasses may override this to apply any specific properties applicable.
       * 
       * @param {Element} svg the svg element
       * @param {Element} shape the shape element
       *
       * @returns {Promise}
       */
    }, {
      key: "applyProps",
      value: function applyProps(svg, shape) {
        if (svg && shape) {
          var fill = this.properties().getValue('fill'),
            stroke = this.properties().getValue('stroke'),
            pen = this.properties().getValue('pen'),
            transformParams = this.$transformParams;
          return Promise.all([fill.applyFillToSvgElement(shape, svg, transformParams), stroke.applyStrokeToSvgElement(shape, svg, transformParams), pen.applyToSvgElement(shape)]);
        }
        return Promise.resolve();
      }

      /**
       * Apply shape attributes (again) giving a chance to styles like gradients that 
       * need a well laid out structure to work on.
       * 
       * @returns {Promise}
       * 
       */
    }, {
      key: "doLayout",
      value: function doLayout() {
        var svg = this.getShapeSvg(),
          svgElem = svg && svg.jq()[0],
          shape = this.getShapeEl(svgElem);
        if (svg && shape) {
          return this.applyProps(svgElem, shape);
        }
      }
    }]);
  }(spandrel(function (model, _ref) {
    var rootElement = _ref.rootElement;
    var shapeSvg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'),
      transformSvg = document.createElementNS('http://www.w3.org/2000/svg', 'g');
    rootElement.classList.add('hxpx-graphics');
    shapeSvg.setAttribute('height', '100%');
    shapeSvg.setAttribute('width', '100%');
    transformSvg.setAttribute('transform', 'translate(0.5, 0.5)');
    var content = this.renderContents();
    var shape = this.getShapeEl(content);
    return this.applyProps(shapeSvg, shape).then(function () {
      shapeSvg.appendChild(transformSvg);
      transformSvg.appendChild(content);
      return shapeSvg;
    });
  }));
});
