function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/UxCommandButton
 */
define(['baja!', 'baja!gx:Image', 'log!nmodule.bajaui.rc.ux.UxCommandButton', 'Promise', 'underscore', 'bajaux/events', 'bajaux/spandrel', 'bajaux/commands/Command', 'nmodule/bajaui/rc/model/UxModelSupport', 'nmodule/bajaui/rc/ux/Button'], function (baja, types, log, Promise, _, events, spandrel, Command, UxModelSupport, Button) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-Button ux-UxCommandButton'
      }
    };
  };
  var logSevere = log.severe.bind(log);
  var COMMAND_CHANGE_EVENT = events.command.CHANGE_EVENT;

  /**
   * UxCommandButton is a Widget for a Button that can load a `bajaux/commands/Command`.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/ux/UxCommandButton
   * @extends module:nmodule/bajaui/rc/ux/Button
   */
  return /*#__PURE__*/function (_spandrel) {
    function UxCommandButton(params) {
      var _this;
      _classCallCheck(this, UxCommandButton);
      _this = _callSuper(this, UxCommandButton, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      UxModelSupport(_this);
      return _this;
    }
    _inherits(UxCommandButton, _spandrel);
    return _createClass(UxCommandButton, [{
      key: "doLoad",
      value: function doLoad() {
        this.$setupCommand(this.value());
        return _superPropGet(UxCommandButton, "doLoad", this, 3)(arguments);
      }

      /**
       * @param {module:bajaux/commands/Command|Object} cmd
       */
    }, {
      key: "$setupCommand",
      value: function $setupCommand(cmd) {
        var _this2 = this;
        if (!cmd) {
          return;
        }
        var changeHandler = this.$changeHandler;
        if (changeHandler) {
          this.$lastCommand.off(COMMAND_CHANGE_EVENT, changeHandler);
        }
        this.$lastCommand = cmd;
        cmd.on(COMMAND_CHANGE_EVENT, this.$changeHandler = function () {
          _this2.setEnabled(cmd.isEnabled() && !_this2.isReadonly())["catch"](logSevere);
        });
        var commandEnabled = cmd.isEnabled(),
          readonly = this.isReadonly();
        if (readonly === !commandEnabled) {
          return;
        }
        this.setEnabled(commandEnabled && !readonly)["catch"](logSevere);
      }

      /**
       * @param {JQuery.Event} e
       * @returns {Promise}
       */
    }, {
      key: "doInvokeAction",
      value: function doInvokeAction(e) {
        var _arguments = arguments,
          _this3 = this;
        var command = this.value();
        var doCommand = function doCommand() {
          if (!command) {
            return Promise.resolve();
          }
          if (_.isFunction(command.invokeFromEvent)) {
            return Promise.resolve(command.invokeFromEvent(e));
          }
          return command.invoke();
        };
        return doCommand().then(function () {
          return _superPropGet(UxCommandButton, "doInvokeAction", _this3, 3)(_arguments);
        });
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        var cmd = this.$lastCommand;
        if (cmd && this.$changeHandler) {
          cmd.off(COMMAND_CHANGE_EVENT, this.$changeHandler);
          this.$lastCommand = undefined;
          this.$changeHandler = undefined;
        }
        return _superPropGet(UxCommandButton, "doDestroy", this, 3)(arguments);
      }
    }]);
  }(spandrel(function (model, _ref) {
    var renderSuper = _ref.renderSuper;
    var command = model.getValue();
    if (!command) {
      return renderSuper();
    }
    return Promise.all([command.toDisplayName(), command.toDescription()]).then(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        displayName = _ref3[0],
        description = _ref3[1];
      return renderSuper(function (state) {
        var properties = state.properties;
        var text = properties.text,
          tooltip = properties.tooltip,
          image = properties.image;
        var commandIcon = command.getIcon();
        properties.text = text || displayName;
        properties.tooltip = tooltip || description;
        if (!image || image.toString() === 'null') {
          properties.image = baja.$('gx:Image', commandIcon ? commandIcon.encodeToString() : 'null');
        }
        return state;
      });
    });
  }, {
    "extends": Button
  }));
});
