function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* global niagara */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/baja/binding/ValueBinding
 */
define(['baja!', 'lex!bajaui', 'log!nmodule/bajaui/rc/binding/baja/ValueBinding', 'Promise', 'nmodule/bajaui/rc/baja/binding/Binding', 'nmodule/bajaui/rc/binding/impl/widgetEvents', 'nmodule/converters/rc/Converter', 'nmodule/webEditors/rc/wb/ActionFirer', 'css!nmodule/bajaui/rc/bajaui'], function (baja, lexs, log, Promise, Binding, widgetEvents, Converter, ActionFirer) {
  'use strict';

  var logFine = log.fine.bind(log),
    logSevere = log.severe.bind(log);
  var _lexs = _slicedToArray(lexs, 1),
    bajauiLex = _lexs[0];

  /**
   * @class
   * @alias module:nmodule/bajaui/rc/baja/binding/ValueBinding
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   */
  return /*#__PURE__*/function (_Binding) {
    function ValueBinding() {
      var _this;
      _classCallCheck(this, ValueBinding);
      _this = _callSuper(this, ValueBinding, arguments);
      _this.$converters = {};
      return _this;
    }
    _inherits(ValueBinding, _Binding);
    return _createClass(ValueBinding, [{
      key: "targetChanged",
      value: function targetChanged() {
        return this.applySummary();
      }

      /**
       * Converts the bound `BObject` to a type that is compatible with the target
       * property on the bound `Widget`.
       *
       * @param {string} name
       * @returns {Promise.<*|null>}
       */
    }, {
      key: "provide",
      value: function provide(name) {
        var converter = this.getConverter(name);
        var to = this.getWidget().properties().getDefaultValue(name);
        if (!this.isBound() || !converter || to === null) {
          return null;
        }
        var context = Object.assign({
          $loadSlots: true
        }, this.getConverterContext());
        var ordTarget = this.getOrdTarget();
        var from = ordTarget.getObject();
        return Promise["try"](function () {
          return converter.convert(from, to, context);
        }).then(function (result) {
          if (typeof result === 'string') {
            result = result.replace(/\\n/g, '\n');
          }
          return result;
        })["catch"](function (e) {
          logFine(e);
          return null;
        });
      }

      /**
       * Add event listeners for the widget:
       *
       * - on click, hyperlink
       * - add CSS to indicate whether the hyperlink is active
       *
       * @param {module:bajaux/Widget} widget
       */
    }, {
      key: "addListeners",
      value: function addListeners(widget) {
        var _this2 = this;
        var events = {
          click: function click(e) {
            var hyperlink = getHyperlink(_this2);
            if (hyperlink) {
              e.preventDefault();
              return Promise["try"](function () {
                return niagara.env.hyperlink(hyperlink);
              })["catch"](logSevere);
            }
          },
          contextmenu: function contextmenu(e) {
            if (!_this2.isBound()) {
              return;
            }
            var popupEnabled = getPopupEnabled(_this2),
              comp = _this2.getOrdTarget().getComponent(),
              hasActionsToDisplay = comp && comp.getSlots().actions().filter(isActionVisible).toArray().length > 0;
            if (popupEnabled && hasActionsToDisplay) {
              e.preventDefault();
              ActionFirer.showActionDialog(comp);
              return false;
            }
          },
          initialized: function initialized() {
            widget.jq().addClass('ux-ValueBinding').toggleClass('-t-ValueBinding-hyperlink-target', !!getHyperlink(_this2));
          },
          destroyed: function destroyed() {
            widget.jq().removeClass('ux-ValueBinding -t-ValueBinding-hyperlink-target');
          }
        };
        this.addWidgetEvents(widget, events);
      }

      /**
       * @param {string} name slot name
       * @returns {module:nmodule/converters/rc/Converter|null}
       */
    }, {
      key: "getConverter",
      value: function getConverter(name) {
        var converter = this.get(name);
        return converter instanceof Converter ? converter : null;
      }

      /**
       * Gets the context for the binding.
       * @returns {Object|null} a context for the given converter.
       */
    }, {
      key: "getConverterContext",
      value: function getConverterContext() {
        var ordTarget = this.getOrdTarget();
        if (!ordTarget || !ordTarget.getFacets) {
          return null;
        }
        return ordTarget.getFacets().toObject();
      }

      /**
       * Applies summary to the 'title' attribute of the widget HTML
       * Subclasses can override this to handle how summary is applied
       * 
       * @returns {Promise}
       */
    }, {
      key: "applySummary",
      value: function applySummary() {
        var widget = this.getWidget();
        return toShowStatus(this).then(function (statusText) {
          // Replace newline and carriage return character with a new line character.
          statusText = statusText.replace(/\\n|\\r/g, '\n');
          widget.jq().attr("title", statusText);
        });
      }
    }]);
  }(Binding);
  function getHyperlink(binding) {
    var hyperlink = binding.get('hyperlink');
    return !hyperlink.isNull() && hyperlink;
  }
  function getPopupEnabled(binding) {
    var popupEnabled = binding.get('popupEnabled');
    return !!popupEnabled;
  }
  function toShowStatus(binding) {
    var hyperlink = getHyperlink(binding);
    return getSummary(binding).then(function (summary) {
      if (hyperlink) {
        return bajauiLex.get({
          key: 'uxMedia.ValueBinding.showStatusWithHyperlink',
          args: [hyperlink, summary]
        });
      }
      return summary;
    });
  }
  function getSummary(binding) {
    if (!binding.isBound()) {
      return Promise.resolve("");
    }
    var summaryFormat = binding.get('summary'),
      obj = {
        object: binding.getOrdTarget().getObject()
      };
    return summaryFormat.format(obj)["catch"](function (e) {
      logFine(e);
      return "";
    });
  }
  function isActionVisible(slot) {
    return !(slot.getFlags() & baja.Flags.HIDDEN);
  }
});
